/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.openapi.util.TextRange;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateJdbcUrlParser
extends StatelessParametersHolder.StatelessParametersHolderDelegate
implements JdbcUrlParser {
    private final TextDecomposition myTextDecomposition;
    private final StatelessTemplateJdbcUrlParser myStateless;

    public TemplateJdbcUrlParser(@NotNull StatelessTemplateJdbcUrlParser stateless) {
        if (stateless == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateless", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "<init>"));
        }
        this.myStateless = stateless;
        this.myTextDecomposition = new TextDecomposition(stateless.getDecomposition());
    }

    @Override
    protected StatelessParametersHolder getParametersHolderDelegate() {
        return this.myStateless;
    }

    @Override
    public void setUrlText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "setUrlText"));
        }
        this.myTextDecomposition.setText(text);
    }

    @Override
    public void setUrlTextTolerantly(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "setUrlTextTolerantly"));
        }
        this.myTextDecomposition.setTextTolerantly(text);
    }

    @Override
    @NotNull
    public String getUrlText() {
        String string = this.myTextDecomposition.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getUrlText"));
        }
        return string;
    }

    @Override
    public void validateParameters() {
        this.myTextDecomposition.validateParameters();
    }

    @Override
    @Nullable
    public TextRange getParameterRange(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getParameterRange"));
        }
        return this.myTextDecomposition.getParameterRange(name);
    }

    @Override
    public boolean isValid() {
        return this.myTextDecomposition.isValid();
    }

    @Override
    @NotNull
    public List<TextRange> getInvalidRanges() {
        List<TextRange> list = this.myTextDecomposition.getInvalidRanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getInvalidRanges"));
        }
        return list;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getParameter"));
        }
        return this.myTextDecomposition.getParameter(key);
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getPossibleLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.myStateless.getPossibleLocations();
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getPossibleLocations"));
        }
        return enumSet;
    }

    @Override
    public boolean isUrlValueValid(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "isUrlValueValid"));
        }
        return this.myStateless.isUrlValueValid(url);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myStateless.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcUrlParser createStatefull() {
        JdbcUrlParser jdbcUrlParser = this.myStateless.createStatefull();
        if (jdbcUrlParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "createStatefull"));
        }
        return jdbcUrlParser;
    }

    @Override
    public void setParameter(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "setParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/TemplateJdbcUrlParser", "setParameter"));
        }
        this.myTextDecomposition.setParameter(key, value);
    }
}

