/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dataSource.url.ui.SsrpHostParamEditor;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInstanceParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpInstance> {
    private final ActionButton myApplyButton;

    public SsrpInstanceParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "<init>"));
        }
        super(label, interchange);
        this.myApplyButton = this.addButton(new AnAction("Apply", "Apply instance parameters", AllIcons.Actions.Install){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SsrpInstanceParamEditor.this.isApplicable());
            }

            public void actionPerformed(AnActionEvent e) {
                SsrpInfo.SsrpServer server = SsrpInstanceParamEditor.this.getServer();
                SsrpInfo.SsrpInstance instance = server == null ? null : server.getInstance(SsrpInstanceParamEditor.this.getText());
                SsrpInstanceParamEditor.this.getInterchange().putProperty("port", instance == null ? null : instance.getAttribute("tcp"));
            }
        });
        this.setForceRefresh("Refresh");
        this.setValidateOnDirtyCompletion(true);
        this.addUpdateOnShow();
        this.setReportErrorOnAutoPopup(true);
        this.getInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor$2", "userDataChanged"));
                }
                if (changed != SsrpHostParamEditor.SSRP_INFO) {
                    return;
                }
                SsrpInstanceParamEditor.this.updateVariants();
            }
        }, this);
        this.getInterchange().addPropertyChangeListener("host", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SsrpInstanceParamEditor.this.updateVariants();
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(new EditorSettingsProvider(){

            public void customizeSettings(EditorEx editor) {
                SsrpInstanceParamEditor.this.updateHighlighting((Editor)editor);
            }
        });
    }

    private void updateVariants() {
        try {
            this.setVariantsAndCompletionVariants((List)ObjectUtils.chooseNotNull(this.getVariants(false), Collections.emptyList()));
        }
        catch (Exception e) {
            this.setVariantsAndCompletionVariants(Collections.emptyList());
        }
    }

    protected void updateHighlighting(@Nullable Editor editor) {
        String error;
        if (editor == null) {
            return;
        }
        editor.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer server = this.getServer();
        SsrpInfo.SsrpInstance inst = server == null ? null : server.getInstance(this.getText());
        String string = error = server == null ? null : server.getError();
        if (error == null && (server == null || inst != null) || StringUtil.isEmptyOrSpaces((String)this.getText())) {
            editor.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
        String msg = "UnknownHost".equals(error) ? "Unable to contact Browser Service: Unknown Host" : ("NoResponse".equals(error) ? "Unable to contact Browser Service: No Response" : "No such instance");
        editor.getContentComponent().setToolTipText(msg);
        TextAttributes attributes = editor.getColorsScheme().getAttributes(key);
        editor.getMarkupModel().addRangeHighlighter(0, editor.getDocument().getTextLength(), 4000, attributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    @Nullable
    protected List<SsrpInfo.SsrpInstance> getVariants(@NotNull ProgressIndicator indicator, @NotNull Map<Key, ?> options) throws Exception {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getVariants"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getVariants"));
        }
        List<SsrpInfo.SsrpInstance> res = this.getVariants(false);
        if (res == null) {
            res = this.getVariants(true);
        }
        if (res == null) {
            res = Collections.emptyList();
        }
        return res;
    }

    @Nullable
    protected List<SsrpInfo.SsrpInstance> getVariants(boolean forced) throws Exception {
        String host = this.getInterchange().getProperty("host");
        if (StringUtil.isEmptyOrSpaces((String)host)) {
            return null;
        }
        SsrpInfo.SsrpServer server = this.getServer();
        if (server == null && forced) {
            SsrpInfoCache.updateHost(false, host);
            server = this.getServer();
        }
        return server == null ? null : ContainerUtil.newArrayList(server.getInstances());
    }

    @Override
    @Nullable
    protected String getTypeText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getTypeText"));
        }
        return item.getAttribute("Version");
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpInstance item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getText"));
        }
        String string = item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "getText"));
        }
        return string;
    }

    private void updateButton() {
        this.myApplyButton.addNotify();
    }

    private boolean isApplicable() {
        return this.getItemByText(this.getText()) != null;
    }

    @Nullable
    private SsrpInfo.SsrpServer getServer() {
        SsrpInfo info = (SsrpInfo)SsrpHostParamEditor.SSRP_INFO.get((UserDataHolder)this.getInterchange());
        String host = this.getInterchange().getProperty("host");
        return info == null || host == null ? null : info.getServer(host);
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpInstance> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/SsrpInstanceParamEditor", "setVariants"));
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
        this.updateButton();
    }

    @Override
    protected void fireChanged() {
        super.fireChanged();
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
        this.updateButton();
    }
}

