/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxEditor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpdateableCBParamEditor
extends ParamEditorBase<ComboBox> {
    public UpdateableCBParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor", "<init>"));
        }
        super(new ComboBox(), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, label, new AnAction[0]);
        ((ComboBox)this.getEditorComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (e.getItem() != null) {
                    UpdateableCBParamEditor.this.setText(StringUtil.notNullize((String)UpdateableCBParamEditor.this.getTextFromItem(e.getItem())));
                }
                UpdateableCBParamEditor.this.fireChanged();
            }
        });
    }

    protected void addManualUpdate(@NotNull String tip) {
        if (tip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tip", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor", "addManualUpdate"));
        }
        this.addButton(new AnAction(tip, tip, AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                UpdateableCBParamEditor.this.updateModel();
            }
        });
    }

    protected void addUpdateOnShow() {
        new UiNotifyConnector(this.getEditorComponent(), new Activatable(){

            public void showNotify() {
                UpdateableCBParamEditor.this.updateModelAtShow();
            }

            public void hideNotify() {
            }
        });
    }

    @Override
    public void setActive(boolean active) {
        Color background = UpdateableCBParamEditor.getBackground(active);
        ((ComboBox)this.getEditorComponent()).setBackground(background);
        ComboBoxEditor editor = ((ComboBox)this.getEditorComponent()).getEditor();
        if (editor != null) {
            editor.getEditorComponent().setBackground(background);
        }
    }

    protected abstract void updateModel();

    protected void updateModelAtShow() {
        this.updateModel();
    }

    @Nullable
    protected abstract String getTextFromItem(@Nullable Object var1);

    @Nullable
    protected abstract Object getItemFromText(@Nullable String var1);

    @Override
    public void addFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor", "addFocusListener"));
        }
        super.addFocusListener(listener);
        if (((ComboBox)this.getEditorComponent()).getEditor() != null) {
            ((ComboBox)this.getEditorComponent()).getEditor().getEditorComponent().addFocusListener(listener);
        }
    }

    protected class MyComboBoxEditor
    extends FixedComboBoxEditor {
        public MyComboBoxEditor() {
            this.getField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    UpdateableCBParamEditor.this.fireChanged();
                }
            });
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor$MyComboBoxEditor", "setText"));
            }
            this.getField().setText(text);
        }

        @NotNull
        public String getText() {
            String string = this.getField().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/UpdateableCBParamEditor$MyComboBoxEditor", "getText"));
            }
            return string;
        }

        public void setItem(Object anObject) {
            String text = StringUtil.notNullize((String)UpdateableCBParamEditor.this.getTextFromItem(anObject));
            if (!text.equals(this.getField().getText())) {
                this.getField().setText(text);
            }
        }

        public Object getItem() {
            return UpdateableCBParamEditor.this.getItemFromText(this.getField().getText());
        }
    }
}

