/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DataSourceValidator {
    public static final ExtensionPointName<DataSourceValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.dataSourceValidator");

    public abstract void findProblems(@NotNull Object var1, @NotNull Consumer<DataSourceProblem> var2);

    public static Set<DataSourceProblem> getProblems(@NotNull Object dataSource) {
        DataSourceValidator[] extensions;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/DataSourceValidator", "getProblems"));
        }
        final HashSet result = ContainerUtil.newHashSet();
        Consumer<DataSourceProblem> consumer = new Consumer<DataSourceProblem>(){

            public void consume(DataSourceProblem problem) {
                result.add(problem);
            }
        };
        for (DataSourceValidator extension : extensions = (DataSourceValidator[])Extensions.getExtensions(EP_NAME)) {
            extension.findProblems(dataSource, consumer);
        }
        return result;
    }
}

