/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.ConsumerRunnable;
import org.jetbrains.concurrency.Promise;

public abstract class DataBusGridDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements DataRequest.OwnerEx {
    protected final AtomicReference<DataRequest.TxMarker> myTxMarker;
    protected final DataBus.Consuming myMessageBus;
    protected final DataProducer myProducer;
    protected final DataAuditor.BusyCounter myBusyCounter;
    protected final DataGridListModel myModel;
    protected final GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    protected final DataBusLoader myLoader;
    protected final Map<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>> myRequestSourceMap;

    protected DataBusGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataBusGridDataHookUp", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/DataBusGridDataHookUp", "<init>"));
        }
        super(project);
        this.myTxMarker = new AtomicReference<DataRequest.TxMarker>(DataRequest.AUTO_COMMIT);
        this.myRequestSourceMap = new WeakHashMap<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>>();
        this.myMessageBus = messageBus.filterFor(this);
        this.myProducer = messageBus.getDataProducer();
        this.myBusyCounter = new DataAuditor.BusyCounter(this);
        this.myModel = new DataGridListModel();
        this.myPageModel = new GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column>(this.myModel);
        this.myLoader = this.createLoader();
        this.myMessageBus.addAuditor(new DataAuditor.Adapter(){

            @Override
            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$1", "error"));
                }
                GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request);
                if (source != null) {
                    DataBusGridDataHookUp.this.notifyRequestError(source, message, th);
                }
            }

            @Override
            public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$1", "updateCountReceived"));
                }
                GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request);
                if (source != null) {
                    DataBusGridDataHookUp.this.notifyUpdateCountReceived(source, updateCount);
                }
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$1", "requestStarted"));
                }
                DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
            }

            @Override
            public void txCompleted(@NotNull DataRequest.Context context, boolean committed) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$1", "txCompleted"));
                }
                DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW);
                if (!committed) {
                    DataBusGridDataHookUp.this.myLoader.updateQueryText();
                    String query = (String)ObjectUtils.assertNotNull((Object)DataBusGridDataHookUp.this.myLoader.getQueryText());
                    int startIdx = DataBusGridDataHookUp.this.myPageModel.getPageStart();
                    int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
                    int resultSetIdx = DataBusGridDataHookUp.this.myLoader.getResultSetIndex();
                    DataRequest.Constraints constraints = DataRequest.newConstraints(startIdx, pageSize, resultSetIdx);
                    DataRequest request = DataRequest.newRequest(DataBusGridDataHookUp.this, DataRequest.AUTO_COMMIT, query, constraints);
                    request.getPromise().processed((Consumer)new ConsumerRunnable(){

                        public void run() {
                            DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW);
                        }
                    });
                    DataBusGridDataHookUp.this.myProducer.processRequest(request);
                }
            }
        });
        this.myMessageBus.addConsumer(DataGridUtil.createEDTSafeWrapper(this.myLoader, this));
    }

    @NotNull
    public DataGridListModel getModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "getModel"));
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> multiPage = this.myPageModel;
        if (multiPage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "getPageModel"));
        }
        return multiPage;
    }

    @NotNull
    public DataBusLoader getLoader() {
        DataBusLoader dataBusLoader = this.myLoader;
        if (dataBusLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "getLoader"));
        }
        return dataBusLoader;
    }

    @Override
    public int getBusyCount() {
        return this.myBusyCounter.getCount();
    }

    @Override
    public void cancelRequests() {
        this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(this));
    }

    @Override
    public DataBus.Consuming getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.myTxMarker.get();
        if (txMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "getCurrentTx"));
        }
        return txMarker;
    }

    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/datagrid/DataBusGridDataHookUp", "setCurrentTx"));
        }
        this.myTxMarker.set(txMarker);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myLoader.getQueryText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "getDisplayName"));
        }
        return string;
    }

    public void dispose() {
    }

    public int getResultSetIndex() {
        return this.myLoader.getResultSetIndex();
    }

    @Nullable
    public String getQueryText() {
        return this.myLoader.getQueryText();
    }

    @NotNull
    protected DataBusLoader createLoader() {
        DataBusLoader dataBusLoader = new DataBusLoader();
        if (dataBusLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp", "createLoader"));
        }
        return dataBusLoader;
    }

    protected void processRequest(final @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, final @NotNull DataRequest request, final ReloadPolicy reloadPolicy) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp", "processRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataBusGridDataHookUp", "processRequest"));
        }
        this.myRequestSourceMap.put(request, source);
        request.getPromise().processed((Consumer)new ConsumerRunnable(){

            public void run() {
                boolean isDone;
                boolean bl = isDone = request.getPromise().getState() == Promise.State.FULFILLED;
                if (reloadPolicy == ReloadPolicy.WHEN_PROCESSED || reloadPolicy == ReloadPolicy.WHEN_DONE && isDone) {
                    DataBusGridDataHookUp.this.myLoader.reloadCurrentPage(source);
                } else {
                    DataBusGridDataHookUp.this.notifyRequestFinished(source, isDone);
                }
            }
        });
        this.myProducer.processRequest(request);
    }

    protected static enum ReloadPolicy {
        WHEN_DONE,
        WHEN_PROCESSED,
        DO_NOT_RELOAD;

    }

    public class DataBusLoader
    implements DataConsumer,
    GridLoader<DataConsumer.Row, DataConsumer.Column> {
        private String myQueryText;
        private boolean myQueryInvalidated;
        private boolean myTotalRowCountInvalidated;
        private int myResultSetIndex;
        private int myRowsLoaded = -1;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "setColumns"));
            }
            boolean sameQuery = Comparing.equal((String)this.myQueryText, (String)context.getQuery());
            if (!sameQuery || this.myTotalRowCountInvalidated) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(0, false);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageStart(firstRowNum);
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(firstRowNum - 1);
            this.myRowsLoaded = 0;
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(true);
            this.myResultSetIndex = resultSetIndex;
            this.setQueryText(context.getQuery());
            DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
            columns = this.prepareColumns(columns);
            boolean sameColumns = this.sameColumnsAsInModel(columns);
            if (!sameQuery || !sameColumns) {
                DataBusGridDataHookUp.this.myModel.removeRows(0, DataBusGridDataHookUp.this.myModel.getRowCount());
                DataBusGridDataHookUp.this.myModel.setColumns(Arrays.asList(columns));
            }
            this.validateRowCount();
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "addRows"));
            }
            if (rows.isEmpty()) {
                return;
            }
            if (this.myRowsLoaded == 0) {
                DataBusGridDataHookUp.this.myPageModel.setPageStart(rows.get((int)0).rowNum);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(rows.get((int)(rows.size() - 1)).rowNum);
            DataBusGridDataHookUp.this.myModel.setRows(this.myRowsLoaded, rows);
            this.myRowsLoaded += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "afterLastRowAdded"));
            }
            if (this.myRowsLoaded >= 0 && this.myRowsLoaded < DataBusGridDataHookUp.this.myModel.getRowCount()) {
                int rowsToRemove = DataBusGridDataHookUp.this.myModel.getRowCount() - this.myRowsLoaded;
                DataBusGridDataHookUp.this.myModel.removeRows(DataBusGridDataHookUp.this.myModel.getRowCount() - rowsToRemove, rowsToRemove);
            }
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(false);
            if (total > DataBusGridDataHookUp.this.myPageModel.getTotalRowCount() || DataBusGridDataHookUp.this.myPageModel.getPageEnd() == total) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(total, DataBusGridDataHookUp.this.myPageModel.getPageEnd() >= total);
            }
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "reloadCurrentPage"));
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageStart(), true);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "loadNextPage"));
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageEnd() + 1, true);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "loadPreviousPage"));
            }
            this.load(source, Math.max(1, DataBusGridDataHookUp.this.myPageModel.getPageStart()), false);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "loadLastPage"));
            }
            int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
            this.load(source, -(pageSize > 0 ? pageSize : 100), true);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "loadFirstPage"));
            }
            this.load(source, 1, true);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int rowDataIdx) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "load"));
            }
            this.load(source, rowDataIdx, true);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "updateTotalRowCount"));
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "applyFilter"));
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Nullable
        public String getQueryText() {
            return this.myQueryText;
        }

        public int getResultSetIndex() {
            return this.myResultSetIndex;
        }

        @NotNull
        protected Promise<Void> load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex, boolean forward) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "load"));
            }
            this.updateQueryText();
            if (this.myQueryText == null) {
                DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
                Promise promise = Promise.REJECTED;
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "load"));
                }
                return promise;
            }
            DataBusGridDataHookUp owner = DataBusGridDataHookUp.this;
            DataRequest r = DataRequest.newRequest(owner, this.myQueryText, startIndex, forward, DataBusGridDataHookUp.this.myPageModel.getPageSize(), this.myResultSetIndex);
            DataBusGridDataHookUp.this.processRequest(source, r, ReloadPolicy.DO_NOT_RELOAD);
            AsyncPromise<Void> asyncPromise = r.getPromise();
            if (asyncPromise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "load"));
            }
            return asyncPromise;
        }

        protected void updateQueryText() {
        }

        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader", "prepareColumns"));
            }
            return columns;
        }

        protected void setQueryText(String query) {
            this.myQueryText = query;
            this.validateQuery();
        }

        protected void invalidateQuery() {
            this.myQueryInvalidated = true;
        }

        protected void invalidateRowCount() {
            this.myTotalRowCountInvalidated = true;
        }

        protected boolean isQueryInvalidated() {
            return this.myQueryInvalidated;
        }

        protected boolean sameColumnsAsInModel(DataConsumer.Column[] columns) {
            if (columns.length != DataBusGridDataHookUp.this.myModel.getColumnCount()) {
                return false;
            }
            for (int i = 0; i < columns.length; ++i) {
                if (Comparing.equal((Object)columns[i], (Object)DataBusGridDataHookUp.this.myModel.getColumn(ModelIndex.forColumn(DataBusGridDataHookUp.this.myModel, i)))) continue;
                return false;
            }
            return true;
        }

        private void validateQuery() {
            this.myQueryInvalidated = false;
        }

        private void validateRowCount() {
            this.myTotalRowCountInvalidated = false;
        }
    }
}

