/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentDataHookUp
extends DocumentDataHookUp {
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private final SqlReader myReader;
    private final SqlLanguageDialect myDialect;

    public SqlDocumentDataHookUp(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "<init>"));
        }
        super(project, document, range);
        this.myReader = SqlPsiFacade.getInstance((Project)project).createSqlReader();
        this.myDialect = dialect;
    }

    @Override
    @Nullable
    protected SqlInsertsMarkup buildMarkup(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "buildMarkup"));
        }
        return SqlDocumentDataHookUp.buildMarkup(sequence, this.myReader, this.myDialect);
    }

    @Nullable
    static SqlInsertsMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull SqlReader reader, final @NotNull SqlLanguageDialect dialect) {
        Ref insertTargetRef;
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "buildMarkup"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "buildMarkup"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "buildMarkup"));
        }
        JBIterable inserts = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)reader.getReadOnlyPsi(dialect, sequence))).forceDisregardTypes(Conditions.is((Object)GeneratedParserUtilBase.DUMMY_BLOCK)).expandAndSkip(Conditions.instanceOf(SqlBatchBlock.class))).filter(SqlInsertStatement.class);
        List blocks = ContainerUtil.mapNotNull((Iterable)inserts, (Function)new Function<SqlInsertStatement, Block>(insertTargetRef = Ref.create()){
            final /* synthetic */ Ref val$insertTargetRef;
            {
                this.val$insertTargetRef = ref;
            }

            public Block fun(SqlInsertStatement insertStatement) {
                return SqlDocumentDataHookUp.parseBlock(insertStatement, dialect, (Ref<InsertTarget>)this.val$insertTargetRef);
            }
        });
        return ContainerUtil.isEmpty((Collection)blocks) ? null : new SqlInsertsMarkup(sequence, blocks, (InsertTarget)insertTargetRef.get());
    }

    @Nullable
    private static Block parseBlock(@NotNull SqlInsertStatement insertStatement, @NotNull SqlLanguageDialect dialect, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertStatement", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseBlock"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseBlock"));
        }
        if (insertTargetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertTargetRef", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseBlock"));
        }
        return SqlDocumentDataHookUp.isOracleInsertAllStatement(insertStatement, dialect) ? SqlDocumentDataHookUp.parseMultiTableInsertBlock(insertStatement, insertTargetRef) : SqlDocumentDataHookUp.parseInsertBlock(insertStatement, insertTargetRef);
    }

    private static boolean isOracleInsertAllStatement(@NotNull SqlInsertStatement statement, @NotNull SqlLanguageDialect dialect) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "isOracleInsertAllStatement"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "isOracleInsertAllStatement"));
        }
        return dialect.getDatabaseDialect().getFamilyId().isOracle() && statement.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_ALL})).length != 0;
    }

    @Nullable
    private static Block parseMultiTableInsertBlock(@NotNull SqlInsertStatement insertStatement, final @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertStatement", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseMultiTableInsertBlock"));
        }
        if (insertTargetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertTargetRef", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseMultiTableInsertBlock"));
        }
        List instructions = insertStatement.getDmlInstructions();
        List insertBlocks = ContainerUtil.mapNotNull((Collection)instructions, (Function)new Function<SqlDmlInstruction, InsertBlock>(){

            public InsertBlock fun(SqlDmlInstruction instruction) {
                return SqlDocumentDataHookUp.parseInsertBlock(instruction, (Ref<InsertTarget>)insertTargetRef, null, null);
            }
        });
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return insertBlocks.isEmpty() ? null : new MultiTableInsertBlock(insertStatement.getTextRange(), insertBlocks, separatorRange, instructions.size());
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlInsertStatement insertStatement, @NotNull Ref<InsertTarget> insertTargetRef) {
        if (insertStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertStatement", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseInsertBlock"));
        }
        if (insertTargetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertTargetRef", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseInsertBlock"));
        }
        List dmlInstructions = insertStatement.getDmlInstructions();
        TextRange separatorRange = SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)insertStatement, SEMICOLON);
        return dmlInstructions.size() != 1 ? null : SqlDocumentDataHookUp.parseInsertBlock((SqlDmlInstruction)dmlInstructions.get(0), insertTargetRef, insertStatement.getTextRange(), separatorRange);
    }

    @Nullable
    private static InsertBlock parseInsertBlock(@NotNull SqlDmlInstruction instruction, @NotNull Ref<InsertTarget> insertTargetRef, @Nullable TextRange insertStatementRange, @Nullable TextRange separatorRange) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseInsertBlock"));
        }
        if (insertTargetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertTargetRef", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseInsertBlock"));
        }
        SqlTableColumnsList columnsList = (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlTableColumnsList.class);
        if (columnsList == null || !insertTargetRef.isNull() && !((InsertTarget)insertTargetRef.get()).matches(columnsList)) {
            return null;
        }
        List<TextRange> columns = SqlDocumentDataHookUp.parseColumns(columnsList);
        List valuesBlocks = SqlDocumentDataHookUp.parseValuesBlocks(instruction, (InsertTarget)insertTargetRef.get());
        if (valuesBlocks.isEmpty()) {
            return null;
        }
        if (insertTargetRef.isNull()) {
            final int columnCount = columns != null ? columns.size() : valuesBlocks.get((int)0).values.size();
            insertTargetRef.set((Object)InsertTarget.create(columnsList, columnCount));
            if (insertTargetRef.isNull()) {
                return null;
            }
            valuesBlocks = ContainerUtil.filter(valuesBlocks, (Condition)new Condition<ValuesBlock>(){

                public boolean value(ValuesBlock block) {
                    return block.values.size() == columnCount;
                }
            });
        }
        TextRange range = insertStatementRange != null ? insertStatementRange : instruction.getTextRange();
        return new InsertBlock(range, valuesBlocks, columns, separatorRange);
    }

    @Nullable
    private static List<TextRange> parseColumns(@Nullable SqlTableColumnsList columnsList) {
        SqlReferenceList referenceList = columnsList != null ? columnsList.getColumnsReferenceList() : null;
        return referenceList == null ? null : ContainerUtil.map((Collection)referenceList.getReferenceList(), (Function)new Function<SqlReferenceExpression, TextRange>(){

            public TextRange fun(SqlReferenceExpression columnRef) {
                return columnRef.getTextRange();
            }
        });
    }

    @NotNull
    private static List<ValuesBlock> parseValuesBlocks(@NotNull SqlDmlInstruction instruction, @Nullable InsertTarget insertTarget) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseValuesBlocks"));
        }
        SqlValuesExpression valuesExpression = (SqlValuesExpression)PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlValuesExpression.class);
        if (valuesExpression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseValuesBlocks"));
            }
            return list;
        }
        List valuesBlocks = ContainerUtil.newSmartList();
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            ContainerUtil.addIfNotNull((Collection)valuesBlocks, (Object)SqlDocumentDataHookUp.parseValuesBlock(expression, insertTarget));
        }
        List list = valuesBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseValuesBlocks"));
        }
        return list;
    }

    @Nullable
    private static ValuesBlock parseValuesBlock(@NotNull SqlExpression expression, @Nullable InsertTarget insertTarget) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "parseValuesBlock"));
        }
        SqlParenthesizedExpression tuple = (SqlParenthesizedExpression)ObjectUtils.tryCast((Object)expression, SqlParenthesizedExpression.class);
        if (tuple == null || insertTarget != null && !insertTarget.matches(tuple)) {
            return null;
        }
        TextRange range = expression.getTextRange();
        List valueRanges = ContainerUtil.map((Collection)tuple.getExpressionList(), (Function)new Function<SqlExpression, TextRange>(){

            public TextRange fun(SqlExpression expression) {
                return expression.getTextRange();
            }
        });
        return new ValuesBlock(range, valueRanges, SqlDocumentDataHookUp.getFollowingSeparatorRange((PsiElement)expression, COMMA));
    }

    @Nullable
    private static TextRange getFollowingSeparatorRange(@NotNull PsiElement element, @NotNull String separatorText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "getFollowingSeparatorRange"));
        }
        if (separatorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorText", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "getFollowingSeparatorRange"));
        }
        PsiElement separator = SqlDocumentDataHookUp.getFollowingSeparator(element, separatorText);
        return separator != null ? separator.getTextRange() : null;
    }

    @Nullable
    private static PsiElement getFollowingSeparator(@NotNull PsiElement element, @NotNull String separatorText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "getFollowingSeparator"));
        }
        if (separatorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorText", "com/intellij/database/datagrid/SqlDocumentDataHookUp", "getFollowingSeparator"));
        }
        PsiElement separator = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        return separator != null && separatorText.equals(separator.getText()) ? separator : null;
    }

    private static class InsertTarget {
        private final String myTableIdentity;
        private final List<String> myColumnIdentities;
        private final int myColumnCount;

        private InsertTarget(@NotNull String tableIdentity, @Nullable List<String> columnIdentities, int count) {
            if (tableIdentity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableIdentity", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget", "<init>"));
            }
            this.myTableIdentity = tableIdentity;
            this.myColumnIdentities = columnIdentities;
            this.myColumnCount = count;
        }

        public boolean matches(@Nullable SqlTableColumnsList tableColumnsList) {
            return tableColumnsList != null && this.myTableIdentity.equals(InsertTarget.getTableIdentity(tableColumnsList)) && Comparing.equal(this.myColumnIdentities, InsertTarget.getColumnIdentities(tableColumnsList));
        }

        public boolean matches(@Nullable SqlParenthesizedExpression valuesTuple) {
            return valuesTuple != null && valuesTuple.getExpressionList().size() == this.myColumnCount;
        }

        @NotNull
        public String getTableRefText() {
            String string = this.myTableIdentity;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget", "getTableRefText"));
            }
            return string;
        }

        public boolean isColumnListPresent() {
            return this.myColumnIdentities != null;
        }

        @Nullable
        public static InsertTarget create(@Nullable SqlTableColumnsList tableColumnsList, int columnCount) {
            if (tableColumnsList == null) {
                return null;
            }
            String tableIdentity = InsertTarget.getTableIdentity(tableColumnsList);
            if (tableIdentity == null) {
                return null;
            }
            List<String> columnIdentities = InsertTarget.getColumnIdentities(tableColumnsList);
            return columnIdentities != null && columnIdentities.size() != columnCount ? null : new InsertTarget(tableIdentity, columnIdentities, columnCount);
        }

        @Nullable
        private static List<String> getColumnIdentities(@NotNull SqlTableColumnsList tableColumnsList) {
            if (tableColumnsList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableColumnsList", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget", "getColumnIdentities"));
            }
            SqlReferenceList columnRefs = tableColumnsList.getColumnsReferenceList();
            return columnRefs == null ? null : ContainerUtil.map((Collection)columnRefs.getReferenceList(), (Function)new Function<SqlReferenceExpression, String>(){

                public String fun(SqlReferenceExpression expression) {
                    return expression.getText();
                }
            });
        }

        @Nullable
        private static String getTableIdentity(@NotNull SqlTableColumnsList tableColumnsList) {
            if (tableColumnsList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableColumnsList", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertTarget", "getTableIdentity"));
            }
            SqlReferenceExpression tableReference = tableColumnsList.getTableReference();
            return tableReference != null ? tableReference.getText() : null;
        }
    }

    static class RecursiveBlockVisitor {
        RecursiveBlockVisitor() {
        }

        protected boolean visitBlock(@NotNull Block block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor", "visitBlock"));
            }
            return true;
        }

        protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor", "visitValuesBlock"));
            }
            return true;
        }

        protected boolean visitInsertBlock(@NotNull InsertBlock block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor", "visitInsertBlock"));
            }
            return this.visitBlocks(block.valuesBlocks);
        }

        protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor", "visitInsertAllBlock"));
            }
            return this.visitBlocks(block.insertBlocks);
        }

        public boolean visitBlocks(@NotNull Iterable<? extends Block> blocks) {
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$RecursiveBlockVisitor", "visitBlocks"));
            }
            for (Block block : blocks) {
                if (block.accept(this)) continue;
                return false;
            }
            return true;
        }
    }

    static class MultiTableInsertBlock
    extends Block {
        public final List<InsertBlock> insertBlocks;
        public final int totalInsertBlocksCount;

        MultiTableInsertBlock(@NotNull TextRange range, @NotNull List<InsertBlock> insertBlocks, @Nullable TextRange separatorRange, int totalInsertBlocksCount) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/SqlDocumentDataHookUp$MultiTableInsertBlock", "<init>"));
            }
            if (insertBlocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertBlocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$MultiTableInsertBlock", "<init>"));
            }
            super(range, separatorRange);
            this.insertBlocks = insertBlocks;
            this.totalInsertBlocksCount = totalInsertBlocksCount;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/datagrid/SqlDocumentDataHookUp$MultiTableInsertBlock", "accept"));
            }
            return visitor.visitInsertAllBlock(this);
        }
    }

    static class InsertBlock
    extends Block {
        public final List<ValuesBlock> valuesBlocks;
        public final List<TextRange> columns;

        InsertBlock(@NotNull TextRange range, @NotNull List<ValuesBlock> blocks, @Nullable List<TextRange> columns, @Nullable TextRange separatorRange) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertBlock", "<init>"));
            }
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertBlock", "<init>"));
            }
            super(range, separatorRange);
            this.columns = columns;
            this.valuesBlocks = blocks;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/datagrid/SqlDocumentDataHookUp$InsertBlock", "accept"));
            }
            return visitor.visitInsertBlock(this);
        }
    }

    static class ValuesBlock
    extends Block {
        public final List<TextRange> values;

        ValuesBlock(@NotNull TextRange range, @NotNull List<TextRange> values, @Nullable TextRange separatorRange) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/SqlDocumentDataHookUp$ValuesBlock", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/SqlDocumentDataHookUp$ValuesBlock", "<init>"));
            }
            super(range, separatorRange);
            this.values = values;
        }

        @Override
        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/datagrid/SqlDocumentDataHookUp$ValuesBlock", "accept"));
            }
            return visitor.visitValuesBlock(this);
        }
    }

    static class Block {
        public final TextRange range;
        public final TextRange separatorRange;

        Block(@NotNull TextRange range, @Nullable TextRange separatorRange) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/SqlDocumentDataHookUp$Block", "<init>"));
            }
            this.range = range;
            this.separatorRange = separatorRange;
        }

        public boolean accept(@NotNull RecursiveBlockVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/database/datagrid/SqlDocumentDataHookUp$Block", "accept"));
            }
            return visitor.visitBlock(this);
        }
    }

    static class SqlInsertsMarkup
    extends DocumentDataHookUp.DataMarkup {
        public final InsertTarget insertTarget;
        public final List<Block> blocks;

        public SqlInsertsMarkup(@NotNull CharSequence sequence, @NotNull List<Block> blocks, @NotNull InsertTarget insertTarget) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "<init>"));
            }
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "<init>"));
            }
            if (insertTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertTarget", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "<init>"));
            }
            super(SqlInsertsMarkup.columnsFromBlocks(sequence, blocks), SqlInsertsMarkup.rowsFromBlocks(sequence, blocks));
            this.blocks = blocks;
            this.insertTarget = insertTarget;
        }

        @Override
        protected boolean deleteRows(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<DataConsumer.Row> sortedRows) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "deleteRows"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "deleteRows"));
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex;
                private int myValuesTupleIdx;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1", "visitValuesBlock"));
                    }
                    ++this.myValuesTupleIdx;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1", "visitInsertBlock"));
                    }
                    List<ValuesBlock> tuples = block.valuesBlocks;
                    if (this.shouldDeleteNextValuesTuples(tuples.size())) {
                        return this.deleteBlockAndAdvance(block, tuples.size());
                    }
                    int leftToDeleteInThisBlock = 0;
                    for (int rowIdx = this.myRowIndex; rowIdx < sortedRows.size(); ++rowIdx) {
                        DataConsumer.Row row = (DataConsumer.Row)sortedRows.get(rowIdx);
                        int blockIdx = row.rowNum - 1;
                        if (blockIdx >= this.myValuesTupleIdx + tuples.size()) break;
                        ++leftToDeleteInThisBlock;
                    }
                    for (int tupleIdx = 0; tupleIdx < tuples.size() && leftToDeleteInThisBlock > 0; ++tupleIdx) {
                        boolean deleteAllSubsequentTuples;
                        ValuesBlock currentTuple = tuples.get(tupleIdx);
                        int nextTupleIdxToDelete = ((DataConsumer.Row)sortedRows.get((int)this.myRowIndex)).rowNum - 1 - this.myValuesTupleIdx;
                        if (tupleIdx == nextTupleIdxToDelete) {
                            this.deleteBlockAndAdvance(currentTuple, 1);
                            --leftToDeleteInThisBlock;
                            continue;
                        }
                        boolean bl = deleteAllSubsequentTuples = leftToDeleteInThisBlock == tuples.size() - tupleIdx - 1 && tupleIdx + 1 == nextTupleIdxToDelete;
                        if (deleteAllSubsequentTuples) {
                            ValuesBlock lastTuple = tuples.get(tuples.size() - 1);
                            int startOffset = currentTuple.separatorRange != null ? currentTuple.separatorRange.getStartOffset() : tuples.get((int)nextTupleIdxToDelete).range.getStartOffset();
                            int endOffset = lastTuple.separatorRange != null ? lastTuple.separatorRange.getEndOffset() : lastTuple.range.getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            this.myRowIndex += leftToDeleteInThisBlock;
                            this.myValuesTupleIdx += leftToDeleteInThisBlock;
                            break;
                        }
                        ++this.myValuesTupleIdx;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1", "visitInsertAllBlock"));
                    }
                    int intoBlocksCount = block.insertBlocks.size();
                    return block.totalInsertBlocksCount == intoBlocksCount && this.shouldDeleteNextValuesTuples(intoBlocksCount) ? this.deleteBlockAndAdvance(block, intoBlocksCount) : super.visitInsertAllBlock(block);
                }

                private boolean shouldDeleteNextValuesTuples(int count) {
                    int currentRowNum;
                    int previousRowNum;
                    int nextValuesBlockIndex = ((DataConsumer.Row)sortedRows.get((int)this.myRowIndex)).rowNum - 1;
                    if (nextValuesBlockIndex != this.myValuesTupleIdx) {
                        return false;
                    }
                    int consecutiveRowsToDelete = 1;
                    for (int rowIdx = this.myRowIndex + 1; rowIdx < sortedRows.size() && consecutiveRowsToDelete != count && (previousRowNum = ((DataConsumer.Row)sortedRows.get((int)(rowIdx - 1))).rowNum) == (currentRowNum = ((DataConsumer.Row)sortedRows.get((int)rowIdx)).rowNum) - 1; ++consecutiveRowsToDelete, ++rowIdx) {
                    }
                    return count == consecutiveRowsToDelete;
                }

                private boolean deleteBlockAndAdvance(@NotNull Block block, int rows) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$1", "deleteBlockAndAdvance"));
                    }
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                    this.myRowIndex += rows;
                    this.myValuesTupleIdx += rows;
                    return this.myRowIndex < sortedRows.size();
                }
            }.visitBlocks(this.blocks);
            return false;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "insertRow"));
            }
            this.insertRow(session, JBIterable.of((Object[])new String[]{"NULL"}).repeat(this.columns.size()).toList());
            return true;
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Row row) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "cloneRow"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "cloneRow"));
            }
            this.insertRow(session, ContainerUtil.map((Object[])row.values, (Function)Functions.TO_STRING()));
            return true;
        }

        @Override
        protected boolean deleteColumns(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<DataConsumer.Column> sortedColumns) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "deleteColumns"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "deleteColumns"));
            }
            if (sortedColumns.size() == this.columns.size()) {
                for (Block block : this.blocks) {
                    TextRange range = block.separatorRange != null ? block.range.union(block.separatorRange) : block.range;
                    session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, range));
                }
                return true;
            }
            new RecursiveBlockVisitor(){
                private final int myLastColumnToLeaveIdx;
                {
                    int columnCount = columns.size();
                    int tailColumnsToDelete = 0;
                    for (int i = 0; i < sortedColumns.size() && ((DataConsumer.Column)sortedColumns.get((int)(sortedColumns.size() - i - 1))).columnNum == columnCount - i - 1; ++i) {
                        ++tailColumnsToDelete;
                    }
                    this.myLastColumnToLeaveIdx = columnCount - tailColumnsToDelete - 1;
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$2", "visitValuesBlock"));
                    }
                    this.deleteColumns(block.values);
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$2", "visitInsertBlock"));
                    }
                    this.deleteColumns(block.columns);
                    return super.visitInsertBlock(block);
                }

                private void deleteColumns(@NotNull List<TextRange> values) {
                    if (values == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$2", "deleteColumns"));
                    }
                    JBIterator columnToDeleteIt = JBIterator.from(sortedColumns.iterator());
                    if (!columnToDeleteIt.advance()) {
                        return;
                    }
                    for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                        int endOffset;
                        int startOffset;
                        TextRange valueRange = values.get(valueIdx);
                        if (valueIdx == this.myLastColumnToLeaveIdx) {
                            startOffset = valueRange.getEndOffset();
                            endOffset = values.get(values.size() - 1).getEndOffset();
                            session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                            break;
                        }
                        if (valueIdx != ((DataConsumer.Column)columnToDeleteIt.current()).columnNum) continue;
                        startOffset = valueRange.getStartOffset();
                        endOffset = valueIdx + 1 < values.size() ? values.get(valueIdx + 1).getStartOffset() : valueRange.getEndOffset();
                        session.delete(SqlInsertsMarkup.includeWhitespaceUpToNextLine(session, TextRange.create((int)startOffset, (int)endOffset)));
                        if (!columnToDeleteIt.advance()) break;
                    }
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "insertColumn"));
            }
            this.insertColumn(session, null);
            return true;
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull DataConsumer.Column column) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "cloneColumn"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "cloneColumn"));
            }
            this.insertColumn(session, column);
            return true;
        }

        @Override
        protected boolean update(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<DataConsumer.Row> sortedRows, final @NotNull List<DataConsumer.Column> sortedColumns, @Nullable Object newValue) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "update"));
            }
            if (sortedRows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedRows", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "update"));
            }
            if (sortedColumns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedColumns", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "update"));
            }
            final String valueText = newValue == null ? "NULL" : String.valueOf(newValue);
            new RecursiveBlockVisitor(){
                private int myRowToUpdateIdx = 0;
                private int myCurrentRowNum = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$3", "visitValuesBlock"));
                    }
                    ++this.myCurrentRowNum;
                    DataConsumer.Row rowToUpdate = (DataConsumer.Row)sortedRows.get(this.myRowToUpdateIdx);
                    if (rowToUpdate.rowNum == this.myCurrentRowNum) {
                        List<TextRange> valueRanges = block.values;
                        for (DataConsumer.Column column : sortedColumns) {
                            session.replace(valueRanges.get(column.columnNum), valueText);
                        }
                        ++this.myRowToUpdateIdx;
                    }
                    return this.myRowToUpdateIdx < sortedRows.size();
                }
            }.visitBlocks(this.blocks);
            return true;
        }

        private void insertRow(final @NotNull DocumentDataHookUp.UpdateSession session, final @NotNull List<String> values) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "insertRow"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "insertRow"));
            }
            ((Block)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(this.blocks))).accept(new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertAllBlock(@NotNull MultiTableInsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4", "visitInsertAllBlock"));
                    }
                    List<InsertBlock> insertBlocks = block.insertBlocks;
                    InsertBlock lastInsertBlock = (InsertBlock)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(insertBlocks));
                    int offset = lastInsertBlock.range.getEndOffset();
                    String intoText = this.appendIntoDmlInstruction(new StringBuilder().append("\n"), values).toString();
                    session.insert(intoText, offset);
                    return false;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4", "visitInsertBlock"));
                    }
                    List<ValuesBlock> valuesBlocks = block.valuesBlocks;
                    if (valuesBlocks.size() == 1) {
                        this.insertInsertStatement(block);
                    } else {
                        this.insertValuesTuple((ValuesBlock)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(valuesBlocks)));
                    }
                    return false;
                }

                private void insertValuesTuple(@NotNull ValuesBlock nextTo) {
                    if (nextTo == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextTo", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4", "insertValuesTuple"));
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.COMMA : "").append(" ");
                    String valuesTuple = SqlInsertsMarkup.appendValuesTuple(sb, values).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert(valuesTuple, offset);
                }

                private void insertInsertStatement(@NotNull InsertBlock nextTo) {
                    if (nextTo == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextTo", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$4", "insertInsertStatement"));
                    }
                    TextRange separatorRange = nextTo.separatorRange;
                    StringBuilder sb = new StringBuilder();
                    sb.append(separatorRange == null ? SqlDocumentDataHookUp.SEMICOLON : "").append("\n");
                    String insertStatement = this.appendIntoDmlInstruction(sb.append("INSERT "), values).toString();
                    int offset = separatorRange != null ? separatorRange.getEndOffset() : nextTo.range.getEndOffset();
                    session.insert(insertStatement, offset);
                }
            });
        }

        private void insertColumn(final @NotNull DocumentDataHookUp.UpdateSession session, final @Nullable DataConsumer.Column columnToClone) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "insertColumn"));
            }
            new RecursiveBlockVisitor(){
                private int myRowIndex = 0;

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$5", "visitValuesBlock"));
                    }
                    int offset = ((TextRange)ObjectUtils.assertNotNull((Object)ContainerUtil.getLastItem(block.values))).getEndOffset();
                    String value = columnToClone != null ? String.valueOf(columnToClone.getValue((DataConsumer.Row)rows.get(this.myRowIndex))) : "NULL";
                    session.insert(", " + value, offset);
                    ++this.myRowIndex;
                    return true;
                }

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$5", "visitInsertBlock"));
                    }
                    TextRange lastColumn = (TextRange)ContainerUtil.getLastItem(block.columns);
                    if (lastColumn != null) {
                        int offset = lastColumn.getEndOffset();
                        session.insert(", column" + (columns.size() + 1), offset);
                    }
                    return super.visitInsertBlock(block);
                }
            }.visitBlocks(this.blocks);
        }

        @NotNull
        private StringBuilder appendIntoDmlInstruction(@NotNull StringBuilder sb, @NotNull List<String> values) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendIntoDmlInstruction"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendIntoDmlInstruction"));
            }
            String comma = ", ";
            sb.append("INTO ").append(this.insertTarget.getTableRefText());
            if (this.insertTarget.isColumnListPresent()) {
                sb.append("(");
                for (DataConsumer.Column column : this.columns) {
                    sb.append(column.name).append(comma);
                }
                sb.setLength(sb.length() - comma.length());
                sb.append(")");
            }
            sb.append(" VALUES ");
            StringBuilder stringBuilder = SqlInsertsMarkup.appendValuesTuple(sb, values);
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendIntoDmlInstruction"));
            }
            return stringBuilder;
        }

        @NotNull
        private static StringBuilder appendValuesTuple(@NotNull StringBuilder sb, @NotNull List<String> values) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendValuesTuple"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendValuesTuple"));
            }
            sb.append("(");
            String comma = ", ";
            for (String value : values) {
                sb.append(value).append(comma);
            }
            sb.setLength(sb.length() - comma.length());
            sb.append(")");
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "appendValuesTuple"));
            }
            return stringBuilder;
        }

        @NotNull
        private static List<DataConsumer.Column> columnsFromBlocks(@NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "columnsFromBlocks"));
            }
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "columnsFromBlocks"));
            }
            final Ref columnRanges = Ref.create();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitInsertBlock(@NotNull InsertBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$6", "visitInsertBlock"));
                    }
                    if (block.columns != null) {
                        columnRanges.set(block.columns);
                        return false;
                    }
                    return super.visitInsertBlock(block);
                }

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$6", "visitValuesBlock"));
                    }
                    columnRanges.set(block.values);
                    return false;
                }
            }.visitBlocks(blocks);
            List ranges = (List)ObjectUtils.assertNotNull((Object)columnRanges.get());
            ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)ranges.size());
            for (int i = 0; i < ranges.size(); ++i) {
                String columnName = ((TextRange)ranges.get(i)).subSequence(sequence).toString();
                columns.add(new DataConsumer.Column(i, columnName, 239, "String", "java.lang.String"));
            }
            ArrayList arrayList = columns;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "columnsFromBlocks"));
            }
            return arrayList;
        }

        @NotNull
        private static List<DataConsumer.Row> rowsFromBlocks(final @NotNull CharSequence sequence, @NotNull List<Block> blocks) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "rowsFromBlocks"));
            }
            if (blocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "rowsFromBlocks"));
            }
            final ArrayList rows = ContainerUtil.newArrayList();
            new RecursiveBlockVisitor(){

                @Override
                protected boolean visitValuesBlock(@NotNull ValuesBlock block) {
                    if (block == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup$7", "visitValuesBlock"));
                    }
                    List<TextRange> valueRanges = block.values;
                    Object[] values = new Object[valueRanges.size()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = valueRanges.get(i).subSequence(sequence).toString();
                    }
                    rows.add(new DataConsumer.Row(rows.size() + 1, values));
                    return true;
                }
            }.visitBlocks(blocks);
            ArrayList arrayList = rows;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "rowsFromBlocks"));
            }
            return arrayList;
        }

        @NotNull
        private static TextRange includeWhitespaceUpToNextLine(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull TextRange range) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "includeWhitespaceUpToNextLine"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "includeWhitespaceUpToNextLine"));
            }
            int endOffset = range.getEndOffset();
            while (session.isValidOffset(endOffset) && Character.isWhitespace(session.charAt(endOffset)) && session.charAt(++endOffset) != '\n') {
            }
            TextRange textRange = range.getEndOffset() == endOffset ? range : TextRange.create((int)range.getStartOffset(), (int)endOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/SqlDocumentDataHookUp$SqlInsertsMarkup", "includeWhitespaceUpToNextLine"));
            }
            return textRange;
        }
    }
}

