/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.mssql.MssqlDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.dbm.mssql.MsModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super(MsModel.META_MODEL, new TypeHelper.MssqlTypeHelper(), new KeywordHelper.MssqlKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.MSSQL;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.SqlServer;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getDisplayName"));
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("len" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getLengthFunction"));
        }
        return "len";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/MssqlDialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase();
        return lname.startsWith("microsoft") || lname.startsWith("sql server");
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MssqlDialect", "sqlDropColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MssqlDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/MssqlDialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dialects/MssqlDialect", "getTypeName"));
        }
        String sqlType = dataType.getSpecification();
        if ("money".equals(sqlType)) {
            if ("money" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getTypeName"));
            }
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getTypeName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new MssqlDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/MssqlDialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder typeBuilder = new DdlBuilder().configureFrom(builder);
        for (DasTypedObject column : pk.getColumnsRef().resolveObjects()) {
            if (column.isNotNull()) continue;
            builder.keyword("ALTER TABLE").space().qualifiedRef((DasObject)pk.getTable()).space().keyword("ALTER COLUMN").space().columnRef((DasObject)column).space().type(typeBuilder.clear().type(column).getStatement()).space().keyword("NOT NULL").newStatement();
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false).newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean typeChanged) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnTypeAndNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnTypeAndNullable"));
        }
        if (column.isNotNull()) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column, "ALTER COLUMN", true);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnTypeAndNullable"));
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder.suppressQuoteConstraints(true), "ALTER COLUMN", "", false, column).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnTypeAndNullable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnName"));
        }
        super.sqlAlterColumnName(builder, from, toName).symbol(",").space().literal("'COLUMN'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnDefault"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(null, column.getTable().getName() + "_" + column.getName() + "_default");
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        builder.space().keyword("FOR").space().columnRef((DasObject)column);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlAlterColumnDefault"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MssqlDialect", "sqlViewDefinition"));
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\n" + "exec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlViewDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MssqlDialect", "sqlProcedureDefinition"));
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\n" + "exec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/MssqlDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/MssqlDialect", "qualifiedIdentifier"));
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull Connection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableInfo"));
        }
        DdlBuilder builder = new DdlBuilder().configureFor((DbElement)element);
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(builder.qualifiedRef((DasObject)element).getStatement())), "rows", "rows");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull Connection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableDefinition"));
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(pkColumnsQuery);
        SmartList pkColumns = new SmartList();
        while (rs.next()) {
            String name = rs.getString("column_name");
            pkColumns.add(name);
        }
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelper.createDdlBuilder((DbElement)table, false) : new DdlBuilder().withDialect(this);
        statement = connection.createStatement();
        rs = statement.executeQuery(columns);
        ddl.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        boolean first = true;
        while (rs.next()) {
            if (first) {
                first = false;
            } else {
                ddl.symbol(",");
            }
            String name = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_name", (ErrorHandler)new ErrorHandler());
            String defaults = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_default", (ErrorHandler)new ErrorHandler());
            String type = JdbcUtil.getStringSafe((ResultSet)rs, (String)"data_type", (ErrorHandler)new ErrorHandler());
            String length = JdbcUtil.getStringSafe((ResultSet)rs, (String)"character_maximum_length", (ErrorHandler)new ErrorHandler());
            String precision = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_precision", (ErrorHandler)new ErrorHandler());
            String scale = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_scale", (ErrorHandler)new ErrorHandler());
            String isNullableStr = JdbcUtil.getStringSafe((ResultSet)rs, (String)"is_nullable", (ErrorHandler)new ErrorHandler());
            boolean isNotNull = "NO".equals(isNullableStr);
            String substitution = this.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
            ddl.newLine().space(spaces).columnRef(name != null ? name : "<name>").space().type(substitution);
            if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name)) {
                ddl.space().keywords("primary", "key");
            }
            if (defaults != null) {
                ddl.space().keywords("default").space().literal(defaults);
            }
            if (!isNotNull) continue;
            ddl.space().keywords("not", "null");
        }
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            boolean f = true;
            for (Object pk : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier((String)pk);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        statement = connection.createStatement();
        rs = statement.executeQuery(fkQuery);
        List fkNames = ContainerUtil.newSmartList();
        while (rs.next()) {
            fkNames.add(rs.getString("constraint_name"));
        }
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            statement = connection.createStatement();
            rs = statement.executeQuery(fkCols);
            LinkedHashSet fromCols = ContainerUtil.newLinkedHashSet();
            LinkedHashSet toCols = ContainerUtil.newLinkedHashSet();
            String refTableName = "<ref_table>";
            while (rs.next()) {
                refTableName = rs.getString("table_name");
                ContainerUtil.addIfNotNull((Collection)fromCols, (Object)rs.getString("from_col"));
                ContainerUtil.addIfNotNull((Collection)toCols, (Object)rs.getString("column_name"));
            }
            ddl.symbol(",").newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
            DialectUtils.appendStringList(ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList(ddl, toCols);
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String indices = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        statement = connection.createStatement();
        rs = statement.executeQuery(indices);
        MultiMap indexColumns = new MultiMap();
        HashMap indexUnique = new HashMap();
        while (rs.next()) {
            String indexName = rs.getString("index_name");
            String columnName = rs.getString("col_name");
            boolean isUnique = rs.getBoolean("is_unique");
            indexColumns.putValue((Object)indexName, (Object)columnName);
            indexUnique.put(indexName, isUnique);
        }
        for (String i : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i);
            Boolean isUnique = (Boolean)indexUnique.get(i);
            ddl.newLine().keywords("create").space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i).space().keyword("on").space().identifier(tableName).space().symbol("(");
            first = true;
            for (String col : colNames) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string = ddl.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/MssqlDialect", "sqlExplainPlan"));
        }
        builder.keywords("set", "showplan_text", "on").newStatement();
        builder.keywords("go").newLine();
        if (!analyze) {
            builder.keywords("set", "noexec", "on").newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/MssqlDialect", "sqlPostExplainPlan"));
        }
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "sqlPostExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/MssqlDialect", "tryToLoadDatabaseList"));
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT [name] FROM sys.databases d WHERE d.database_id > 4", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/MssqlDialect", "tryToLoadDatabaseList"));
        }
        return list;
    }
}

