/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DbDiffCheckOption
extends AnAction
implements CustomComponentAction,
DirDiffModelHolder,
ShortcutProvider {
    private final Object myKey;
    private final String myShortcut;
    private final JCheckBox myCheckBox = new JCheckBox();
    private DirDiffModel myModel;

    public DbDiffCheckOption(Object key, String title, String shortcut) {
        this.myKey = key;
        this.myShortcut = shortcut;
        this.myCheckBox.setText(GuiUtils.getTextWithoutMnemonicEscaping((String)title));
        this.myCheckBox.setMnemonic(GuiUtils.getDisplayedMnemonic((String)title));
        this.myCheckBox.setDisplayedMnemonicIndex(GuiUtils.getDisplayedMnemonicIndex((String)title));
        this.myCheckBox.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)6, (int)2, (int)0));
        this.myCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean state;
                if (DbDiffCheckOption.this.myModel != null && (state = ((Boolean)((DbDiffCheckOption)DbDiffCheckOption.this).myModel.getSettings().customSettings.get(DbDiffCheckOption.this.myKey)).booleanValue()) != DbDiffCheckOption.this.myCheckBox.isSelected()) {
                    ((DbDiffCheckOption)DbDiffCheckOption.this).myModel.getSettings().customSettings.put(DbDiffCheckOption.this.myKey, DbDiffCheckOption.this.myCheckBox.isSelected());
                    DbDiffCheckOption.this.myModel.applySettings();
                    DbDiffCheckOption.this.myModel.reloadModel(true);
                }
            }
        });
    }

    public void actionPerformed(AnActionEvent e) {
        boolean selected = (Boolean)this.myModel.getSettings().customSettings.get(this.myKey);
        this.myModel.getSettings().customSettings.put(this.myKey, !selected);
        this.myCheckBox.setSelected(!selected);
        this.myModel.applySettings();
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return this.myCheckBox;
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        this.myCheckBox.setSelected((Boolean)this.myModel.getSettings().customSettings.get(this.myKey));
    }

    public ShortcutSet getShortcut() {
        return CustomShortcutSet.fromString((String[])new String[]{this.myShortcut});
    }
}

