/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GotoRowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            GotoRowDialog dialog = new GotoRowDialog(dataGrid);
            dialog.show();
        }
    }

    public void update(AnActionEvent e) {
        DataGrid resultPanel = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = resultPanel != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    private static class GotoRowDialog
    extends DialogWrapper {
        private JTextField myField;
        private final DataGrid myDataGrid;

        public GotoRowDialog(DataGrid dataGrid) {
            super((Component)dataGrid.getPreferredFocusedComponent(), true);
            this.myDataGrid = dataGrid;
            this.setTitle("Go to Row");
            this.init();
        }

        protected void doOKAction() {
            ModelIndex<DataConsumer.Column> column = this.getTargetColumn();
            ModelIndex<DataConsumer.Row> row = this.getTargetRow();
            if (column.isValid(this.myDataGrid) && row.asInteger() != -1) {
                this.myDataGrid.showCell(row, column);
                super.doOKAction();
            }
        }

        @NotNull
        private ModelIndex<DataConsumer.Column> getTargetColumn() {
            ModelIndex<DataConsumer.Column> modelIndex;
            String text = this.getText();
            int columnIndex = GotoRowDialog.columnSeparatorIndex(text);
            if (columnIndex == -1) {
                ModelIndex<DataConsumer.Column> modelIndex2 = this.getDefaultTargetColumn();
                if (modelIndex2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetColumn"));
                }
                return modelIndex2;
            }
            try {
                modelIndex = this.myDataGrid.uiColumn(Integer.parseInt(text.substring(columnIndex + 1).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                ModelIndex<DataConsumer.Column> modelIndex3 = this.getDefaultTargetColumn();
                if (modelIndex3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetColumn"));
                }
                return modelIndex3;
            }
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetColumn"));
            }
            return modelIndex;
        }

        @NotNull
        private ModelIndex<DataConsumer.Column> getDefaultTargetColumn() {
            ModelIndex selectedColumn = this.myDataGrid.getSelectionModel().getSelectedColumn();
            ModelIndex modelIndex = selectedColumn.isValid(this.myDataGrid) ? selectedColumn : (ModelIndex)this.myDataGrid.getVisibleColumns().first();
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getDefaultTargetColumn"));
            }
            return modelIndex;
        }

        @NotNull
        private ModelIndex<DataConsumer.Row> getTargetRow() {
            String text;
            block6: {
                ModelIndex<DataConsumer.Row> modelIndex;
                try {
                    text = this.getText();
                    int columnIndex = GotoRowDialog.columnSeparatorIndex(text);
                    text = (columnIndex == -1 ? text : text.substring(0, columnIndex)).trim();
                    if (text.length() != 0) break block6;
                    modelIndex = this.getDefaultTargetRow();
                }
                catch (NumberFormatException e) {
                    ModelIndex<DataConsumer.Row> modelIndex2 = ModelIndex.forRow(this.myDataGrid, -1);
                    if (modelIndex2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetRow"));
                    }
                    return modelIndex2;
                }
                if (modelIndex == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetRow"));
                }
                return modelIndex;
            }
            ModelIndex<DataConsumer.Row> modelIndex = this.myDataGrid.uiRow(Integer.parseInt(text));
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getTargetRow"));
            }
            return modelIndex;
        }

        @NotNull
        private ModelIndex<DataConsumer.Row> getDefaultTargetRow() {
            ModelIndex selectedRow = this.myDataGrid.getSelectionModel().getSelectedRow();
            ModelIndex modelIndex = selectedRow.isValid(this.myDataGrid) ? selectedRow : (ModelIndex)this.myDataGrid.getVisibleRows().first();
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getDefaultTargetRow"));
            }
            return modelIndex;
        }

        private static int columnSeparatorIndex(String text) {
            int colonIndex = text.indexOf(58);
            return colonIndex >= 0 ? colonIndex : text.indexOf(44);
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        private String getText() {
            return this.myField.getText();
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = new Insets(4, 0, 8, 4);
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel label = new JLabel("Row Number:");
            panel.add((Component)label, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            class MyTextField
            extends JTextField {
                public MyTextField() {
                    super("");
                }

                @Override
                @NotNull
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    Dimension dimension = new Dimension(200, d.height);
                    if (dimension == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog$1MyTextField", "getPreferredSize"));
                    }
                    return dimension;
                }
            }
            this.myField = new MyTextField();
            panel.add((Component)this.myField, gbConstraints);
            this.myField.setToolTipText(StringUtil.escapeXml((String)"[<row>][:<column>] or [<row>][,<column>]"));
            return panel;
        }
    }
}

