/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonValuesExtractor
extends DefaultValuesExtractor<DatabaseSettings.BaseState> {
    public JsonValuesExtractor(ObjectFormatter converter) {
        this(new DatabaseSettings.BaseState(), converter);
    }

    public JsonValuesExtractor(DatabaseSettings.BaseState state, ObjectFormatter converter) {
        super(state, converter);
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        if ("{\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getLinePrefix"));
        }
        return "{\n";
    }

    @Override
    @NotNull
    public String getLineSuffix() {
        if ("\n }" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getLineSuffix"));
        }
        return "\n }";
    }

    @Override
    public String getLineSeparator() {
        return ",\n ";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        if ("  " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getValuePrefix"));
        }
        return "  ";
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getValueSuffix"));
        }
        return "";
    }

    @Override
    public String getValueSeparator() {
        return ",\n";
    }

    @Override
    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column) {
        String string = this.getColumnName(column) + ": " + "null";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getNullLiteral"));
        }
        return string;
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return "\"" + column.name + "\"";
    }

    @Override
    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        Object value = column.getValue(row);
        if (value instanceof Map && ObjectFormatter.isHstore(column)) {
            String string = this.formatHstoreValue(column, (Map)value);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
            }
            return string;
        }
        String string = super.getValueLiteral(row, column, dialect);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        return string;
    }

    @Override
    public String getValueLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/JsonValuesExtractor", "getValueLiteral"));
        }
        if (column == null) {
            return "";
        }
        return this.getColumnName(column) + ": " + (this.isStringLiteral(dialect, value, row, column) ? this.getStringValue(dialect, value) : value);
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull DatabaseDialect dialect, @NotNull String value) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/JsonValuesExtractor", "getStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/JsonValuesExtractor", "getStringValue"));
        }
        String string = "\"" + StringUtil.escapeStringCharacters((String)value) + "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getStringValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("json" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "getFileExtension"));
        }
        return "json";
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new DefaultValuesExtractor.DefaultExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns){

            @Override
            protected void appendHeader(boolean appendNewLine) {
                this.myOutput.append("[");
            }

            @Override
            protected void appendFooter() {
                this.myOutput.append("\n]");
            }
        };
    }

    @NotNull
    private String formatHstoreValue(@NotNull DataConsumer.Column column, Map<String, String> value) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/JsonValuesExtractor", "formatHstoreValue"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColumnName(column)).append(": ");
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, String> entry : value.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), true, true).append(": ");
            String jsonValue = entry.getValue();
            if (JsonValuesExtractor.isValidJsonValue(jsonValue)) {
                sb.append(jsonValue);
            } else {
                ObjectFormatter.appendHstoreValue(sb, jsonValue, true, true);
            }
            first = false;
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/JsonValuesExtractor", "formatHstoreValue"));
        }
        return string;
    }

    private static boolean isValidJsonValue(String jsonValue) {
        if ("true".equals(jsonValue) || "false".equals(jsonValue) || "null".equals(jsonValue)) {
            return true;
        }
        try {
            Double.parseDouble(jsonValue);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

