/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SeparatedValuesExtractor<T extends DatabaseSettings.StdState>
extends TranspositionAwareDefaultExtractor<T> {
    public SeparatedValuesExtractor(T state, ObjectFormatter converter) {
        super(state, converter);
    }

    public String getOpeningQuote() {
        return "\"";
    }

    public String getClosingQuote() {
        return "\"";
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return this.getValueLiteral(GenericDialect.INSTANCE, column.name, null, null);
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull DatabaseDialect dialect, @NotNull String value) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/SeparatedValuesExtractor", "getStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/SeparatedValuesExtractor", "getStringValue"));
        }
        String string = this.getOpeningQuote() + this.escapeStringValue(value) + this.getClosingQuote();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SeparatedValuesExtractor", "getStringValue"));
        }
        return string;
    }

    @NotNull
    public String escapeStringValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/SeparatedValuesExtractor", "escapeStringValue"));
        }
        String string = value.replace(this.getOpeningQuote(), this.getOpeningQuote() + this.getOpeningQuote());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SeparatedValuesExtractor", "escapeStringValue"));
        }
        return string;
    }

    @Override
    protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/SeparatedValuesExtractor", "isStringLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/SeparatedValuesExtractor", "isStringLiteral"));
        }
        if (value.length() > 1024 || value.contains(this.getOpeningQuote()) || value.contains(this.getClosingQuote()) || value.contains(this.getValueSeparator())) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }
}

