/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanView {
    public static final ColumnInfo OPERATION_COLUMN = new TreeColumnInfo("Operation");
    public static final ColumnInfo PARAMS_COLUMN = new ColumnInfo<PlanTreeNode, String>("Params"){

        @Nullable
        public String valueOf(PlanTreeNode node) {
            return node.getNode().getExtraInfo();
        }
    };
    public static final ColumnInfo NUM_ROWS_COLUMN = new ColumnInfo<PlanTreeNode, BigDecimal>("Rows"){

        @Nullable
        public BigDecimal valueOf(PlanTreeNode node) {
            return node.getNode().getPlanNumRows();
        }
    };
    public static final ColumnInfo TOTAL_COST_COLUMN = new ColumnInfo<PlanTreeNode, Double>("Total Cost"){

        @Nullable
        public Double valueOf(PlanTreeNode node) {
            return node.getNode().getTotalCost();
        }
    };
    public static final ColumnInfo STARTUP_COST_COLUMN = new ColumnInfo<PlanTreeNode, Double>("Startup Cost"){

        @Nullable
        public Double valueOf(PlanTreeNode node) {
            return node.getNode().getStartupCost();
        }
    };
    public static final ColumnInfo RAW_DESC_COLUMN = new ColumnInfo<PlanTreeNode, String>("Raw desc"){

        @Nullable
        public String valueOf(PlanTreeNode node) {
            return node.getNode().getRawDescription();
        }
    };
    private final JScrollPane myPanel;
    private PlanRenderers.ActionRenderer myTreeRenderer = new PlanRenderers.ActionRenderer();

    private static ColumnInfo[] columnsFor(@NotNull PlanModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/plan/ui/PlanView", "columnsFor"));
        }
        ArrayList res = ContainerUtil.newArrayList();
        res.add(OPERATION_COLUMN);
        res.add(PARAMS_COLUMN);
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.NUM_ROWS)) {
            res.add(NUM_ROWS_COLUMN);
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.TOTAL_COST)) {
            res.add(TOTAL_COST_COLUMN);
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.STARTUP_COST)) {
            res.add(STARTUP_COST_COLUMN);
        }
        res.add(RAW_DESC_COLUMN);
        return res.toArray(new ColumnInfo[res.size()]);
    }

    private PlanView() {
        this.myPanel = ScrollPaneFactory.createScrollPane();
    }

    private static double getRendererWidth(JTable table, boolean header, int i, int j) {
        TableCellRenderer renderer;
        TableCellRenderer tableCellRenderer = renderer = header ? table.getColumnModel().getColumn(j).getHeaderRenderer() : table.getCellRenderer(i, j);
        if (renderer == null && header) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        if (renderer == null) {
            return 0.0;
        }
        Object value = header ? table.getColumnModel().getColumn(j).getHeaderValue() : table.getModel().getValueAt(i, j);
        return renderer.getTableCellRendererComponent(table, value, false, false, i, j).getPreferredSize().getWidth();
    }

    public void setModel(@Nullable PlanModel model) {
        if (model != null) {
            ColumnInfo[] columns = PlanView.columnsFor(model);
            TreeTableView table = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)PlanTreeNode.create(model.getRoot()), columns));
            table.setTreeCellRenderer((TreeCellRenderer)this.myTreeRenderer);
            table.setRootVisible(false);
            this.myPanel.setViewportView((Component)table);
            TreeUtil.expandAll((JTree)table.getTree());
            FontMetrics metrics = table.getFontMetrics(table.getFont());
            int minWidth = metrics.stringWidth("XXXX");
            int spacing = metrics.stringWidth("X");
            for (int i = 0; i < columns.length; ++i) {
                double size;
                if (columns[i] == RAW_DESC_COLUMN) {
                    size = metrics.stringWidth("XXXXXXXXXXXX");
                } else {
                    size = table.getColumnModel().getColumn(i).getMinWidth();
                    int count = table.getRowCount();
                    for (int j = 0; j != count; ++j) {
                        size = Math.max(size, PlanView.getRendererWidth((JTable)table, false, j, i));
                    }
                    size = Math.max(size, PlanView.getRendererWidth((JTable)table, true, -1, i) + (double)spacing);
                }
                table.getColumnModel().getColumn(i).setPreferredWidth((int)size);
                table.getColumnModel().getColumn(i).setMinWidth(minWidth);
            }
            table.revalidate();
        } else {
            this.myPanel.setViewportView(null);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JScrollPane jScrollPane = this.myPanel;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "getComponent"));
        }
        return jScrollPane;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JScrollPane jScrollPane = this.myPanel;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "getPreferredFocusedComponent"));
        }
        return jScrollPane;
    }

    @NotNull
    public static PlanView createView() {
        PlanView planView = new PlanView();
        if (planView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView", "createView"));
        }
        return planView;
    }
}

