/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class BasicDbPsiManager<T extends DatabaseSystem>
extends DbPsiManagerSpi {
    protected final Key<Map<T, DbDataSource>> DS_MAP_KEY;
    protected final DbPsiFacade myDbFacade;

    protected BasicDbPsiManager(@NotNull DbPsiFacade dbFacade, @NotNull List<T> sources) {
        if (dbFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFacade", "com/intellij/database/psi/BasicDbPsiManager", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/psi/BasicDbPsiManager", "<init>"));
        }
        this.DS_MAP_KEY = Key.create((String)(((Object)((Object)this)).getClass().getSimpleName() + ".MAP_KEY"));
        this.myDbFacade = dbFacade;
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        this.myDbFacade.getProject().putUserData(this.DS_MAP_KEY, Collections.synchronizedMap(map));
        this.resetElementMap(sources);
    }

    protected void resetElementMap(@NotNull List<T> sources) {
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/psi/BasicDbPsiManager", "resetElementMap"));
        }
        Map<T, DbDataSource> map = this.getElementsMap();
        map.keySet().retainAll(sources);
        for (DatabaseSystem source : sources) {
            DbDataSource e = map.get(source);
            if (e == null) {
                map.put(source, this.createDataSourceElement(source));
                continue;
            }
            e.clearCaches();
        }
    }

    @NotNull
    protected DbDataSource createDataSourceElement(@NotNull T info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/psi/BasicDbPsiManager", "createDataSourceElement"));
        }
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)this.myDbFacade).createDataSourceWrapperElement((DatabaseSystem)info, this);
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/BasicDbPsiManager", "createDataSourceElement"));
        }
        return dbDataSource;
    }

    public List<DbDataSource> getDataSources() {
        return new ArrayList<DbDataSource>(this.getElementsMap().values());
    }

    @NotNull
    protected Map<T, DbDataSource> getElementsMap() {
        Map map = (Map)ObjectUtils.assertNotNull((Object)this.myDbFacade.getProject().getUserData(this.DS_MAP_KEY));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/BasicDbPsiManager", "getElementsMap"));
        }
        return map;
    }

    @Override
    public boolean isDataSourceElementValid(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/BasicDbPsiManager", "isDataSourceElementValid"));
        }
        return this.getElementsMap().containsKey(element.getDelegate());
    }

    public abstract void addDataSource(@NotNull T var1);
}

