/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.dbm.common.DbmModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSchemaAction
extends AlignedIconWithTextAction
implements DumbAware {
    private static final FileAttribute SELECTED_NAMESPACE_ATTR = new FileAttribute("datasource_namespace", 1 + (FSRecords.persistentAttributesList ? 1 : 0), FSRecords.persistentAttributesList);

    public void actionPerformed(AnActionEvent e) {
        JdbcConsole console = JdbcConsole.getConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        if (button == null || !button.isShowing() || console == null) {
            return;
        }
        ChooseSchemaAction.showPopup(console, button, e.getDataContext());
    }

    public void update(AnActionEvent e) {
        String tooltipText;
        ObjectKind kind;
        JdbcConsole console = JdbcConsole.getConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        DatabaseDialectEx dialect = console == null ? null : DbImplUtil.getDatabaseDialect(console);
        ObjectKind objectKind = kind = dialect == null ? null : ChooseSchemaAction.canSwitchNamespace(dialect);
        if (kind == null || !DbImplUtil.isAuthRequired(console.getDataSource())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ObjectPath schema = console.getCurrentSchema();
        if (schema == null || schema.kind == ObjectKind.NONE) {
            schema = ObjectPath.of((DasObject)DatabaseDataKeys.CURRENT_NAMESPACE_KEY.get((UserDataHolder)console.getLanguageConsole().getFile()));
        }
        boolean enabled = DbImplUtil.supportsDynamicSchemaSwitching(console.getDataSource());
        String text = schema != null ? schema.getDisplayName() : (enabled ? "<" + Case.LOWER.apply(kind.name()) + ">" : "");
        boolean visible = StringUtil.isNotEmpty((String)text);
        String string = tooltipText = enabled ? "Switch current schema or user" : "Current schema";
        Icon icon = !enabled ? null : (UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text, false);
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setIcon(icon);
        if (button != null) {
            button.setToolTipText(tooltipText);
            ((ActionButtonWithText)button).setHorizontalTextPosition(2);
        }
    }

    private static void showPopup(final JdbcConsole console, JComponent button, DataContext dataContext) {
        final DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        boolean canSwitchSchema = ChooseSchemaAction.canSwitchNamespace(dialect) != null;
        DefaultActionGroup actions = new DefaultActionGroup();
        ObjectPath schema = console.getCurrentSchema();
        AnAction preselectedAction = null;
        if (canSwitchSchema) {
            HashSet visited = ContainerUtil.newHashSet();
            LocalDataSource dataSource = console.getDataSource();
            JBIterable namespaces = DasUtil.getNamespaces((DatabaseSystem)dataSource);
            if (!(dataSource.getModel() instanceof DbmModel)) {
                namespaces = JBIterable.from((Iterable)namespaces.transform(DasUtil.TO_PARENT).filter(Condition.NOT_NULL).toSet()).append((Iterable)namespaces);
            }
            for (DasObject info : namespaces) {
                final ObjectPath path = ObjectPath.of(info);
                if (path == null || !visited.add(path) || dialect.sqlSetCurrentSchema(path) == null) continue;
                AnAction action = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        ChooseSchemaAction.switchTo(console, path);
                    }
                };
                action.getTemplatePresentation().setText(path.getDisplayName(), false);
                action.getTemplatePresentation().setDescription(String.format("Switch to '%s'", path.getDisplayName()));
                actions.add(action);
                if (!Comparing.equal((Object)path, (Object)schema)) continue;
                preselectedAction = action;
            }
        }
        actions.addSeparator();
        actions.addAction(new AnAction("Connect As..."){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(ChooseSchemaAction.canSwitchUser(console, dialect));
            }

            public void actionPerformed(AnActionEvent e) {
                ChooseSchemaAction.switchUser(console);
            }
        });
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions, dataContext, false, false, false, null, 15, Conditions.is(preselectedAction));
        popup.setMinimumSize(button.getSize());
        popup.showUnderneathOf((Component)button);
    }

    private static ObjectKind canSwitchNamespace(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchNamespace"));
        }
        List<String> path = Arrays.asList("no", "way");
        for (ObjectKind kind : dialect.getMetaModel().getNamespaces()) {
            if (dialect.sqlSetCurrentSchema(new ObjectPath(kind, path)) == null) continue;
            return kind;
        }
        return null;
    }

    private static void switchTo(JdbcConsole console, ObjectPath path) {
        if (!Comparing.equal((Object)console.getCurrentSchema(), (Object)path)) {
            console.switchSchema(path, true);
        }
    }

    private static boolean canSwitchUser(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchUser"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "canSwitchUser"));
        }
        return false;
    }

    private static void switchUser(@NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "switchUser"));
        }
    }

    public static void scheduleSchemaSwitch(@NotNull JdbcConsole console, @Nullable DasNamespace o) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "scheduleSchemaSwitch"));
        }
        if ((o = ChooseSchemaAction.getSchemaToSwitchToInner(console, o)) == null) {
            return;
        }
        console.switchSchema(ObjectPath.of((DasObject)o), false);
        DatabaseDataKeys.CURRENT_NAMESPACE_KEY.set((UserDataHolder)console.getLanguageConsole().getFile(), (Object)o);
    }

    @Nullable
    private static DasNamespace getSchemaToSwitchToInner(final @NotNull JdbcConsole console, @Nullable DasNamespace o) {
        ObjectPath schemaPath;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "getSchemaToSwitchToInner"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        ObjectPath objectPath = schemaPath = o != null ? null : ChooseSchemaAction.getSelectedNamespace(console.getLanguageConsole().getVirtualFile(), dialect);
        if (schemaPath != null && schemaPath.kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (localDataSource.getModel() == DasUtil.loadingModel()) {
                Project project = console.getProject();
                final Disposable listenerDisposable = Disposer.newDisposable();
                Disposer.register((Disposable)console, (Disposable)listenerDisposable);
                DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                    public void modificationCountChanged(DbPsiFacade source) {
                        Disposer.dispose((Disposable)listenerDisposable);
                        ChooseSchemaAction.scheduleSchemaSwitch(console, null);
                    }
                }, listenerDisposable);
            } else {
                o = DatabaseEditorHelper.findNamespace(console.getProject(), (DatabaseSystem)localDataSource, schemaPath);
            }
        }
        return o != null && (o.getKind() == ObjectKind.SCHEMA || o.getKind() == ObjectKind.DATABASE) ? o : null;
    }

    public static void setSelectedNamespace(@NotNull VirtualFile file, @Nullable ObjectPath schemaPath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "setSelectedNamespace"));
        }
        DbImplUtil.writeVFSAttributeSafe(file, SELECTED_NAMESPACE_ATTR, ObjectPath.serialize(schemaPath));
    }

    @Nullable
    private static ObjectPath getSelectedNamespace(@NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedNamespace"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedNamespace"));
        }
        return ObjectPath.deserialize(DbImplUtil.readVFSAttributeSafe(file, SELECTED_NAMESPACE_ATTR), dialect.getMetaModel());
    }
}

