/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;

public class EditValueAction
extends AnAction
implements DumbAware,
GridAction {
    public EditValueAction() {
        super(null, null, null);
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String text = this.getText(!dataGrid.isEditable());
        String description = this.getDescription(!dataGrid.isEditable());
        boolean visible = ActionPlaces.isPopupPlace((String)e.getPlace());
        boolean enabled = dataGrid.isCellEditingAllowed() && dataGrid.isReady() && !dataGrid.isEditing() && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && dataGrid.getSelectionModel().getSelectedColumnCount() == 1;
        e.getPresentation().setText(text);
        e.getPresentation().setDescription(description);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.editSelectedCell();
        }
    }

    protected String getText(boolean viewMode) {
        return viewMode ? "View" : "Edit";
    }

    protected String getDescription(boolean viewMode) {
        return (viewMode ? "View" : "Edit") + " selected cell";
    }
}

