/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import org.jetbrains.annotations.NotNull;

public class PinResultTabAction
extends ToggleAction
implements GridAction {
    private static final String TEXT_SELECTED = "Unpin result tab";
    private static final String TEXT_UNSELECTED = "Pin result tab";
    private static final String DESCRIPTION_SELECTED = "Unpin result tab: allow it to be re-used";
    private static final String DESCRIPTION_UNSELECTED = "Pin result tab: prevent it from being re-used";

    public PinResultTabAction() {
        super(TEXT_UNSELECTED, DESCRIPTION_UNSELECTED, AllIcons.General.Pin_tab);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/PinResultTabAction", "update"));
        }
        super.update(e);
        Content content = PinResultTabAction.getContent(e.getDataContext());
        boolean enabledAndVisible = content != null && content.isPinnable();
        e.getPresentation().setEnabledAndVisible(enabledAndVisible);
        boolean pinned = enabledAndVisible && content.isPinned();
        e.getPresentation().setText(pinned ? TEXT_SELECTED : TEXT_UNSELECTED);
        e.getPresentation().setDescription(pinned ? DESCRIPTION_SELECTED : DESCRIPTION_UNSELECTED);
    }

    public boolean isSelected(AnActionEvent e) {
        Content content = PinResultTabAction.getContent(e.getDataContext());
        return content != null && content.isPinned();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Content content = PinResultTabAction.getContent(e.getDataContext());
        if (content != null) {
            content.setPinned(state);
        }
    }

    private static Content getContent(DataContext context) {
        DataGrid grid = DataGridUtil.getDataGrid(context);
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext((DataContext)context, (boolean)false);
        return contentManager != null && grid != null ? contentManager.getContent(grid.getComponent()) : null;
    }
}

