/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.EmptyIcon;
import org.jetbrains.annotations.NotNull;

public class ShowQueryAction
extends AlignedIconWithTextAction
implements DumbAware,
GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ShowQueryAction", "update"));
        }
        e.getPresentation().setEnabled(DataGridUtil.getQueryText((DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) != null);
        e.getPresentation().setDisabledIcon(EmptyIcon.ICON_0);
        e.getPresentation().setIcon(EmptyIcon.ICON_0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ShowQueryAction", "actionPerformed"));
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        String queryText = DataGridUtil.getQueryText(dataGrid);
        if (project == null || queryText == null) {
            return;
        }
        DocumentationManager.getInstance((Project)project).showJavaDocInfo(DataGridPomTarget.wrapDataGrid(project, dataGrid), null);
    }
}

