/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class GridTableCellEditor
extends AbstractTableCellEditor {
    private static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private final DataGrid myGrid;
    private final ModelIndex<DataConsumer.Row> myRowIdx;
    private final ModelIndex<DataConsumer.Column> myColumnIdx;
    private final GridCellEditorFactory myEditorFactory;
    private GridCellEditor myEditor = null;

    public GridTableCellEditor(DataGrid grid, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx, GridCellEditorFactory editorFactory) {
        this.myGrid = grid;
        this.myRowIdx = rowIdx;
        this.myColumnIdx = columnIdx;
        this.myEditorFactory = editorFactory;
    }

    public GridCellEditor getEditor() {
        return this.myEditor;
    }

    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.myEditorFactory == null) {
            return null;
        }
        if (this.myEditor == null) {
            EventObject e = (EventObject)ObjectUtils.tryCast((Object)table.getClientProperty("EventThatCausedEditingToStart"), EventObject.class);
            this.myEditor = this.myEditorFactory.createEditor(this.myGrid, this.myRowIdx, this.myColumnIdx, e);
        }
        table.addPropertyChangeListener(TABLE_CELL_EDITOR_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == GridTableCellEditor.this && evt.getNewValue() != GridTableCellEditor.this) {
                    Disposer.dispose((Disposable)GridTableCellEditor.this.myEditor);
                    table.removePropertyChangeListener(GridTableCellEditor.TABLE_CELL_EDITOR_PROPERTY, this);
                }
            }
        });
        JComponent editorComponent = this.myEditor.getComponent();
        editorComponent = this.myEditor.isColumnSpanAllowed() ? new GridCellEditorComponentWrapper(this.myEditor.getComponent()) : editorComponent;
        ResizableCellEditorsSupport.allowMaximizing(table, editorComponent, this.myEditor.isMaximizationAllowed());
        return editorComponent;
    }

    public Object getCellEditorValue() {
        return this.myEditor != null ? this.myEditor.getValue() : null;
    }

    public boolean isCellEditable(EventObject e) {
        if (this.myEditorFactory == null) {
            return false;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    public boolean stopCellEditing() {
        if (!this.myGrid.isEditable() && !this.myGrid.getDataModel().allValuesEqualTo(ModelIndexSet.forRows(this.myGrid, this.myRowIdx.asInteger()), ModelIndexSet.forColumns(this.myGrid, this.myColumnIdx.asInteger()), this.getCellEditorValue())) {
            this.showCannotApplyCellEditorChangesDialog();
            return false;
        }
        return this.myEditor != null && this.myEditor.stop() && super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.myEditor != null) {
            this.myEditor.cancel();
        }
        super.cancelCellEditing();
    }

    private void showCannotApplyCellEditorChangesDialog() {
        ModalityState currentModality;
        Application application = ApplicationManager.getApplication();
        ModalityState gridModality = application.getModalityStateForComponent((Component)this.myGrid.getComponent());
        if (Comparing.equal((Object)gridModality, (Object)(currentModality = application.getCurrentModalityState())) && this.myGrid.getComponent().isShowing()) {
            DataGridUtil.showCannotApplyCellEditorChanges(this.myGrid);
        }
    }

    private static class GridCellEditorComponentWrapper
    extends JComponent
    implements ResizableCellEditorsSupport.ResizableCellEditor {
        private boolean myWidthChangeEnabled;
        private KeyEvent myCurrentEvent;

        public GridCellEditorComponentWrapper(@NotNull JComponent editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/GridTableCellEditor$GridCellEditorComponentWrapper", "<init>"));
            }
            this.myWidthChangeEnabled = true;
            this.myCurrentEvent = null;
            this.setLayout(new BorderLayout());
            this.add((Component)editor, "Center");
            this.setFocusable(false);
        }

        @Override
        public void setWidthChangeEnabled(boolean b) {
            this.myWidthChangeEnabled = b;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, this.myWidthChangeEnabled ? width : this.getWidth(), height);
        }

        @Override
        public void requestFocus() {
            if (this.getComponentCount() == 1) {
                this.getComponent(0).requestFocus();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (condition == 0 && this.myCurrentEvent != e && this.getComponentCount() == 1) {
                try {
                    this.myCurrentEvent = e;
                    this.getComponent(0).dispatchEvent(e);
                }
                finally {
                    this.myCurrentEvent = null;
                }
            }
            return e.isConsumed() || super.processKeyBinding(ks, e, condition, pressed);
        }
    }
}

