/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.GridTableCellEditor;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.grid.DummyGridColumnLayout;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridRawIndexConverter;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.grid.GridScrollPane;
import com.intellij.database.run.ui.grid.GridScrollPosition;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.GridTableModel;
import com.intellij.database.run.ui.grid.JBTableWithResizableCells;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactories;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderers;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsAdapter;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
SelectionModel<DataConsumer.Row, DataConsumer.Column>,
GridModel.Listener<DataConsumer.Row, DataConsumer.Column>,
GridSearchSession.Listener {
    static final String EDITING_STARTER_CLIENT_PROPERTY_KEY = "EventThatCausedEditingToStart";
    private static final String XML_LANGUAGE_ID = "XML";
    private static final String JSON_LANGUAGE_ID = "JSON";
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final MyTableView myTable;
    private final GridRawIndexConverter myRawIndexConverter;
    private final ActionGroup myPopupActionGroup;
    private final ActionGroup myGutterPopupActionGroup;
    private final ActionGroup myColumnHeaderPopupActions;
    private final MyTableColumnCache myColumnCache;
    private final MyColumnAttributes myColumnAttributes;
    private ModelIndex<DataConsumer.Column> myClickedHeaderColumnIdx;
    private boolean myFailedToSubmitInsertedRow;
    private GridColumnLayout<DataConsumer.Row, DataConsumer.Column> myColumnLayout;
    private final boolean myUseConsoleFonts;
    private final Project myProject;
    private ObjectFormatter myConverter;
    protected final GridFilterPanel myFilterPanel;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    @NotNull
    private final GridMarkupModel<DataConsumer.Row, DataConsumer.Column> myMarkupModel;
    @NotNull
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myDataHookUp;
    @NotNull
    private final JScrollPane myScrollPane;
    private GridSearchSession<DataConsumer.Row, DataConsumer.Column> mySearchSession;
    private boolean myReady;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (popupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        this(project, dataHookUp, popupActions, popupActions, DataGridUtil.getGridColumnHeaderPopupActions(), null, false);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderPopupActions, @Nullable GridCellEditorFactoryProvider cellEditorFactoryProvider, boolean useConsoleFonts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (popupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (gutterPopupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterPopupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (columnHeaderPopupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnHeaderPopupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        this.myConverter = new ObjectFormatter();
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myReady = true;
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myColumnHeaderPopupActions = columnHeaderPopupActions;
        this.myGutterPopupActionGroup = gutterPopupActions;
        this.myMarkupModel = new GridMarkupModelImpl<DataConsumer.Row, DataConsumer.Column>();
        this.myDataHookUp = dataHookUp;
        this.installDataHookUpListeners();
        this.myUseConsoleFonts = useConsoleFonts;
        this.myClickedHeaderColumnIdx = ModelIndex.forColumn(this, -1);
        this.myFilterPanel = new GridFilterPanel(this.myProject, this);
        this.myFilterPanel.setVisible(this.isFilteringEnabledInModel());
        this.myMainPanel = new GridMainPanel(this);
        DataManager.registerDataProvider((JComponent)((Object)this.myMainPanel), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                return TableResultPanel.this.getData(dataId);
            }
        });
        this.myMainPanel.setLoadingText("");
        this.myColumnCache = new MyTableColumnCache();
        this.myColumnAttributes = new MyColumnAttributes();
        this.myTable = this.createTableView(cellEditorFactoryProvider != null ? cellEditorFactoryProvider : GridCellEditorFactories.getInstance());
        this.myRawIndexConverter = new GridRawIndexConverter(this.myTable);
        this.myTable.getEmptyText().setText("");
        this.myTable.setSelectionMode(2);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setAutoResizeMode(0);
        this.myTable.setBackground(this.myMainPanel.getBackground());
        this.myTable.setShowGrid(true);
        this.registerEscapeAction();
        this.myTable.getTableHeader().setDefaultRenderer(new MyCellRenderer());
        this.myScrollPane = new GridScrollPane((JTable)((Object)this.myTable), this.myTable.getTableHeader(), this.createRowHeader(), (JComponent)((Object)new MyCornerToolsComponent())){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
                    TableResultPanel.this.myTable.changeFontSize(-e.getWheelRotation(), 1.0);
                    return;
                }
                super.processMouseWheelEvent(e);
            }

            public void paint(Graphics g) {
                TableResultPanel.this.myTable.startPaintingSession();
                try {
                    super.paint(g);
                }
                finally {
                    TableResultPanel.this.myTable.endPaintingSession();
                }
            }
        };
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myMainPanel.add(this.myScrollPane, "Center");
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$3", "mousePressed"));
                }
                if (JBSwingUtilities.isRightMouseButton((MouseEvent)e)) {
                    int rowIndex = TableResultPanel.this.myTable.rowAtPoint(e.getPoint());
                    int columnIndex = TableResultPanel.this.myTable.columnAtPoint(e.getPoint());
                    if (rowIndex >= 0 && columnIndex >= 0 && !TableResultPanel.this.myTable.isCellSelected(rowIndex, columnIndex)) {
                        GridSelection.setRowSelection((JTable)((Object)TableResultPanel.this.myTable), rowIndex);
                        GridSelection.setColumnSelection((JTable)((Object)TableResultPanel.this.myTable), columnIndex);
                    }
                }
            }
        });
        EditorColorsManager.getInstance().addEditorColorsListener((EditorColorsListener)new EditorColorsAdapter(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                TableResultPanel.this.resizeTable(false);
            }
        }, (Disposable)this);
        this.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$5", "valueChanged"));
                }
                ((DataGridListener)TableResultPanel.this.myEventDispatcher.getMulticaster()).onSelectionChanged(TableResultPanel.this);
            }
        });
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$6", "valueChanged"));
                }
                TableResultPanel.this.myTable.getTableHeader().repaint();
                TableResultPanel.this.myTable.revalidate();
                TableResultPanel.this.myTable.repaint();
            }
        });
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        this.myColumnLayout = ApplicationManager.getApplication().isUnitTestMode() ? new DummyGridColumnLayout() : new DefaultGridColumnLayout(this);
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    TableResultPanel.this.updateColumnAttributes();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, this);
        }
        if (this.getDataModel().getColumnCount() != 0) {
            DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    TableResultPanel.this.columnsAdded(TableResultPanel.this.getDataModel().getColumnIndices());
                    TableResultPanel.this.resizeTable(true);
                }
            });
        }
    }

    @NotNull
    protected GridRowHeader createRowHeader() {
        MyGutterComponent myGutterComponent = new MyGutterComponent();
        if (myGutterComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createRowHeader"));
        }
        return myGutterComponent;
    }

    protected MyTableView createTableView(@NotNull GridCellEditorFactoryProvider editorProvider) {
        if (editorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProvider", "com/intellij/database/run/ui/TableResultPanel", "createTableView"));
        }
        return new MyTableView(editorProvider);
    }

    private void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$10", "error"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (message != null) {
                    Throwable throwable = new Throwable(message);
                    throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
                    th = throwable;
                }
                if (th != null) {
                    TableResultPanel.this.handleError(source, th);
                }
                if (source.source instanceof MyRequestSource) {
                    ((MyRequestSource)((Object)source.source)).setErrorReported();
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$10", "updateCountReceived"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (source.source instanceof MyRequestSource) {
                    ((MyRequestSource)((Object)source.source)).setUpdateCount(updateCount);
                }
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                int actualUpdateCount;
                int expectedUpdateCount;
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$10", "requestFinished"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                MyRequestSource requestSource = (MyRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, MyRequestSource.class));
                if (requestSource == null) {
                    return;
                }
                if (success && !requestSource.isErrorReported() && DataGridUtil.getDataBusHookUp(TableResultPanel.this) != null && (expectedUpdateCount = requestSource.rows.size()) != (actualUpdateCount = requestSource.getUpdateCount())) {
                    Exception e = new Exception(actualUpdateCount + " rows updated.");
                    e.setStackTrace(new StackTraceElement[0]);
                    TableResultPanel.this.showError(e, requestSource);
                }
                requestSource.requestComplete(success);
            }
        }, this);
        this.getDataModel().addListener(this, this);
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        List<DataConsumer.Column> columns = this.getDataModel().getColumns();
        if (!this.isTransposed()) {
            this.myColumnCache.retainColumns(columns);
        }
        this.myColumnAttributes.newColumns(columns);
        this.updateColumnAttributes();
        this.updateSortKeysFromColumnAttributes();
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.getModel().columnsAdded(columnIndices);
        this.myTable.dropCaches();
        this.myColumnLayout.newColumnsAdded(columnIndices);
        this.resizeTable(false);
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
        this.myTable.getModel().columnsRemoved(columns);
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.dropCaches();
        this.resizeTable(false);
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsAdded(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myColumnLayout.newRowsAdded(rows);
        this.resizeTable(false);
        this.myFailedToSubmitInsertedRow = false;
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsRemoved(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.resizeTable(false);
        this.myFailedToSubmitInsertedRow = false;
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns) {
        this.myTable.getModel().cellsUpdated(rows, columns);
        this.myColumnLayout.newRowsAdded(rows);
    }

    private void registerEscapeAction() {
        String action = "grid.escape";
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), action);
        this.myTable.getActionMap().put(action, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
    }

    public void setOrdering(List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> o : ordering) {
            ModelIndex<DataConsumer.Column> columnIdx = o.getColumn();
            DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
            this.myColumnAttributes.changeSortOrder(column, o.getOrder());
        }
        this.updateSortKeysFromColumnAttributes();
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getSortOrder"));
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder(this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSortOrder"));
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getThenBySortOrder"));
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder(this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.isTransposed() || this.isSortViaOrderBy();
    }

    protected int getSortOrder(@Nullable DataConsumer.Column column) {
        return column != null ? this.myColumnAttributes.getSortOrder(column) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener, Disposable disposable) {
        this.myEventDispatcher.addListener((EventListener)listener, disposable);
    }

    private void addSelectionListener(ListSelectionListener selectionListener) {
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myUseConsoleFonts ? new GridColorsScheme.ForConsole() : new GridColorsScheme();
        if (gridColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getColorsScheme"));
        }
        return gridColorsScheme;
    }

    @Override
    @Nullable
    public JComponent getCellRendererComponent(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int column;
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/TableResultPanel", "getCellRendererComponent"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getCellRendererComponent"));
        }
        ViewIndex<DataConsumer.Row> viewRow = rowIdx.toView(this);
        ViewIndex<DataConsumer.Column> viewColumn = columnIdx.toView(this);
        if (!viewRow.isValid(this) || !viewColumn.isValid(this)) {
            return null;
        }
        int row = (this.isTransposed() ? viewColumn : viewRow).asInteger();
        TableCellRenderer renderer = this.myTable.getCellRenderer(row, column = (this.isTransposed() ? viewRow : viewColumn).asInteger());
        if (renderer == null) {
            return null;
        }
        return (JComponent)this.myTable.prepareRenderer(renderer, row, column);
    }

    @Override
    public void searchSessionStarted(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchSession", "com/intellij/database/run/ui/TableResultPanel", "searchSessionStarted"));
        }
        assert (this.mySearchSession == null);
        this.mySearchSession = searchSession;
        this.mySearchSession.addListener(this, this);
        this.searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchSession", "com/intellij/database/run/ui/TableResultPanel", "searchSessionStopped"));
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.searchSessionUpdated();
    }

    @Override
    @Nullable
    public GridSearchSession<DataConsumer.Row, DataConsumer.Column> getSearchSession() {
        return this.mySearchSession;
    }

    @Override
    public void searchSessionUpdated() {
        this.myTable.updateRowFilter();
        this.getComponent().repaint();
    }

    protected JBTable getTable() {
        return this.myTable;
    }

    public JBTable getTableView() {
        return this.myTable;
    }

    protected TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myConverter;
    }

    @Override
    public boolean isEditable() {
        return this.myReady && !this.myDataHookUp.isReadOnly();
    }

    @Override
    public boolean isCellEditingAllowed() {
        return true;
    }

    @Override
    public void setCells(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setCells"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setCells"));
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        if (mutator != null && this.isSafeToUpdate(rows, columns, value)) {
            MyRequestSource source = new MyRequestSource(this, rows, columns);
            mutator.update(GridRequestSource.create(this, (Object)source), rows, columns, value);
        }
    }

    @Override
    public boolean isEditingCellMaximized() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.isEditingCellMaximized();
    }

    @Override
    public boolean canMaximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.canMaximizeEditingCell();
    }

    @Override
    public void maximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        if (resizableCellEditorsSupport != null) {
            resizableCellEditorsSupport.maximizeEditingCell();
        }
    }

    Project getProject() {
        return this.myProject;
    }

    @Override
    public void insertRow() {
        final GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(new Runnable(){

            @Override
            public void run() {
                mutator.insertRow(TableResultPanel.this.newInsertOrCloneRowRequestSource());
            }
        });
    }

    @Override
    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        if (rowToClone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowToClone", "com/intellij/database/run/ui/TableResultPanel", "cloneRow"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
    }

    private GridRequestSource<DataConsumer.Row, DataConsumer.Column> newInsertOrCloneRowRequestSource() {
        MyRequestSource source = new MyRequestSource(this);
        source.doWhenDone(new Runnable(){

            @Override
            public void run() {
                GridMutator.RowsMutator mutator = TableResultPanel.this.getRowsMutator();
                ModelIndex row = mutator != null ? mutator.getInsertedRow() : ModelIndex.forRow(TableResultPanel.this, -1);
                row = row.isValid(TableResultPanel.this) ? row : ModelIndex.forRow(TableResultPanel.this, TableResultPanel.this.getDataModel().getRowCount() - 1);
                TableResultPanel.this.scrollToLocally(row.toView(TableResultPanel.this), ViewIndex.forColumn(TableResultPanel.this, 0));
            }
        });
        return GridRequestSource.create(this, (Object)source);
    }

    @Override
    public void insertColumn() {
        final GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(new Runnable(){

            @Override
            public void run() {
                mutator.insertColumn(GridRequestSource.create(TableResultPanel.this, (Object)TableResultPanel.this.newInsertOrCloneColumnRequestSource()));
            }
        });
    }

    @Override
    public void cloneColumn(final @NotNull ModelIndex<DataConsumer.Column> columnToClone) {
        if (columnToClone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnToClone", "com/intellij/database/run/ui/TableResultPanel", "cloneColumn"));
        }
        final GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(new Runnable(){

            @Override
            public void run() {
                mutator.cloneColumn(GridRequestSource.create(TableResultPanel.this, (Object)TableResultPanel.this.newInsertOrCloneColumnRequestSource()), columnToClone);
            }
        });
    }

    private MyRequestSource newInsertOrCloneColumnRequestSource() {
        MyRequestSource source = new MyRequestSource(this);
        source.doWhenDone(new Runnable(){

            @Override
            public void run() {
                ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(TableResultPanel.this, TableResultPanel.this.getDataModel().getColumnCount() - 1);
                TableResultPanel.this.scrollToLocally(ViewIndex.forRow(TableResultPanel.this, 0), column.toView(TableResultPanel.this));
            }
        });
        return source;
    }

    @Override
    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "deleteRows"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        if (!mutator.hasPendingChanges() || rows.asIterable().contains(mutator.getInsertedRow()) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this)) {
            MyRequestSource source = new MyRequestSource(this, rows, ModelIndexSet.forColumns(this, new int[0]));
            mutator.deleteRows(GridRequestSource.create(this, (Object)source), rows);
        }
    }

    @Override
    public boolean isRowsMutationSupported() {
        return this.getRowsMutator() != null;
    }

    @Override
    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "deleteColumns"));
        }
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator != null) {
            MyRequestSource source = new MyRequestSource(this, ModelIndexSet.forRows(this, new int[0]), columns);
            mutator.deleteColumns(GridRequestSource.create(this, (Object)source), columns);
        }
    }

    @Override
    public boolean isColumnsMutationSupported() {
        return this.getColumnsMutator() != null;
    }

    @Override
    public void submitInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "submitInsertedRow"));
        }
        this.doSubmitInsertedRow();
    }

    @NotNull
    private ActionCallback doSubmitInsertedRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null || !mutator.getInsertedRow().isValid(this)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "doSubmitInsertedRow"));
            }
            return actionCallback;
        }
        MyRequestSource source = new MyRequestSource(this, mutator.getInsertedRow(), ModelIndex.forColumn(this, -1));
        mutator.submitInsertedRow(GridRequestSource.create(this, (Object)source));
        MyRequestSource myRequestSource = source;
        if (myRequestSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "doSubmitInsertedRow"));
        }
        return myRequestSource;
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        GridMutator.RowsMutator mutator = (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.RowsMutator.class);
        return mutator;
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        GridMutator.ColumnsMutator mutator = (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.ColumnsMutator.class);
        return mutator;
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "isInsertedRow"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        ModelIndex<DataConsumer.Row> insertedRow = mutator != null ? mutator.getInsertedRow() : ModelIndex.forRow(this, -1);
        return insertedRow.isValid(this) && insertedRow.equals(row);
    }

    @Override
    public int getSelectedRowCount() {
        return this.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        int viewRowIndex = this.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this, viewRowIndex >= 0 ? viewRowIndex : -1).toModel(this);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedRow"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ViewIndexSet.forRows(this, this.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows()).toModel(this);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedRows"));
        }
        return modelIndexSet;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "isSelected"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isSelected"));
        }
        ViewIndex<DataConsumer.Row> viewRow = row.toView(this);
        ViewIndex<DataConsumer.Column> viewColumn = column.toView(this);
        int displayRow = this.isTransposed() ? viewColumn.asInteger() : viewRow.asInteger();
        int displayColumn = this.isTransposed() ? viewRow.asInteger() : viewColumn.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    @Override
    public void clearSelection() {
        this.myTable.clearSelection();
    }

    @Override
    @NotNull
    public SelectionModel<DataConsumer.Row, DataConsumer.Column> getSelectionModel() {
        TableResultPanel tableResultPanel = this;
        if (tableResultPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectionModel"));
        }
        return tableResultPanel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(this.getDataHookup(), DataRequest.OwnerEx.class);
        String string = ownerEx != null ? StringUtil.notNullize((String)ownerEx.getDisplayName()) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public GridMarkupModel<DataConsumer.Row, DataConsumer.Column> getMarkupModel() {
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getMarkupModel"));
        }
        return gridMarkupModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel() {
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.myDataHookUp.getModel();
        if (gridModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDataModel"));
        }
        return gridModel;
    }

    @Override
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getDataHookup() {
        return this.myDataHookUp;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        GridRawIndexConverter gridRawIndexConverter = this.myRawIndexConverter;
        if (gridRawIndexConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getRawIndexConverter"));
        }
        return gridRawIndexConverter;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        MyTableView myTableView = this.myTable;
        if (myTableView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getPreferredFocusedComponent"));
        }
        return myTableView;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getScrollPane"));
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getLoadingPanel"));
        }
        return gridMainPanel;
    }

    @NotNull
    public JBLoadingPanel getComponent() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getComponent"));
        }
        return gridMainPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component component) {
        this.myMainPanel.setTopComponent(component);
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return this.myMainPanel.getTopComponent();
    }

    @Override
    @Nullable
    public GridColumn getLayoutColumn(@NotNull ModelIndex<?> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getLayoutColumn"));
        }
        int viewColumnIdx = (this.isTransposed() ? this.myRawIndexConverter.row2View() : this.myRawIndexConverter.column2View()).fun(column.asInteger());
        return viewColumnIdx != -1 ? this.myColumnCache.getOrCreateColumn(column.asInteger()) : null;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        int visibleColumns = this.getVisibleColumnCount();
        int[] viewIndices = new int[visibleColumns];
        for (int i = 0; i < visibleColumns; ++i) {
            viewIndices[i] = i;
        }
        ModelIndexSet<DataConsumer.Column> columnIndices = ViewIndexSet.forColumns(this, viewIndices).toModel(this);
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.validIndexSet(columnIndices, new Function<int[], ModelIndexSet<DataConsumer.Column>>(){

            public ModelIndexSet<DataConsumer.Column> fun(int[] columnIndices) {
                return ModelIndexSet.forColumns(TableResultPanel.this, columnIndices);
            }
        });
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getVisibleColumns"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        int rowCount = this.isTransposed() ? this.myTable.getModel().getColumnCount() : this.myTable.getModel().getRowCount();
        int[] viewRowIndices = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            viewRowIndices[i] = i;
        }
        ModelIndexSet<DataConsumer.Row> rowIndices = ViewIndexSet.forRows(this, viewRowIndices).toModel(this);
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.validIndexSet(rowIndices, new Function<int[], ModelIndexSet<DataConsumer.Row>>(){

            public ModelIndexSet<DataConsumer.Row> fun(int[] rowIndices) {
                return ModelIndexSet.forRows(TableResultPanel.this, rowIndices);
            }
        });
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getVisibleRows"));
        }
        return modelIndexSet;
    }

    @NotNull
    private <T> ModelIndexSet<T> validIndexSet(@NotNull ModelIndexSet<T> indexSet, @NotNull Function<int[], ModelIndexSet<T>> factory) {
        if (indexSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexSet", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        IntArrayList validIndices = new IntArrayList(indexSet.size());
        for (ModelIndex idx : indexSet.asIterable()) {
            if (!idx.isValid(this)) continue;
            validIndices.add(idx.asInteger());
        }
        ModelIndexSet modelIndexSet = (ModelIndexSet)factory.fun((Object)validIndices.toArray());
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        return modelIndexSet;
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns.toView(this).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this).asInteger());
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns.toView(this).asInteger());
    }

    private void doSetSelection(boolean isColumnSelection, int ... selection) {
        boolean transposed = this.isTransposed();
        if (isColumnSelection && !transposed || !isColumnSelection && transposed) {
            GridSelection.setColumnSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedRow() == -1) {
                GridSelection.setRowSelection((JTable)((Object)this.myTable), 0);
            }
        } else {
            GridSelection.setRowSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedColumn() == -1) {
                GridSelection.setColumnSelection((JTable)((Object)this.myTable), 0);
            }
        }
    }

    @Override
    public void scrollSelectionToVisible() {
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myTable));
    }

    @Override
    public boolean isEditing() {
        return this.myTable.isEditing();
    }

    @Override
    public boolean stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor == null) {
            return true;
        }
        int columnDataIdx = this.myTable.convertColumnIndexToModel(this.myTable.getEditingColumn());
        int rowDataIdx = this.myTable.convertRowIndexToModel(this.myTable.getEditingRow());
        ModelIndexSet<DataConsumer.Row> myEditingRowIdx = ModelIndexSet.forRows(this, this.isTransposed() ? columnDataIdx : rowDataIdx);
        ModelIndexSet<DataConsumer.Column> myEditingColumnIdx = ModelIndexSet.forColumns(this, this.isTransposed() ? rowDataIdx : columnDataIdx);
        return this.isSafeToUpdate(myEditingRowIdx, myEditingColumnIdx, editor.getCellEditorValue()) && editor.stopCellEditing();
    }

    @Override
    public void cancelEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public void editSelectedCell() {
        TableUtil.editCellAt((JTable)((Object)this.myTable), (int)this.myTable.getSelectedRow(), (int)this.myTable.getSelectedColumn());
    }

    @Override
    public boolean isViewModified() {
        for (DataConsumer.Column column : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = column == null || !DbImplUtil.isComputedColumn(column);
            boolean shown = this.myColumnAttributes.isEnabled(column);
            boolean bl = sortOrderChanged = this.getSortOrder(column) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        for (MyTableColumn tableColumn : this.myColumnCache) {
            int modelIndex = tableColumn.getModelIndex();
            int viewIdx = (this.isTransposed() ? this.myRawIndexConverter.row2View() : this.myRawIndexConverter.column2View()).fun(modelIndex);
            if ((viewIdx == -1 || viewIdx == modelIndex) && tableColumn.isWidthSetByLayout()) continue;
            return true;
        }
        int defaultRowHeight = this.myTable.getRowHeight();
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (this.myTable.getRowHeight(i) == defaultRowHeight) continue;
            return true;
        }
        return false;
    }

    public int getVisibleColumnCount() {
        return this.isTransposed() ? this.myTable.getRowCount() : this.myTable.getColumnCount();
    }

    private void showError(@NotNull Throwable error, @Nullable MyRequestSource source) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/TableResultPanel", "showError"));
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(error, (JComponent)((Object)this.myMainPanel));
        if (source != null && source.rows.size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.rows.first();
            ModelIndex modelColumnIdx = (ModelIndex)source.cols.first();
            final ViewIndex viewRowIdx = modelRowIdx.toView(this);
            final ViewIndex viewColumnIdx = modelColumnIdx.toView(this);
            int r = viewRowIdx.asInteger() + 1;
            int c = viewColumnIdx.asInteger() + 1;
            String title = c < 1 ? "Row#" + r : "[" + r + "x" + c + "]";
            builder.addLink("navigate", title, new Runnable(){

                @Override
                public void run() {
                    if (viewRowIdx.isValid(TableResultPanel.this) && viewColumnIdx.isValid(TableResultPanel.this)) {
                        TableResultPanel.this.scrollToLocally(viewRowIdx, viewColumnIdx);
                    }
                }
            });
            if (modelRowIdx.isValid(this) && this.isInsertedRow(modelRowIdx) && !modelColumnIdx.isValid(this)) {
                this.myFailedToSubmitInsertedRow = true;
            }
        }
        this.myErrorNotificationPanel = builder.addDetailsButton().addCloseButton(new Runnable(){

            @Override
            public void run() {
                TableResultPanel.this.hideErrorPanel();
            }
        }).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource, final @NotNull Throwable error) {
        if (requestSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestSource", "com/intellij/database/run/ui/TableResultPanel", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/TableResultPanel", "handleError"));
        }
        final Object source = requestSource.source;
        DbUIUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (source == TableResultPanel.this.myFilterPanel) {
                    TableResultPanel.this.myFilterPanel.showErrorBalloon(error);
                } else {
                    TableResultPanel.this.showError(error, (MyRequestSource)((Object)ObjectUtils.tryCast((Object)source, MyRequestSource.class)));
                }
            }
        });
    }

    private void resizeTable(boolean updateColumnWidths) {
        Container parent;
        Container container = parent = this.myTable != null ? this.myTable.getParent() : null;
        if (parent == null) {
            return;
        }
        if (updateColumnWidths) {
            DbUIUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TableResultPanel.this.myColumnLayout.doLayout();
                }
            });
        }
        Dimension size = parent.getSize();
        this.myTable.setPreferredSize(this.getDataModel().getColumnCount() == 0 ? size : null);
        parent.validate();
    }

    @Nullable
    protected Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new GridCopyProvider(this);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DeleteRowsAction();
        }
        if (DatabaseDataKeys.DATA_GRID_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getPsiElementForSelection();
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private PsiElement getPsiElementForSelection() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return DataGridPomTarget.wrapDataGrid(this.myProject, this);
        }
        return DataGridPomTarget.wrapCell(this.myProject, this, selectionModel.getSelectedRows(), selectionModel.getSelectedColumns());
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this, this.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn()).toModel(this);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedColumn"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ViewIndexSet.forColumns(this, this.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns()).toModel(this);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedColumns"));
        }
        return modelIndexSet;
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull RowSortOrder.Type order) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "sortColumns"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/database/run/ui/TableResultPanel", "sortColumns"));
        }
        boolean updated = false;
        for (ModelIndex<DataConsumer.Column> column : columns) {
            updated |= this.changeSortOrder(column, order, true);
        }
        if (updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        Language language = column != null ? this.getContentLanguage(column) : Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        Language fromAttributes = this.myColumnAttributes.getContentLanguage(column);
        if (fromAttributes != Language.ANY) {
            Language language = fromAttributes;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        DatabaseFamilyId family = DataGridUtil.getDatabaseDialect(this).getFamilyId();
        if (family.isPostgres() && ObjectFormatter.isPostgresJsonx(column)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(JSON_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        if (family.isTransactSql() && StringUtil.equalsIgnoreCase((CharSequence)"xml", (CharSequence)column.typeName)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        if (column.type == 2009) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        return language;
    }

    @NotNull
    private static Language getLanguageByIdOrAny(@NotNull String languageId) {
        if (languageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/database/run/ui/TableResultPanel", "getLanguageByIdOrAny"));
        }
        Language language = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)languageId), (Object)Language.ANY);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getLanguageByIdOrAny"));
        }
        return language;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "setContentLanguage"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/TableResultPanel", "setContentLanguage"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            this.myColumnAttributes.setContentLanguage(column, language);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myClickedHeaderColumnIdx;
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContextColumn"));
        }
        return modelIndex;
    }

    @Override
    public boolean setFilterText(String filter, int caretPosition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFilteringEnabled() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            this.toggleFiltering();
        }
        return this.myFilterPanel.setFilterText(filter, caretPosition);
    }

    @Override
    public void applyFilter() {
        if (this.isSafeToReload()) {
            this.myFilterPanel.currentFilterApplied();
            this.myDataHookUp.getLoader().applyFilter(GridRequestSource.create(this, (Object)this.myFilterPanel));
        }
    }

    @Override
    public boolean isReady() {
        return this.myReady && !this.getDataModel().isUpdatingNow();
    }

    public void setReady(boolean b) {
        this.myReady = b;
    }

    @Override
    public boolean isEmpty() {
        return this.myTable.isEmpty();
    }

    public void dispose() {
        this.myTable.removeEditor();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> uiRow(int uiRow) {
        ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(this, uiRow < 1 ? -1 : uiRow - 1);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "uiRow"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> uiColumn(int uiColumn) {
        int modelIndex = uiColumn < 1 || uiColumn >= this.getVisibleColumnCount() + 1 ? -1 : this.myRawIndexConverter.column2Model().fun(uiColumn - 1);
        ModelIndex<DataConsumer.Column> modelIndex2 = ModelIndex.forColumn(this, modelIndex);
        if (modelIndex2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "uiColumn"));
        }
        return modelIndex2;
    }

    @Override
    public void showCell(final @NotNull ModelIndex<DataConsumer.Row> row, final @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "showCell"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "showCell"));
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                int rawRowIndex = row.asInteger() + 1;
                TableResultPanel.this.scrollTo(rawRowIndex, column.toView(TableResultPanel.this).asInteger());
            }
        });
    }

    private void scrollTo(final int dataRowIndex, final int viewColumnIndex) {
        final GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = new Runnable(){

            @Override
            public void run() {
                ViewIndex row = pageModel.findRow(dataRowIndex).toView(TableResultPanel.this);
                ViewIndex<DataConsumer.Column> column = ViewIndex.forColumn(TableResultPanel.this, viewColumnIndex);
                TableResultPanel.this.scrollToLocally(row, column);
            }
        };
        if (pageModel.findRow(dataRowIndex).isValid(this)) {
            localScrollRunnable.run();
        } else {
            GridLoader<DataConsumer.Row, DataConsumer.Column> loader = this.myDataHookUp.getLoader();
            int startIdx = Math.max(1, dataRowIndex - pageModel.getPageSize() / 2);
            loader.load(GridRequestSource.create(this, new MyRequestSource(this).doWhenDone(localScrollRunnable)), startIdx);
        }
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> column) {
        this.setRowSelection(row.toModel(this));
        this.setColumnSelection(column.toModel(this));
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.isFilteringEnabledInModel() && this.myFilterPanel.isVisible();
    }

    private boolean isFilteringEnabledInModel() {
        GridFilteringModel filteringModel = this.getDataHookup().getFilteringModel();
        return filteringModel != null && filteringModel.isFilteringEnabled();
    }

    @Override
    public boolean toggleFiltering() {
        if (!this.isFilteringEnabledInModel()) {
            return false;
        }
        boolean enabled = !this.isFilteringEnabled();
        this.myFilterPanel.setVisible(enabled);
        if (enabled) {
            this.myFilterPanel.requestFocusInWindow();
        }
        return enabled;
    }

    @NotNull
    private Color getHeaderCellBackground(boolean selected, boolean inserted, Color tableBg) {
        Object object = inserted ? (this.myFailedToSubmitInsertedRow ? TableResultPanel.getFailedToInsertColor() : this.getInsertedBackgroundColor()) : (selected ? this.getSelectedHeaderCellBackground() : DbUIUtil.softHighlightOf((Color)tableBg));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getHeaderCellBackground"));
        }
        return object;
    }

    private JBColor getSelectedHeaderCellBackground() {
        Color selectedColumnBackground = (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW), (Object)UIUtil.getDecoratedRowColor());
        return new JBColor(selectedColumnBackground, selectedColumnBackground);
    }

    private Color getInsertedBackgroundColor() {
        return this.getColorsScheme().getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
    }

    private static Color getFailedToInsertColor() {
        return MessageType.ERROR.getPopupBackground();
    }

    private static Icon getSortOrderIcon(int sortOrder) {
        return sortOrder < 0 ? AllIcons.General.SplitUp : (sortOrder > 0 ? AllIcons.General.SplitDown : AllIcons.General.SplitCenterV);
    }

    private static String getSortOrderText(int sortOrder) {
        return sortOrder != 0 ? String.valueOf(Math.abs(sortOrder)) : "";
    }

    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isInitiallyDisabled"));
        }
        return DbImplUtil.isComputedColumn(column);
    }

    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getInitialContentLanguage"));
        }
        return Language.ANY;
    }

    private SimpleDateFormat getDateFormat(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getDateFormat"));
        }
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        ObjectFormatter converter = this.getObjectFormatter();
        return jdbcType == 91 ? converter.getDateFormat() : (jdbcType == 92 ? converter.getTimeFormat() : (jdbcType == 93 ? converter.getTimestampFormat(column, DataGridUtil.getDatabaseDialect(this)) : null));
    }

    @NotNull
    protected RowFilter<TableModel, Integer> createFilter() {
        RowFilter rowFilter = this.isTransposed() ? new MyTransposedViewColumnFilter() : new MySearchRowFilter();
        if (rowFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createFilter"));
        }
        return rowFilter;
    }

    protected boolean isHeaderSelecting() {
        return false;
    }

    protected boolean allowHeaderActionsInTransposeMode() {
        return false;
    }

    private DataConsumer.Row getRow(int modelRowIdx) {
        return this.getDataModel().getRow(ModelIndex.forRow(this, modelRowIdx));
    }

    private DataConsumer.Column getColumn(int modelColumnIdx) {
        return this.getDataModel().getColumn(ModelIndex.forColumn(this, modelColumnIdx));
    }

    private void updateColumnAttributes() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : this.getOrderingFromModel()) {
            this.changeSortOrder(order.getColumn(), order.getOrder(), true);
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> getOrderingFromModel() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> list = sortingModel != null ? sortingModel.getOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getOrderingFromModel"));
        }
        return list;
    }

    private void updateSortKeysFromColumnAttributes() {
        RowSorter rowSorter = this.myTable.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(this.isTransposed() || this.isSortViaOrderBy() ? null : this.createSortKeys());
        }
    }

    @Nullable
    private List<RowSorter.SortKey> createSortKeys() {
        if (this.isTransposed()) {
            return ContainerUtil.emptyList();
        }
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        int orderIdx = 0;
        Object[] keys = new RowSorter.SortKey[sortOrderMap.size()];
        for (DataConsumer.Column column : sortOrderMap.values()) {
            RowSorter.SortKey key = new RowSorter.SortKey(column.columnNum, this.getSortOrder(column) < 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            keys[orderIdx++] = key;
        }
        return ContainerUtil.newArrayList((Object[])keys);
    }

    private boolean changeSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable RowSortOrder.Type targetSortOrder, boolean silent) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "changeSortOrder"));
        }
        boolean updated = false;
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            updated = this.myColumnAttributes.changeSortOrder(column, targetSortOrder);
        }
        if (!silent && updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
        return updated;
    }

    private boolean updateDataOrderingIfNeeded() {
        return this.isSortViaOrderBy() && this.updateDataOrdering(true);
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List newOrdering;
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> createOrdering() {
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        ArrayList ordering = ContainerUtil.newArrayListWithCapacity((int)sortOrderMap.size());
        for (DataConsumer.Column column : sortOrderMap.values()) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this, column.columnNum);
            ordering.add(this.getSortOrder(column) < 0 ? RowSortOrder.asc(columnIdx) : RowSortOrder.desc(columnIdx));
        }
        ArrayList arrayList = ordering;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createOrdering"));
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering2) {
        if (ordering1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ordering1", "com/intellij/database/run/ui/TableResultPanel", "isSameOrdering"));
        }
        if (ordering2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ordering2", "com/intellij/database/run/ui/TableResultPanel", "isSameOrdering"));
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i = 0; i < ordering1.size(); ++i) {
            RowSortOrder<ModelIndex<DataConsumer.Column>> o1 = ordering1.get(i);
            RowSortOrder<ModelIndex<DataConsumer.Column>> o2 = ordering2.get(i);
            if (Comparing.equal((Object)((Object)o1.getOrder()), (Object)((Object)o2.getOrder())) && Comparing.equal(o1.getColumn(), o2.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isColumnEnabled"));
        }
        return column.isValid(this) && this.myColumnAttributes.isEnabled(this.getDataModel().getColumn(column));
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "setColumnEnabled"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column == null || this.myColumnAttributes.isEnabled(column) == state) {
            return;
        }
        if (this.isTransposed()) {
            GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
            this.myColumnAttributes.setEnabled(column, state);
            this.myTable.getModel().fireTableDataChanged();
            selection.restore((JTable)((Object)this.myTable));
        } else {
            this.setColumnEnabled(columnIdx.asInteger(), state);
        }
    }

    @Override
    public void transpose() {
        final GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        final GridScrollPosition scrollPosition = GridScrollPosition.store((JTable)((Object)this.myTable));
        this.doTranspose();
        DbUIUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                selection.transpose().restore((JTable)((Object)TableResultPanel.this.myTable));
                scrollPosition.transpose().restore((JTable)((Object)TableResultPanel.this.myTable));
            }
        });
    }

    private void doTranspose() {
        this.myColumnCache.retainColumns(ContainerUtil.emptyList());
        this.myTable.setModel(this.myTable.isTransposedMode() ? new GridTableModel.Regular(this) : new GridTableModel.Transposed(this));
        this.myRawIndexConverter.transpose();
        this.myColumnLayout.setTransposed(this.isTransposed());
        this.myTable.createDefaultColumnsFromModel();
    }

    @Override
    public boolean isTransposed() {
        return this.myTable != null && this.myTable.isTransposedMode();
    }

    protected void setColumnEnabled(int columnDataIdx, boolean enable) {
        if (!this.isTransposed()) {
            DataConsumer.Column column = this.getDataModel().getColumn(ModelIndex.forColumn(this, columnDataIdx));
            this.myColumnAttributes.setEnabled(column, enable);
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        MyTableColumnModel columnModel = this.myTable.getColumnModel();
        int viewColumnIdx = this.myTable.convertColumnIndexToView(columnDataIdx);
        if (enable && viewColumnIdx < 0) {
            boolean firstTimeShown = !this.myColumnCache.hasCachedColumn(columnDataIdx);
            this.myTable.addColumn(this.myColumnCache.getOrCreateColumn(columnDataIdx));
            viewColumnIdx = this.myTable.getColumnCount() - 1;
            for (int viewTargetColumnIdx = 0; viewTargetColumnIdx < viewColumnIdx; ++viewTargetColumnIdx) {
                if (columnModel.getColumn(viewTargetColumnIdx).getModelIndex() <= columnDataIdx) continue;
                this.myTable.moveColumn(viewColumnIdx, viewTargetColumnIdx);
                break;
            }
            if (firstTimeShown) {
                this.myColumnLayout.columnsShown(this.isTransposed() ? ModelIndexSet.forColumns(this, columnDataIdx) : ModelIndexSet.forRows(this, columnDataIdx));
            }
        } else if (!enable && viewColumnIdx >= 0) {
            this.myTable.getTableHeader().setDraggedColumn(null);
            columnModel.removeColumn(columnModel.getColumn(viewColumnIdx));
        } else {
            return;
        }
        selection.restore((JTable)((Object)this.myTable));
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
        if (!this.isTransposed()) {
            this.updateSortKeysFromColumnAttributes();
        }
    }

    private boolean isSafeToReload() {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    private boolean isSafeToUpdate(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "isSafeToUpdate"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "isSafeToUpdate"));
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || mutator.isUpdateSafe(rows, columns, newValue) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public JPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getFilterPanel"));
        }
        return gridFilterPanel;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    @Override
    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        this.resetOrderingAndVisibility();
        this.resetRowHeights();
        this.myTable.createDefaultColumnsFromModel();
        this.myColumnLayout.doLayout();
        selection.restore((JTable)((Object)this.myTable));
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(GridRequestSource.create(this, null));
        }
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myTable.getModel().fireTableDataChanged();
    }

    private void resetRowHeights() {
        int defaultRowHeight = this.myTable.getRowHeight();
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (this.myTable.getRowHeight(i) == defaultRowHeight) continue;
            this.myTable.setRowHeight(i, defaultRowHeight);
        }
    }

    @NotNull
    private String getColumnTooltipHtml(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getColumnTooltipHtml"));
        }
        String type = DataGridUtil.getSqlType(this, column);
        String string = "<html><b>" + this.myColumnAttributes.getName(column) + "</b>" + (StringUtil.isNotEmpty((String)type) ? ": " + type : "") + this.getDateFormatSuffix(column) + "</html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getColumnTooltipHtml"));
        }
        return string;
    }

    @NotNull
    private String getDateFormatSuffix(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getDateFormatSuffix"));
        }
        SimpleDateFormat dateFormat = this.getDateFormat(column);
        String string = dateFormat != null ? " (" + dateFormat.toPattern() + ")" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDateFormatSuffix"));
        }
        return string;
    }

    public static boolean isIntervalModifierSet(MouseEvent e) {
        return 0 != (e.getModifiersEx() & 0x40);
    }

    public static boolean isExclusiveModifierSet(MouseEvent e) {
        return 0 != (e.getModifiersEx() & 0x180);
    }

    private static Rectangle getLabelTextRect(JLabel label) {
        Dimension pref = label.getPreferredSize();
        Rectangle bounds = label.getBounds();
        Insets insets = label.getInsets();
        int w = Math.min(pref.width, bounds.width);
        bounds.setSize(w - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        bounds.translate(insets.left, insets.top);
        return bounds;
    }

    private class MyRequestSource
    extends ActionCallback {
        final ModelIndexSet<DataConsumer.Row> rows;
        final ModelIndexSet<DataConsumer.Column> cols;
        private int myUpdateCount;
        private boolean myErrorReported;
        final /* synthetic */ TableResultPanel this$0;

        public MyRequestSource(TableResultPanel tableResultPanel) {
            this(tableResultPanel, ModelIndexSet.forRows(tableResultPanel, new int[0]), ModelIndexSet.forColumns(tableResultPanel, new int[0]));
        }

        public MyRequestSource(@NotNull TableResultPanel tableResultPanel, @NotNull ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> col) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            if (col == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            this(tableResultPanel, ModelIndexSet.forRows(tableResultPanel, row.asInteger()), ModelIndexSet.forColumns(tableResultPanel, col.asInteger()));
        }

        public MyRequestSource(@NotNull TableResultPanel tableResultPanel, @NotNull ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> cols) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            if (cols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            this.this$0 = tableResultPanel;
            this.rows = rows;
            this.cols = cols;
        }

        public void requestComplete(boolean success) {
            if (success) {
                this.setDone();
            } else {
                this.setRejected();
            }
        }

        public void setUpdateCount(int updateCount) {
            assert (this.myUpdateCount == 0 && this.rows.size() != 0);
            this.myUpdateCount = updateCount;
        }

        public int getUpdateCount() {
            return this.myUpdateCount;
        }

        public void setErrorReported() {
            this.myErrorReported = true;
        }

        public boolean isErrorReported() {
            return this.myErrorReported;
        }
    }

    protected class ColumnInfoRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        private final JLabel myNameLabel;
        private final JLabel mySortLabel;

        public ColumnInfoRowHeaderCellComponent() {
            this.myNameLabel = new JBLabel();
            this.mySortLabel = new JBLabel();
            this.setLayout(new BorderLayout());
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)0));
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)3));
            this.mySortLabel.setVerticalAlignment(0);
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
        }

        @Override
        public void setRow(int viewRowIdx) {
            super.setRow(viewRowIdx);
            assert (TableResultPanel.this.isTransposed());
            ModelIndex<DataConsumer.Column> modelColumnIdx = ViewIndex.forColumn(TableResultPanel.this, viewRowIdx).toModel(TableResultPanel.this);
            DataConsumer.Column column = TableResultPanel.this.getDataModel().getColumn(modelColumnIdx);
            if (column == null) {
                return;
            }
            Font font = TableResultPanel.this.myTable.getTableHeader().getFont();
            Color fg = TableResultPanel.this.myTable.getForeground();
            this.myNameLabel.setFont(font);
            this.mySortLabel.setFont(font);
            this.myNameLabel.setForeground(fg);
            this.mySortLabel.setForeground(fg);
            DasColumn databaseColumn = DataGridUtil.getDatabaseColumn(TableResultPanel.this, column);
            Icon icon = databaseColumn == null ? null : DbPresentation.getIcon((DasObject)databaseColumn);
            this.myNameLabel.setIcon(icon);
            this.myNameLabel.setText(TableResultPanel.this.myColumnAttributes.getName(column));
            this.mySortLabel.setText("");
            this.mySortLabel.setIcon(null);
            if (TableResultPanel.this.isSortViaOrderBy() && TableResultPanel.this.myColumnAttributes.getComparator(column) != null) {
                int sortOrder = TableResultPanel.this.myColumnAttributes.getSortOrder(column);
                this.mySortLabel.setIcon(TableResultPanel.getSortOrderIcon(sortOrder));
                this.mySortLabel.setText(TableResultPanel.getSortOrderText(sortOrder));
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawEffects(g, TableResultPanel.getLabelTextRect(this.myNameLabel));
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }
    }

    protected class RowNumberRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintLineNumber(g);
        }

        public Dimension getPreferredSize() {
            int preferredWidth = this.getPreferredWidth();
            return new Dimension(preferredWidth, TableResultPanel.this.myTable.getRowHeight(this.getRow()));
        }

        private int getPreferredWidth() {
            Insets insets = this.getInsets();
            return this.preferredWidthOf(this.getRowNumberString()) + (insets.right + insets.left);
        }

        private void paintLineNumber(Graphics g) {
            Font fontBackup = g.getFont();
            g.setFont(TableResultPanel.this.myTable.getFont());
            Insets insets = this.getInsets();
            int middleX = insets.left + (this.getWidth() - insets.left - insets.right) / 2;
            String rowNum = this.getRowNumberString();
            int stringWidth = g.getFontMetrics().stringWidth(rowNum);
            int baseline = this.getBaseline();
            g.drawString(rowNum, middleX - stringWidth / 2, baseline);
            FontMetrics metrics = TableResultPanel.this.myTable.getFontMetrics(TableResultPanel.this.myTable.getFont());
            int height = metrics.getAscent() - metrics.getDescent();
            this.drawEffects(g, new Rectangle(middleX - stringWidth / 2, baseline - height, stringWidth, height));
            g.setFont(fontBackup);
        }

        private String getRowNumberString() {
            boolean trueRows = TableResultPanel.this.myDataHookUp instanceof CsvDocumentDataHookUp && ((CsvDocumentDataHookUp)((TableResultPanel)TableResultPanel.this).myDataHookUp).getFormat().rowNumbers;
            ModelIndex<DataConsumer.Row> rowIndex = trueRows ? ViewIndex.forRow(TableResultPanel.this, this.getRow()).toModel(TableResultPanel.this) : ModelIndex.forRow(TableResultPanel.this, this.getRow());
            DataConsumer.Row row = TableResultPanel.this.getDataModel().getRow(rowIndex);
            return row instanceof NamedRow ? ((NamedRow)row).name : String.valueOf(row != null ? Integer.valueOf(row.rowNum) : "N/A");
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }

        private int getBaseline() {
            return TableResultPanel.this.myTable.getTextLineHeight() - TableResultPanel.this.myTable.getFontMetrics(TableResultPanel.this.myTable.getFont()).getDescent();
        }

        private int preferredWidthOf(String text) {
            return TableResultPanel.this.myTable.getFontMetrics(TableResultPanel.this.myTable.getFont()).stringWidth(text);
        }
    }

    private abstract class RowHeaderCellComponentBase
    extends CellRendererPanel {
        private int myRow;

        protected RowHeaderCellComponentBase() {
        }

        public void setRow(int row) {
            this.myRow = row;
        }

        public int getRow() {
            return this.myRow;
        }

        public boolean isShowing() {
            return true;
        }

        protected void paintComponent(Graphics g) {
            this.paintBackground(g);
        }

        private Color getMarkupBackground() {
            CellAttributes attributes = TableResultPanel.this.isTransposed() ? TableResultPanel.this.myMarkupModel.getColumnHeaderAttributes(ViewIndex.forColumn(TableResultPanel.this, this.myRow).toModel(TableResultPanel.this), TableResultPanel.this.getColorsScheme()) : TableResultPanel.this.myMarkupModel.getRowHeaderAttributes(ViewIndex.forRow(TableResultPanel.this, this.myRow).toModel(TableResultPanel.this), TableResultPanel.this.getColorsScheme());
            if (attributes != null && attributes.getBackgroundColor() != null) {
                return attributes.getBackgroundColor();
            }
            return null;
        }

        public Color getBackground() {
            return DbUIUtil.softHighlightOf((Color)((Color)ObjectUtils.chooseNotNull((Object)this.getMarkupBackground(), (Object)TableResultPanel.this.myTable.getBackground())));
        }

        public Color getCurrentBackground(boolean selected, boolean inserted) {
            Color bg = this.getMarkupBackground();
            return bg == null ? TableResultPanel.this.getHeaderCellBackground(selected, inserted, TableResultPanel.this.myTable.getBackground()) : (selected ? DbUIUtil.softHighlightOf((Color)bg) : bg);
        }

        public Color getForeground() {
            return TableResultPanel.this.myTable.getForeground();
        }

        private void paintBackground(Graphics g) {
            Color backup = g.getColor();
            boolean inserted = !TableResultPanel.this.isTransposed() && TableResultPanel.this.isInsertedRow(ViewIndex.forRow(TableResultPanel.this, this.myRow).toModel(TableResultPanel.this));
            g.setColor(this.getCurrentBackground(TableResultPanel.this.myTable.isRowSelected(this.myRow), inserted));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(backup);
        }
    }

    protected class MyGutterComponent
    extends GridRowHeader {
        public MyGutterComponent() {
            this(this$0.new RowNumberRowHeaderCellComponent(), this$0.new ColumnInfoRowHeaderCellComponent());
        }

        public MyGutterComponent(final @NotNull RowHeaderCellComponentBase regular, final RowHeaderCellComponentBase transposed) {
            if (regular == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regular", "com/intellij/database/run/ui/TableResultPanel$MyGutterComponent", "<init>"));
            }
            if (transposed == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transposed", "com/intellij/database/run/ui/TableResultPanel$MyGutterComponent", "<init>"));
            }
            super((JTable)((Object)TableResultPanel.this.myTable), new GridRowHeader.RowHeaderCellRenderer(){

                @Override
                public Component getRendererComponent(int row) {
                    RowHeaderCellComponentBase c = TableResultPanel.this.isTransposed() ? transposed : regular;
                    int li = this.isLeftSide() ? 1 : 0;
                    int ri = 1 - li;
                    c.setBorder(BorderFactory.createCompoundBorder((Border)new CustomLineBorder(TableResultPanel.this.myTable.getGridColor(), 0, ri, 0, li), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
                    c.setRow(row);
                    return c;
                }

                private boolean isLeftSide() {
                    GridScrollPane parent = (GridScrollPane)((Object)UIUtil.getParentOfType(GridScrollPane.class, (Component)((Object)TableResultPanel.this.myTable)));
                    return parent == null || !parent.isFlipped();
                }
            });
            TableResultPanel.this.addDataGridListener(new DataGridListener(){

                @Override
                public void onSelectionChanged(DataGrid dataGrid) {
                    MyGutterComponent.this.invalidate();
                    MyGutterComponent.this.repaint();
                }

                @Override
                public void onContentChanged(DataGrid dataGrid) {
                    MyGutterComponent.this.updatePreferredSize();
                }
            }, TableResultPanel.this);
            GutterMouseListener mouseListener = new GutterMouseListener();
            this.addMouseMotionListener((MouseMotionListener)((Object)mouseListener));
            this.addMouseListener((MouseListener)((Object)mouseListener));
        }

        public int rowForPoint(Point point) {
            return point != null ? TableResultPanel.this.myTable.rowAtPoint(point) : -1;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintCellsEffects(g);
        }

        @Override
        protected int calcPreferredWidthWithoutInsets() {
            if (TableResultPanel.this.isTransposed() || TableResultPanel.this.isEmpty()) {
                return super.calcPreferredWidthWithoutInsets();
            }
            int lastRowIdx = TableResultPanel.this.myTable.getModel().getRowCount() - 1;
            return ((RowNumberRowHeaderCellComponent)((Object)this.myCellRenderer.getRendererComponent(lastRowIdx))).getPreferredWidth();
        }

        private void paintCellsEffects(final Graphics g) {
            CellRenderingUtils.processVisibleRows((JTable)((Object)TableResultPanel.this.myTable), g, new CellRenderingUtils.RowProcessor(){

                @Override
                public boolean process(int row, int y) {
                    MyGutterComponent.this.paintCellEffects(g, row, new Rectangle(0, y, MyGutterComponent.this.getWidth(), TableResultPanel.this.myTable.getRowHeight(row)));
                    return true;
                }
            });
        }

        private void paintCellEffects(Graphics g, int row, Rectangle cellRect) {
            CellAttributes attributes = TableResultPanel.this.isTransposed() ? TableResultPanel.this.getMarkupModel().getColumnHeaderAttributes(ViewIndex.forColumn(TableResultPanel.this, row).toModel(TableResultPanel.this), TableResultPanel.this.getColorsScheme()) : TableResultPanel.this.getMarkupModel().getRowHeaderAttributes(ViewIndex.forRow(TableResultPanel.this, row).toModel(TableResultPanel.this), TableResultPanel.this.getColorsScheme());
            if (attributes != null) {
                CellRenderingUtils.paintCellEffect(g, cellRect, attributes, DbUIUtil.softHighlightOf((Color)attributes.getEffectColor()));
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point point = event.getPoint();
            int viewRowIdx = this.rowForPoint(point);
            if (viewRowIdx < 0 || !TableResultPanel.this.isTransposed()) {
                return null;
            }
            DataConsumer.Column column = TableResultPanel.this.getColumn(TableResultPanel.this.myTable.convertRowIndexToModel(viewRowIdx));
            return column != null ? TableResultPanel.this.getColumnTooltipHtml(column) : "";
        }

        private class GutterMouseListener
        extends PopupHandler {
            private boolean mySelectWhileDraggingInExclusiveMode;
            private int myResizingRow = -1;

            private GutterMouseListener() {
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() % 2 == 0) {
                    this.packRow(e);
                    this.toggleColumnSorting(e);
                }
                super.mouseClicked(e);
            }

            public void invokePopup(Component comp, int x, int y) {
                if (MyGutterComponent.this.rowForPoint(new Point(x, y)) < 0) {
                    return;
                }
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myGutterPopupActionGroup);
                menu.getComponent().show(comp, x, y);
            }

            public void mouseMoved(MouseEvent e) {
                MyGutterComponent.this.setCursor(this.getRowToResize(e) == -1 ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(9));
            }

            public void mousePressed(MouseEvent e) {
                int rowToResize = this.getRowToResize(e);
                if (rowToResize != -1) {
                    this.myResizingRow = rowToResize;
                } else {
                    this.processSelectionEvent(e, false);
                }
                super.mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.myResizingRow = -1;
                super.mouseReleased(e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyGutterComponent$GutterMouseListener", "mouseDragged"));
                }
                if (this.myResizingRow != -1) {
                    int newRowHeight;
                    Rectangle cellRect = TableResultPanel.this.myTable.getCellRect(this.myResizingRow, 0, true);
                    int oldRowHeight = TableResultPanel.this.myTable.getRowHeight(this.myResizingRow);
                    if (oldRowHeight != (newRowHeight = Math.max(TableResultPanel.this.myTable.getRowHeight(), e.getY() - cellRect.y))) {
                        TableResultPanel.this.myTable.setRowHeight(this.myResizingRow, newRowHeight);
                    }
                } else {
                    this.processSelectionEvent(e, true);
                }
            }

            private int getRowToResize(MouseEvent e) {
                int rowAtPoint = MyGutterComponent.this.rowForPoint(e.getPoint());
                if (rowAtPoint == -1) {
                    return -1;
                }
                Rectangle cellRect = TableResultPanel.this.myTable.getCellRect(rowAtPoint, 0, true);
                int yInCellRect = e.getY() - cellRect.y;
                return yInCellRect < 4 ? (rowAtPoint == 0 ? -1 : rowAtPoint - 1) : (yInCellRect > cellRect.height - 4 ? rowAtPoint : -1);
            }

            private void processSelectionEvent(MouseEvent e, boolean isDragEvent) {
                int currentRow = MyGutterComponent.this.rowForPoint(e.getPoint());
                if (currentRow == -1) {
                    e.consume();
                    return;
                }
                boolean interval = TableResultPanel.isIntervalModifierSet(e);
                boolean exclusive = TableResultPanel.isExclusiveModifierSet(e);
                if (interval) {
                    int lead = TableResultPanel.this.myTable.getSelectionModel().getLeadSelectionIndex();
                    if (exclusive) {
                        GridSelection.addRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), currentRow, lead);
                        GridSelection.addColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getColumnCount() - 1, 0);
                    } else {
                        GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), currentRow, lead);
                        GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getColumnCount() - 1, 0);
                    }
                } else if (exclusive) {
                    if (!isDragEvent) {
                        boolean bl = this.mySelectWhileDraggingInExclusiveMode = !TableResultPanel.this.myTable.isRowSelected(currentRow) || TableResultPanel.this.myTable.getSelectedColumnCount() != TableResultPanel.this.myTable.getColumnCount();
                    }
                    if (this.mySelectWhileDraggingInExclusiveMode) {
                        GridSelection.addRowSelection((JTable)((Object)TableResultPanel.this.myTable), currentRow);
                        GridSelection.addColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getColumnCount() - 1, 0);
                    } else {
                        TableResultPanel.this.myTable.removeRowSelectionInterval(currentRow, currentRow);
                    }
                } else {
                    int lead = isDragEvent ? TableResultPanel.this.myTable.getSelectionModel().getLeadSelectionIndex() : currentRow;
                    GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), currentRow, lead);
                    GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getColumnCount() - 1, 0);
                }
                e.consume();
            }

            private void toggleColumnSorting(MouseEvent e) {
                if (!e.isConsumed() && TableResultPanel.this.isTransposed() && TableResultPanel.this.isSortViaOrderBy()) {
                    TableResultPanel.this.changeSortOrder(ViewIndex.forColumn(TableResultPanel.this, MyGutterComponent.this.rowForPoint(e.getPoint())).toModel(TableResultPanel.this), null, false);
                    e.consume();
                }
            }

            private void packRow(MouseEvent e) {
                int rowToResize = this.getRowToResize(e);
                if (e.isConsumed() || rowToResize == -1) {
                    return;
                }
                int expandedHeight = this.getExpandedRowHeight(rowToResize);
                int newHeight = TableResultPanel.this.myTable.getRowHeight(rowToResize) >= expandedHeight ? TableResultPanel.this.myTable.getRowHeight() : expandedHeight;
                TableResultPanel.this.myTable.setRowHeight(rowToResize, newHeight);
            }

            private int getExpandedRowHeight(int row) {
                int expandedHeight = TableResultPanel.this.myTable.getRowHeight();
                for (int column = 0; column < TableResultPanel.this.myTable.getColumnCount(); ++column) {
                    TableCellRenderer renderer = TableResultPanel.this.myTable.getCellRenderer(row, column);
                    if (renderer == null) continue;
                    Component c = TableResultPanel.this.myTable.prepareRenderer(renderer, row, column);
                    expandedHeight = Math.max(expandedHeight, c.getPreferredSize().height);
                }
                return expandedHeight;
            }
        }
    }

    private class MyCornerToolsComponent
    extends EditorHeaderComponent
    implements ActionListener {
        private final InplaceButton myButton;

        MyCornerToolsComponent() {
            this.setLayout(new BorderLayout());
            this.myButton = new InplaceButton(new IconButton("Select All", null), (ActionListener)this);
            this.add((Component)this.myButton, "Center");
            this.setBorder((Border)new CustomLineBorder(null, 0, 0, 1, 1){

                protected Color getColor() {
                    return TableResultPanel.this.myTable.getGridColor();
                }
            });
        }

        public Color getBackground() {
            return DbUIUtil.softHighlightOf((Color)TableResultPanel.this.myTable.getBackground());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel rowModel = TableResultPanel.this.myTable.getSelectionModel();
            int r0 = rowModel.getMinSelectionIndex();
            int r1 = rowModel.getMaxSelectionIndex();
            ListSelectionModel columnModel = TableResultPanel.this.myTable.getColumnModel().getSelectionModel();
            int c0 = columnModel.getMinSelectionIndex();
            int c1 = columnModel.getMaxSelectionIndex();
            if (r1 - r0 + 1 == TableResultPanel.this.myTable.getRowCount() && c1 - c0 + 1 == TableResultPanel.this.myTable.getColumnCount()) {
                TableResultPanel.this.myTable.clearSelection();
            } else {
                GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getRowCount());
                GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getColumnCount());
            }
        }
    }

    private class MySearchRowFilter
    extends RowFilter<TableModel, Integer> {
        private MySearchRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (TableResultPanel.this.mySearchSession == null || !TableResultPanel.this.mySearchSession.isFilteringEnabled() || StringUtil.isEmpty((String)TableResultPanel.this.mySearchSession.getFindModel().getStringToFind())) {
                return true;
            }
            final ModelIndex<DataConsumer.Row> row = ModelIndex.forRow(TableResultPanel.this, (int)entry.getIdentifier());
            return !TableResultPanel.this.getVisibleColumns().asIterable().filter((Condition)new Condition<ModelIndex<DataConsumer.Column>>(){

                public boolean value(ModelIndex<DataConsumer.Column> column) {
                    return TableResultPanel.this.mySearchSession.isMatchedCell(row, column);
                }
            }).isEmpty();
        }
    }

    private class MyTransposedViewColumnFilter
    extends RowFilter<TableModel, Integer> {
        private MyTransposedViewColumnFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(TableResultPanel.this, (int)entry.getIdentifier());
            return column.isValid(TableResultPanel.this) && TableResultPanel.this.myColumnAttributes.isEnabled(TableResultPanel.this.getDataModel().getColumn(column));
        }
    }

    protected class MyTableView
    extends JBTableWithResizableCells
    implements EditorColorsListener {
        private final Renderers myRenderers;
        private final TableCellImageCache myCellImageCache;
        private final GridCellEditorFactoryProvider myEditorProvider;
        private double myFontSizeIncrement;
        private double myFontSizeScale;
        private int myColumnsHashCode;
        private PaintingSession myPaintingSession;

        public MyTableView(GridCellEditorFactoryProvider editorProvider) {
            super(new GridTableModel.Regular(TableResultPanel.this), new MyTableColumnModel());
            this.myRenderers = new Renderers();
            this.myCellImageCache = new TableCellImageCache((JTable)((Object)this));
            this.myFontSizeIncrement = 0.0;
            this.myFontSizeScale = 1.0;
            this.myEditorProvider = editorProvider;
            new ResizableCellEditorsSupport(this);
            this.setupFocusListener();
            EditorColorsManager.getInstance().addEditorColorsListener((EditorColorsListener)this, (Disposable)TableResultPanel.this);
            this.setupMagnificator();
            this.setEnableAntialiasing(true);
            HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)((Object)this));
            this.setFont(TableResultPanel.this.getColorsScheme().getFont(EditorFontType.PLAIN));
            this.updateFonts();
            this.adjustDefaultActions();
        }

        public void startPaintingSession() {
            this.myPaintingSession = new PaintingSession();
        }

        public void endPaintingSession() {
            this.myPaintingSession = null;
        }

        public void dropCaches() {
            this.myCellImageCache.reset();
        }

        public void addNotify() {
            super.addNotify();
            int hash = this.computeColumnsHashCode();
            TableResultPanel.this.resizeTable(this.myColumnsHashCode != hash);
            this.myColumnsHashCode = hash;
        }

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "paintComponent"));
            }
            super.paintComponent(g);
            this.paintCellsEffects(g);
        }

        private void paintCellsEffects(Graphics g) {
            Rectangle visibleArea = g.getClipBounds();
            Point at = new Point((int)visibleArea.getMinX(), (int)visibleArea.getMinY());
            int fromRow = this.rowAtPoint(at);
            int fromColumn = this.columnAtPoint(at);
            at.setLocation(visibleArea.getMaxX(), visibleArea.getMaxY());
            int toRow = this.rowAtPoint(at);
            int toColumn = this.columnAtPoint(at);
            if (fromColumn == -1) {
                fromColumn = 0;
            }
            if (toRow == -1) {
                toRow = 0;
            }
            if (toColumn == -1) {
                toColumn = this.getColumnCount() - 1;
            }
            if (fromRow == -1) {
                toRow = this.getRowCount() - 1;
            }
            for (int row = fromRow; row <= toRow; ++row) {
                for (int column = fromColumn; column <= toColumn; ++column) {
                    this.paintCellEffects(g, row, column);
                }
            }
        }

        private void paintCellEffects(Graphics g, int row, int column) {
            CellAttributes attributes = TableResultPanel.this.getMarkupModel().getCellAttributes(ViewIndex.forRow(TableResultPanel.this, TableResultPanel.this.isTransposed() ? column : row).toModel(TableResultPanel.this), ViewIndex.forColumn(TableResultPanel.this, TableResultPanel.this.isTransposed() ? row : column).toModel(TableResultPanel.this), TableResultPanel.this.getColorsScheme());
            if (attributes != null) {
                CellRenderingUtils.paintCellEffect(g, this.getCellRect(row, column, true), attributes);
            }
        }

        private int computeColumnsHashCode() {
            int hash = 0;
            MyTableColumnModel columnModel = this.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                hash = System.identityHashCode(columnModel.getColumn(i)) + 31 * hash;
            }
            return hash;
        }

        private void setupFocusListener() {
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent e) {
                    Component component;
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyTableView$1", "focusGained"));
                    }
                    if (MyTableView.this.isEditing() && (component = MyTableView.this.getEditorComponent()) != null) {
                        component.requestFocus();
                    }
                }
            });
        }

        private void setupMagnificator() {
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

                public Point magnify(double scale, Point at) {
                    Rectangle r1;
                    int column = MyTableView.this.columnAtPoint(at);
                    int row = MyTableView.this.rowAtPoint(at);
                    Rectangle rectangle = r1 = column < 0 || row < 0 ? MyTableView.this.getBounds() : MyTableView.this.getCellRect(row, column, true);
                    if (r1.width == 0 || r1.height == 0) {
                        return at;
                    }
                    double xPerc = (double)(at.x - r1.x) / (double)r1.width;
                    double yPerc = (double)(at.y - r1.y) / (double)r1.height;
                    MyTableView.this.changeFontSize(0, scale);
                    Rectangle r2 = column < 0 || row < 0 ? MyTableView.this.getBounds() : MyTableView.this.getCellRect(row, column, true);
                    return new Point((int)((double)r2.x + (double)r2.width * xPerc), (int)((double)r2.y + (double)r2.height * yPerc));
                }
            });
        }

        private void adjustDefaultActions() {
            AbstractAction disabledAction = new AbstractAction(){

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            ActionMap actionMap = this.getActionMap();
            actionMap.put("selectPreviousRowCell", disabledAction);
            actionMap.put("startEditing", disabledAction);
        }

        public void columnMarginChanged(ChangeEvent e) {
            TableColumn resizingColumn;
            JTableHeader tableHeader = this.getTableHeader();
            TableColumn tableColumn = resizingColumn = tableHeader != null ? tableHeader.getResizingColumn() : null;
            if (resizingColumn != null && this.autoResizeMode == 0) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
            }
            this.resizeAndRepaint();
        }

        public String getToolTipText(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "getToolTipText"));
            }
            return "";
        }

        public void setRowHeight(int row, int rowHeight) {
            JViewport rowHeader;
            Container grandParent;
            if (row < 0 || row >= this.getRowCount()) {
                return;
            }
            super.setRowHeight(row, rowHeight);
            Container parent = this.getParent();
            if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane && (rowHeader = ((JScrollPane)grandParent).getRowHeader()) != null) {
                rowHeader.revalidate();
                rowHeader.repaint();
            }
        }

        @NotNull
        protected JTableHeader createDefaultTableHeader() {
            MyTableHeader myTableHeader = new MyTableHeader();
            if (myTableHeader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "createDefaultTableHeader"));
            }
            return myTableHeader;
        }

        public void setModel(@NotNull TableModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "setModel"));
            }
            super.setModel(model);
            final TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
            rowSorter.setMaxSortKeys(1);
            rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
            DbUIUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MyTableView.this.getRowSorter() == rowSorter) {
                        MyTableView.this.updateRowFilter();
                    }
                }
            });
            this.setRowSorter(rowSorter);
        }

        private void updateRowFilter() {
            DefaultRowSorter sorter = (DefaultRowSorter)this.getRowSorter();
            sorter.setRowFilter(TableResultPanel.this.createFilter());
        }

        public MyTableColumnModel getColumnModel() {
            return (MyTableColumnModel)super.getColumnModel();
        }

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "prepareRenderer"));
            }
            JComponent component = (JComponent)super.prepareRenderer(renderer, row, column);
            boolean selected = this.isRowSelected(row) && this.isColumnSelected(column);
            Color background = this.getCellBackground(row, column, selected);
            Color foreground = this.getCellForeground(selected);
            JComponent unwrapped = component;
            if (component instanceof ExpandedItemRendererComponentWrapper && component.getComponentCount() == 1) {
                unwrapped = (JComponent)ObjectUtils.chooseNotNull((Object)ObjectUtils.tryCast((Object)component.getComponent(0), JComponent.class), (Object)component);
            }
            unwrapped.setBackground(background);
            unwrapped.setForeground(foreground);
            unwrapped.setOpaque(!Comparing.equal((Object)unwrapped.getBackground(), (Object)this.getBackground()));
            this.updateCellBorder(unwrapped, background);
            JComponent jComponent = component;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "prepareRenderer"));
            }
            return jComponent;
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            return this.updateCellBorder(super.prepareEditor(editor, row, column), this.getCellBackground(row, column, false));
        }

        private Component updateCellBorder(Component c, Color background) {
            if (c instanceof JComponent) {
                ((JComponent)c).setBorder((Border)new CustomLineBorder(background, 0, 3, 0, 3));
            }
            return c;
        }

        private Color getCellBackground(int row, int column, boolean selected) {
            if (selected) {
                return this.getSelectionBackground();
            }
            Color background = null;
            TableResultPanel grid = TableResultPanel.this;
            ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, this.isTransposedMode() ? column : row).toModel(grid);
            ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, this.isTransposedMode() ? row : column).toModel(grid);
            CellAttributes attributes = grid.getMarkupModel().getCellAttributes(rowIdx, columnIdx, grid.getColorsScheme());
            if (attributes != null) {
                background = attributes.getBackgroundColor();
            }
            if (this.getSelectedRowCount() > 0 && this.getSelectedRows()[this.getSelectedRowCount() - 1] == row) {
                background = background == null ? TableResultPanel.this.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW) : DbUIUtil.softHighlightOf((Color)background);
            }
            if (background == null) {
                background = this.getBackground();
            }
            if (TableResultPanel.this.mySearchSession != null && TableResultPanel.this.mySearchSession.isMatchedCell(rowIdx, columnIdx)) {
                TextAttributes searchMatchAttributes = TableResultPanel.this.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
                Color searchMatchBackground = searchMatchAttributes.getBackgroundColor();
                return searchMatchBackground != null ? searchMatchBackground : DbUIUtil.softHighlightOf((Color)background);
            }
            return background;
        }

        private Color getCellForeground(boolean selected) {
            if (selected) {
                return this.getSelectionForeground();
            }
            return this.getForeground();
        }

        public boolean isCellEditable(int row, int column) {
            return TableResultPanel.this.isCellEditingAllowed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean editCellAt(int row, int column, EventObject e) {
            this.putClientProperty(TableResultPanel.EDITING_STARTER_CLIENT_PROPERTY_KEY, e);
            try {
                boolean bl = super.editCellAt(row, column, e);
                return bl;
            }
            finally {
                this.putClientProperty(TableResultPanel.EDITING_STARTER_CLIENT_PROPERTY_KEY, null);
            }
        }

        public void createDefaultColumnsFromModel() {
            GridTableModel model = this.getModel();
            if (model == null) {
                return;
            }
            TableResultPanel.this.myTable.getTableHeader().setDraggedColumn(null);
            this.getColumnModel().removeAllColumns();
            IntArrayList newColumnIndices = new IntArrayList();
            for (int columnDataIdx = 0; columnDataIdx < model.getColumnCount(); ++columnDataIdx) {
                boolean notShownEarlier = !TableResultPanel.this.myColumnCache.hasCachedColumn(columnDataIdx);
                TableResultPanel.this.myColumnCache.getOrCreateColumn(columnDataIdx);
                boolean enabled = this.isTransposedMode() || TableResultPanel.this.myColumnAttributes.isEnabled(TableResultPanel.this.getColumn(columnDataIdx));
                TableResultPanel.this.setColumnEnabled(columnDataIdx, enabled);
                if (!notShownEarlier || !enabled) continue;
                newColumnIndices.add(columnDataIdx);
            }
            if (!newColumnIndices.isEmpty()) {
                ModelIndexSet<Object> dataIndices = this.isTransposedMode() ? ModelIndexSet.forRows(TableResultPanel.this, newColumnIndices.toArray()) : ModelIndexSet.forColumns(TableResultPanel.this, newColumnIndices.toArray());
                TableResultPanel.this.myColumnLayout.columnsShown(dataIndices);
            }
        }

        public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
            if (visibleRect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRect", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "getScrollableUnitIncrement"));
            }
            if (orientation == 1) {
                return TableResultPanel.this.getColorsScheme().getEditorFontSize();
            }
            return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        public Font getFont() {
            return this.myPaintingSession != null ? this.myPaintingSession.getFont() : this.doGetFont();
        }

        public void globalSchemeChange(EditorColorsScheme scheme) {
            this.updateFonts();
        }

        private void changeFontSize(int increment, double scale) {
            int oldFontSize;
            double newIncrement = this.myFontSizeIncrement * scale + (double)increment;
            double newScale = this.myFontSizeScale * scale;
            int newFontSize = this.fontSize(newIncrement, newScale);
            if (newFontSize == (oldFontSize = this.getFont().getSize())) {
                return;
            }
            this.myFontSizeIncrement = newIncrement;
            this.myFontSizeScale = newScale;
            this.updateFonts();
        }

        private void updateFonts() {
            this.setFont(this.getFont());
            this.setRowHeight(this.getRowHeight());
            JTableHeader tableHeader = this.getTableHeader();
            if (tableHeader != null) {
                tableHeader.setFont(tableHeader.getFont().deriveFont((float)this.fontSize(this.myFontSizeIncrement, this.myFontSizeScale)));
            }
            TableResultPanel.this.resizeTable(true);
        }

        private int fontSize(double fontSizeIncrement, double fontSizeScale) {
            int baseFontSize = TableResultPanel.this.getColorsScheme().getEditorFontSize();
            int newFontSize = (int)Math.max(fontSizeScale * (double)baseFontSize + fontSizeIncrement, 8.0);
            return Math.min(Math.max(40, baseFontSize), newFontSize);
        }

        public int getRowHeight() {
            return this.myPaintingSession != null ? this.myPaintingSession.getRowHeight() : this.doGetRowHeight();
        }

        private int getTextLineHeight() {
            return (int)((float)this.getFontMetrics(this.getFont()).getHeight() * TableResultPanel.this.getColorsScheme().getLineSpacing());
        }

        public Color getSelectionForeground() {
            return this.myPaintingSession != null ? this.myPaintingSession.getSelectionForeground() : this.doGetSelectionForeground();
        }

        public Color getSelectionBackground() {
            return this.myPaintingSession != null ? this.myPaintingSession.getSelectionBackground() : this.doGetSelectionBackground();
        }

        public Color getForeground() {
            return this.myPaintingSession != null ? this.myPaintingSession.getForeground() : this.doGetForeground();
        }

        public Color getBackground() {
            return this.myPaintingSession != null ? this.myPaintingSession.getBackground() : this.doGetBackground();
        }

        public void setBackground(@NotNull Color bg) {
            if (bg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bg", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "setBackground"));
            }
        }

        public Color getGridColor() {
            return this.myPaintingSession != null ? this.myPaintingSession.getGridColor() : this.doGetGridColor();
        }

        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            ((DataGridListener)TableResultPanel.this.myEventDispatcher.getMulticaster()).onContentChanged(TableResultPanel.this);
        }

        public GridTableModel getModel() {
            return (GridTableModel)super.getModel();
        }

        boolean isTransposedMode() {
            return this.getModel() instanceof GridTableModel.Transposed;
        }

        private void onHeaderClicked(int columnDataIdx, MouseEvent e) {
            if (this.isTransposedMode() && !TableResultPanel.this.allowHeaderActionsInTransposeMode()) {
                return;
            }
            if (e.getID() == 500 && e.getButton() == 2 && e.getClickCount() == 1) {
                if (columnDataIdx >= 0) {
                    TableResultPanel.this.setColumnEnabled(columnDataIdx, false);
                }
            } else if (e.isPopupTrigger() && TableResultPanel.this.myColumnHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
                TableResultPanel.this.myClickedHeaderColumnIdx = ModelIndex.forColumn(TableResultPanel.this, columnDataIdx);
                if (TableResultPanel.this.isHeaderSelecting()) {
                    boolean interval = TableResultPanel.isIntervalModifierSet(e);
                    boolean exclusive = TableResultPanel.isExclusiveModifierSet(e);
                    if (interval) {
                        int lead = TableResultPanel.this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                        if (exclusive) {
                            GridSelection.addRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getRowCount() - 1, 0);
                            GridSelection.addColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), columnDataIdx, lead);
                        } else {
                            GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getRowCount() - 1, 0);
                            GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), columnDataIdx, lead);
                        }
                    } else if (exclusive) {
                        TableResultPanel.this.myTable.removeColumnSelectionInterval(columnDataIdx, columnDataIdx);
                    } else {
                        GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), TableResultPanel.this.myTable.getRowCount() - 1, 0);
                        GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), columnDataIdx, columnDataIdx);
                    }
                }
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", TableResultPanel.this.myColumnHeaderPopupActions);
                popupMenu.getComponent().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        DbUIUtil.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TableResultPanel.this.myClickedHeaderColumnIdx = ModelIndex.forColumn(TableResultPanel.this, -1);
                            }
                        });
                    }
                });
                popupMenu.getComponent().show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
            final GridTableModel m = this.getModel();
            return new TableRowSorter<TableModel>((TableModel)m){
                {
                    super(x0);
                    this.setModelWrapper(new DefaultRowSorter.ModelWrapper<TableModel, Integer>(){

                        @Override
                        public TableModel getModel() {
                            return m;
                        }

                        @Override
                        public int getColumnCount() {
                            return m.getColumnCount();
                        }

                        @Override
                        public int getRowCount() {
                            return m.getRowCount();
                        }

                        @Override
                        public Object getValueAt(int row, int column) {
                            return TableResultPanel.this.getRow(row);
                        }

                        @Override
                        public Integer getIdentifier(int row) {
                            return row;
                        }
                    });
                }

                @Override
                public void toggleSortOrder(int columnDataIdx) {
                    if (!TableResultPanel.this.isTransposed()) {
                        TableResultPanel.this.changeSortOrder(ModelIndex.forColumn(TableResultPanel.this, columnDataIdx), null, false);
                    }
                }

                @Override
                public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
                    super.setSortKeys(sortKeys);
                    ((DataGridListener)TableResultPanel.this.myEventDispatcher.getMulticaster()).onContentChanged(TableResultPanel.this);
                }

                @Override
                protected boolean useToString(int column) {
                    return false;
                }

                @Override
                public Comparator<?> getComparator(int modelColumnIdx) {
                    Comparator<Object> comparator = null;
                    if (!TableResultPanel.this.isTransposed()) {
                        DataConsumer.Column column = TableResultPanel.this.getColumn(modelColumnIdx);
                        comparator = TableResultPanel.this.myColumnAttributes.getComparator(column);
                    }
                    return comparator != null ? comparator : super.getComparator(modelColumnIdx);
                }

                @Override
                public boolean isSortable(int columnDataIdx) {
                    DataConsumer.Column column = !MyTableView.this.isTransposedMode() ? TableResultPanel.this.getColumn(columnDataIdx) : null;
                    return column != null && TableResultPanel.this.myColumnAttributes.getComparator(column) != null;
                }
            };
        }

        public TableCellEditor getCellEditor(int row, int column) {
            TableResultPanel grid = TableResultPanel.this;
            ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, this.isTransposedMode() ? column : row).toModel(grid);
            ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, this.isTransposedMode() ? row : column).toModel(grid);
            GridCellEditorFactory editorFactory = this.myEditorProvider.getEditorFactory(grid, rowIdx, columnIdx);
            return !DbImplUtil.isComputedColumn(TableResultPanel.this.getDataModel().getColumn(columnIdx)) && editorFactory != null ? new GridTableCellEditor(grid, rowIdx, columnIdx, editorFactory) : null;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = this.myRenderers.getRenderer(row, column);
            renderer = renderer == null ? super.getCellRenderer(row, column) : renderer;
            return renderer == null ? null : this.myCellImageCache.wrapCellRenderer(renderer, new TableCellImageCache.CellStateGetter(){

                @Override
                public Object getState(JTable table, Component rComponent, int row, int column) {
                    Color bg = this.hashSafeColor(rComponent.getBackground());
                    Color fg = this.hashSafeColor(rComponent.getForeground());
                    Boolean opaque = rComponent.isOpaque() ? Boolean.TRUE : Boolean.FALSE;
                    return Trinity.create((Object)bg, (Object)fg, (Object)opaque);
                }

                @Nullable
                private Color hashSafeColor(@Nullable Color color) {
                    Class<?> colorClass;
                    Class<?> clazz = colorClass = color != null ? color.getClass() : null;
                    if (colorClass == null || colorClass == Color.class || colorClass == ColorUIResource.class) {
                        return color;
                    }
                    return new Color(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha());
                }
            });
        }

        public void setValueAt(Object value, int viewRowIdx, int viewColumnIdx) {
            ViewIndex<DataConsumer.Row> rowIndex = ViewIndex.forRow(TableResultPanel.this, this.isTransposedMode() ? viewColumnIdx : viewRowIdx);
            ViewIndex<DataConsumer.Column> colIndex = ViewIndex.forColumn(TableResultPanel.this, this.isTransposedMode() ? viewRowIdx : viewColumnIdx);
            this.setValueAt(rowIndex, colIndex, value, true);
        }

        void setValueAt(ViewIndex<DataConsumer.Row> viewRowIdx, ViewIndex<DataConsumer.Column> viewColIdx, final Object value, boolean moveToNextCell) {
            Runnable moveToNextCellRunnable;
            TableResultPanel.this.hideErrorPanel();
            final GridMutator mutator = TableResultPanel.this.myDataHookUp.getMutator();
            ModelIndex<DataConsumer.Row> row = viewRowIdx.toModel(TableResultPanel.this);
            ModelIndex<DataConsumer.Column> column = viewColIdx.toModel(TableResultPanel.this);
            final ModelIndexSet<DataConsumer.Row> rows = row.isValid(TableResultPanel.this) ? ModelIndexSet.forRows(TableResultPanel.this, row.asInteger()) : null;
            final ModelIndexSet<DataConsumer.Column> columns = column.isValid(TableResultPanel.this) ? ModelIndexSet.forColumns(TableResultPanel.this, column.asInteger()) : null;
            Runnable runnable = moveToNextCellRunnable = moveToNextCell ? this.newMoveToNextCellRunnable(viewRowIdx, viewColIdx) : EmptyRunnable.INSTANCE;
            if (mutator == null || rows == null || columns == null || TableResultPanel.this.getDataModel().allValuesEqualTo(rows, columns, value)) {
                DbUIUtil.invokeLater((Runnable)moveToNextCellRunnable);
                return;
            }
            MyRequestSource requestSource = new MyRequestSource(TableResultPanel.this, row, column);
            requestSource.doWhenDone(moveToNextCellRunnable);
            final GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = GridRequestSource.create(TableResultPanel.this, (Object)requestSource);
            DbUIUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    mutator.update(source, rows, columns, value);
                }
            });
        }

        private Runnable newMoveToNextCellRunnable(final ViewIndex<DataConsumer.Row> row, final ViewIndex<DataConsumer.Column> col) {
            return new Runnable(){

                @Override
                public void run() {
                    IdeFocusManager.findInstanceByComponent((Component)((Object)MyTableView.this)).doWhenFocusSettlesDown(new Runnable(){

                        @Override
                        public void run() {
                            MyTableView.this.moveToNextCell(row, col);
                        }
                    });
                }
            };
        }

        private void moveToNextCell(@NotNull ViewIndex<DataConsumer.Row> rowIndex, @NotNull ViewIndex<DataConsumer.Column> colIndex) {
            if (rowIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndex", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "moveToNextCell"));
            }
            if (colIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colIndex", "com/intellij/database/run/ui/TableResultPanel$MyTableView", "moveToNextCell"));
            }
            if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((JComponent)((Object)this)) || this.isEditing())) {
                return;
            }
            if (!Comparing.equal(TableResultPanel.this.getSelectedRow(), rowIndex.toModel(TableResultPanel.this)) || !Comparing.equal(TableResultPanel.this.getSelectedColumn(), colIndex.toModel(TableResultPanel.this))) {
                return;
            }
            if (TableResultPanel.this.isInsertedRow(rowIndex.toModel(TableResultPanel.this))) {
                ViewIndex<DataConsumer.Column> nextColumn = ViewIndex.forColumn(TableResultPanel.this, colIndex.asInteger() + 1);
                colIndex = nextColumn.isValid(TableResultPanel.this) ? nextColumn : colIndex;
            } else {
                ViewIndex<DataConsumer.Row> nextRow = ViewIndex.forRow(TableResultPanel.this, rowIndex.asInteger() + 1);
                rowIndex = nextRow.isValid(TableResultPanel.this) ? nextRow : rowIndex;
            }
            TableResultPanel.this.scrollToLocally(rowIndex, colIndex);
        }

        private Font doGetFont() {
            return TableResultPanel.this.getColorsScheme().getFont(EditorFontType.PLAIN).deriveFont((float)this.fontSize(this.myFontSizeIncrement, this.myFontSizeScale));
        }

        private int doGetRowHeight() {
            return this.getTextLineHeight() + this.getRowMargin();
        }

        private Color doGetGridColor() {
            return (Color)ObjectUtils.chooseNotNull((Object)TableResultPanel.this.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR), (Object)UIUtil.getTableGridColor());
        }

        private Color doGetForeground() {
            return (Color)ObjectUtils.chooseNotNull((Object)TableResultPanel.this.getColorsScheme().getDefaultForeground(), (Object)UIUtil.getTableForeground());
        }

        private Color doGetBackground() {
            return (Color)ObjectUtils.chooseNotNull((Object)TableResultPanel.this.getColorsScheme().getDefaultBackground(), (Object)UIUtil.getTableBackground());
        }

        @Nullable
        private Color doGetSelectionForeground() {
            return (Color)ObjectUtils.chooseNotNull((Object)TableResultPanel.this.getColorsScheme().getColor(DatabaseColors.GRID_SELECTION_FOREGROUND), (Object)UIUtil.getTableSelectionForeground());
        }

        @Nullable
        private Color doGetSelectionBackground() {
            return (Color)ObjectUtils.chooseNotNull((Object)TableResultPanel.this.getColorsScheme().getColor(DatabaseColors.GRID_SELECTION_BACKGROUND), (Object)UIUtil.getTableSelectionBackground());
        }

        private class GridCellRendererWrapper
        implements TableCellRenderer {
            private final GridCellRenderer myWrappee;

            private GridCellRendererWrapper(GridCellRenderer wrappee) {
                this.myWrappee = wrappee;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                assert (table == TableResultPanel.this.myTable);
                TableResultPanel grid = TableResultPanel.this;
                ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, MyTableView.this.isTransposedMode() ? column : row).toModel(grid);
                ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, MyTableView.this.isTransposedMode() ? row : column).toModel(grid);
                return this.myWrappee.getComponent(rowIdx, columnIdx);
            }
        }

        private class Renderers {
            private final GridCellRenderers myGridRenderers;
            private final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers;

            private Renderers() {
                this.myGridRenderers = new GridCellRenderers(TableResultPanel.this);
                this.myTableCellRenderers = new THashMap(ContainerUtil.identityStrategy());
                Disposer.register((Disposable)TableResultPanel.this, (Disposable)this.myGridRenderers);
            }

            public TableCellRenderer getRenderer(int row, int column) {
                ModelIndex<DataConsumer.Column> columnIdx;
                TableResultPanel grid = TableResultPanel.this;
                ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, MyTableView.this.isTransposedMode() ? column : row).toModel(grid);
                GridCellRenderer gridCellRenderer = this.myGridRenderers.getRenderer(rowIdx, columnIdx = ViewIndex.forColumn(grid, MyTableView.this.isTransposedMode() ? row : column).toModel(grid));
                if (gridCellRenderer == null) {
                    return null;
                }
                TableCellRenderer renderer = this.myTableCellRenderers.get(gridCellRenderer);
                if (renderer == null) {
                    renderer = new GridCellRendererWrapper(gridCellRenderer);
                    this.myTableCellRenderers.put(gridCellRenderer, renderer);
                }
                return renderer;
            }
        }

        private class PaintingSession {
            private Font myFont;
            private Color myGridColor;
            private Color myForeground;
            private Color myBackground;
            private Color mySelectionForeground;
            private Color mySelectionBackground;
            private int myRowHeight = -1;

            private PaintingSession() {
            }

            public Font getFont() {
                return this.myFont != null ? this.myFont : (this.myFont = MyTableView.this.doGetFont());
            }

            public int getRowHeight() {
                return this.myRowHeight != -1 ? this.myRowHeight : (this.myRowHeight = MyTableView.this.doGetRowHeight());
            }

            public Color getGridColor() {
                return this.myGridColor != null ? this.myGridColor : (this.myGridColor = MyTableView.this.doGetGridColor());
            }

            public Color getForeground() {
                return this.myForeground != null ? this.myForeground : (this.myForeground = MyTableView.this.doGetForeground());
            }

            public Color getBackground() {
                return this.myBackground != null ? this.myBackground : (this.myBackground = MyTableView.this.doGetBackground());
            }

            public Color getSelectionForeground() {
                return this.mySelectionForeground != null ? this.mySelectionForeground : (this.mySelectionForeground = MyTableView.this.doGetSelectionForeground());
            }

            public Color getSelectionBackground() {
                return this.mySelectionBackground != null ? this.mySelectionBackground : (this.mySelectionBackground = MyTableView.this.doGetSelectionBackground());
            }
        }

        protected class MyTableHeader
        extends JBTable.JBTableHeader {
            private int myLastPositiveHeight;

            protected MyTableHeader() {
                super((JBTable)MyTableView.this);
                this.myLastPositiveHeight = 0;
                this.setOpaque(false);
                this.setFocusable(false);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(@NotNull MouseEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyTableView$MyTableHeader$1", "mouseClicked"));
                        }
                        this.processEvent(e);
                    }

                    @Override
                    public void mousePressed(@NotNull MouseEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyTableView$MyTableHeader$1", "mousePressed"));
                        }
                        this.processEvent(e);
                    }

                    @Override
                    public void mouseReleased(@NotNull MouseEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyTableView$MyTableHeader$1", "mouseReleased"));
                        }
                        this.processEvent(e);
                    }

                    private void processEvent(MouseEvent e) {
                        IntIntFunction conversion = TableResultPanel.this.isTransposed() ? TableResultPanel.this.myRawIndexConverter.row2Model() : TableResultPanel.this.myRawIndexConverter.column2Model();
                        int columnDataIdx = conversion.fun(MyTableHeader.this.columnAtPoint(e.getPoint()));
                        if (columnDataIdx >= 0) {
                            MyTableView.this.onHeaderClicked(columnDataIdx, e);
                        }
                    }
                });
            }

            public boolean getReorderingAllowed() {
                return !MyTableView.this.isTransposedMode();
            }

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d.height <= 0) {
                    d.height = this.myLastPositiveHeight;
                }
                return d;
            }

            public void setSize(int width, int height) {
                super.setSize(width, height);
                if (height > 0) {
                    this.myLastPositiveHeight = height;
                }
            }

            public void paint(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/TableResultPanel$MyTableView$MyTableHeader", "paint"));
                }
                Rectangle clip = g.getClipBounds();
                clip.width = Math.max(0, Math.min(clip.width, this.getTable().getWidth() - clip.x));
                g.setClip(clip);
                super.paint(g);
            }
        }
    }

    private static class MyTableColumnModel
    extends DefaultTableColumnModel {
        private MyTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            if (!(aColumn instanceof MyTableColumn)) {
                throw new IllegalArgumentException("Unexpected column type");
            }
            super.addColumn(aColumn);
        }

        @Override
        public MyTableColumn getColumn(int columnIndex) {
            return (MyTableColumn)super.getColumn(columnIndex);
        }

        public void removeAllColumns() {
            int columnCount = this.tableColumns.size();
            if (columnCount == 0) {
                return;
            }
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(0, columnCount - 1);
            }
            for (TableColumn column : this.tableColumns) {
                column.removePropertyChangeListener(this);
            }
            this.totalColumnWidth = -1;
            for (int i = columnCount - 1; i >= 0; --i) {
                this.tableColumns.remove(i);
                this.fireColumnRemoved(new TableColumnModelEvent(this, i, 0));
            }
        }
    }

    private class MyTableColumnCache
    implements Iterable<MyTableColumn> {
        private final TIntObjectHashMap<Entry> myColumnDataIndicesToEntries = new TIntObjectHashMap();

        private MyTableColumnCache() {
        }

        public boolean hasCachedColumn(int columnDataIdx) {
            boolean isCached = this.hasValidEntry(columnDataIdx);
            if (!isCached) {
                this.myColumnDataIndicesToEntries.remove(columnDataIdx);
                return false;
            }
            return true;
        }

        public MyTableColumn getOrCreateColumn(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (!this.hasCachedColumn(columnDataIdx) || e == null) {
                e = this.createEntry(columnDataIdx);
                this.myColumnDataIndicesToEntries.put(columnDataIdx, (Object)e);
            }
            return e.myTableColumn;
        }

        @NotNull
        private Entry createEntry(int columnDataIdx) {
            MyTableColumn tableColumn = TableResultPanel.this.isTransposed() ? this.createTableColumnForRow(ModelIndex.forRow(TableResultPanel.this, columnDataIdx)) : this.createTableColumnForColumn(ModelIndex.forColumn(TableResultPanel.this, columnDataIdx));
            Object columnData = this.getColumnData(columnDataIdx);
            Entry entry = new Entry(ObjectUtils.assertNotNull((Object)columnData), tableColumn);
            if (entry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache", "createEntry"));
            }
            return entry;
        }

        public void retainColumns(final Collection<? extends DataConsumer.Column> columnsToRetain) {
            this.myColumnDataIndicesToEntries.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<Entry>(){

                public boolean execute(int columnDataIdx, @NotNull Entry e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache$1", "execute"));
                    }
                    return columnsToRetain.contains(e.myColumnData);
                }
            });
        }

        public void remove(int columnDataIdx) {
            this.myColumnDataIndicesToEntries.remove(columnDataIdx);
        }

        @Override
        public Iterator<MyTableColumn> iterator() {
            return new Iterator<MyTableColumn>(){
                private final TIntObjectIterator<Entry> myWrappee;
                private Entry myCurrentEntry;
                {
                    this.myWrappee = MyTableColumnCache.this.myColumnDataIndicesToEntries.iterator();
                }

                @Override
                public boolean hasNext() {
                    this.advance();
                    return this.myCurrentEntry != null;
                }

                @Override
                public MyTableColumn next() {
                    MyTableColumn column = this.myCurrentEntry.myTableColumn;
                    this.myCurrentEntry = null;
                    return column;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void advance() {
                    this.myCurrentEntry = null;
                    while (this.myWrappee.hasNext()) {
                        this.myWrappee.advance();
                        if (MyTableColumnCache.this.hasValidEntry(this.myWrappee.key())) {
                            this.myCurrentEntry = (Entry)this.myWrappee.value();
                            break;
                        }
                        this.myWrappee.remove();
                    }
                }
            };
        }

        private boolean hasValidEntry(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (e == null) {
                return false;
            }
            Object cachedColumnData = e.myColumnData;
            Object currentColumnData = this.getColumnData(columnDataIdx);
            if (Comparing.equal((Object)cachedColumnData, (Object)currentColumnData)) {
                return true;
            }
            if (cachedColumnData instanceof DataConsumer.Row && currentColumnData instanceof DataConsumer.Row) {
                DataConsumer.Row cachedRow = (DataConsumer.Row)cachedColumnData;
                DataConsumer.Row currentRow = (DataConsumer.Row)currentColumnData;
                if (cachedRow.rowNum == currentRow.rowNum && cachedRow.values.length == currentRow.values.length) {
                    int mismatchedValuesCount = 0;
                    for (int i = 0; i < cachedRow.values.length; ++i) {
                        if (Comparing.equal((Object)cachedRow.values[i], (Object)currentRow.values[i])) continue;
                        ++mismatchedValuesCount;
                    }
                    if (mismatchedValuesCount < 2) {
                        return true;
                    }
                }
            }
            return false;
        }

        private Object getColumnData(int columnDataIdx) {
            return TableResultPanel.this.isTransposed() ? TableResultPanel.this.getRow(columnDataIdx) : TableResultPanel.this.getColumn(columnDataIdx);
        }

        @NotNull
        private MyTableColumn createTableColumnForColumn(ModelIndex<DataConsumer.Column> columnIdx) {
            DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)TableResultPanel.this.getDataModel().getColumn(columnIdx));
            MyTableColumn myTableColumn = new MyTableColumn(TableResultPanel.this, column, columnIdx.asInteger());
            if (myTableColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache", "createTableColumnForColumn"));
            }
            return myTableColumn;
        }

        @NotNull
        private MyTableColumn createTableColumnForRow(ModelIndex<DataConsumer.Row> rowIdx) {
            DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.assertNotNull((Object)TableResultPanel.this.getDataModel().getRow(rowIdx));
            MyTableColumn myTableColumn = new MyTableColumn(TableResultPanel.this, row, rowIdx.asInteger());
            if (myTableColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache", "createTableColumnForRow"));
            }
            return myTableColumn;
        }

        private final class Entry {
            @NotNull
            public final Object myColumnData;
            @NotNull
            public final MyTableColumn myTableColumn;

            public Entry(@NotNull Object columnData, MyTableColumn tableColumn) {
                if (columnData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnData", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache$Entry", "<init>"));
                }
                if (tableColumn == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableColumn", "com/intellij/database/run/ui/TableResultPanel$MyTableColumnCache$Entry", "<init>"));
                }
                this.myColumnData = columnData;
                this.myTableColumn = tableColumn;
            }
        }
    }

    private class MyColumnAttributes {
        private final Map<DataConsumer.Column, Attributes> myAttributesMap = ContainerUtil.newHashMap();
        private List<String> myUnambiguousColumnNames;

        private MyColumnAttributes() {
        }

        @NotNull
        public String getName(DataConsumer.Column column) {
            String name = column.columnNum < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column.columnNum) : column.name;
            String string = StringUtil.isNotEmpty((String)name) ? name : "<anonymous>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyColumnAttributes", "getName"));
            }
            return string;
        }

        @NotNull
        public Language getContentLanguage(DataConsumer.Column column) {
            Language language = this.myAttributesMap.get((Object)column).myContentLanguage;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyColumnAttributes", "getContentLanguage"));
            }
            return language;
        }

        public void setContentLanguage(DataConsumer.Column column, @NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/TableResultPanel$MyColumnAttributes", "setContentLanguage"));
            }
            this.myAttributesMap.get((Object)column).myContentLanguage = language;
        }

        public Comparator<DataConsumer.Row> getComparator(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myComparator;
        }

        public boolean isEnabled(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myEnabled;
        }

        public void setEnabled(DataConsumer.Column column, boolean enabled) {
            this.myAttributesMap.get((Object)column).myEnabled = enabled;
        }

        public int getSortOrder(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                this.setEnabled(column, !DbImplUtil.isComputedColumn(column));
            }
        }

        public boolean changeSortOrder(DataConsumer.Column targetColumn, @Nullable RowSortOrder.Type targetSortOrder) {
            if (this.getComparator(targetColumn) == null) {
                return false;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            int maxOrder = 0;
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                if (column == targetColumn) continue;
                int order = this.getSortOrder(column);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : (targetSortOrder == null ? (prevOrder == 0 ? asc : (prevOrder < 0 ? desc : 0)) : 0));
            this.setSortOrder(targetColumn, newOrder);
            return prevOrder != newOrder;
        }

        public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
            TreeMap<Integer, DataConsumer.Column> sortOrderMap = new TreeMap<Integer, DataConsumer.Column>();
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column);
            }
            return sortOrderMap;
        }

        private void updateColumnNames() {
            DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(TableResultPanel.this);
            SqlTableType type = hookup != null ? hookup.getTableType() : null;
            this.myUnambiguousColumnNames = type == null ? ContainerUtil.emptyList() : DbSqlUtil.getUnambiguousColumnNames(TableResultPanel.this.myProject, hookup.getDatabaseDialect(), type);
        }

        public void newColumns(Collection<DataConsumer.Column> columnsToRetain) {
            this.updateColumnNames();
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            for (DataConsumer.Column column : columnsToRetain) {
                if (this.myAttributesMap.containsKey(column)) continue;
                this.myAttributesMap.put(column, this.createAttributes(column));
            }
            this.updateSortOrders();
        }

        private void setSortOrder(DataConsumer.Column column, int sortOrder) {
            this.myAttributesMap.get((Object)column).mySortOrder = sortOrder;
        }

        private void updateSortOrders() {
            int order = 1;
            for (DataConsumer.Column column : this.getSortOrderMap().values()) {
                this.setSortOrder(column, (this.getSortOrder(column) < 0 ? -1 : 1) * order++);
            }
        }

        private Attributes createAttributes(DataConsumer.Column column) {
            Attributes attributes = new Attributes();
            attributes.myComparator = GridRowComparator.create(TableResultPanel.this, column);
            attributes.myEnabled = !TableResultPanel.this.isInitiallyDisabled(column);
            attributes.myContentLanguage = TableResultPanel.this.getInitialContentLanguage(column);
            return attributes;
        }

        private final class Attributes {
            public Language myContentLanguage;
            public Comparator<DataConsumer.Row> myComparator;
            public boolean myEnabled;
            public int mySortOrder;

            private Attributes() {
            }
        }
    }

    protected class MyTableColumn
    extends TableColumn
    implements GridColumn {
        private final DataConsumer.Column myColumn;
        private final DataConsumer.Row myRow;
        private final UserDataHolder myDataHolderDelegate;
        private int myWidthFromLayout;
        final /* synthetic */ TableResultPanel this$0;

        public MyTableColumn(@NotNull TableResultPanel this$0, DataConsumer.Row row, int modelIndex) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel$MyTableColumn", "<init>"));
            }
            this(this$0, row, null, modelIndex);
        }

        public MyTableColumn(@NotNull TableResultPanel this$0, DataConsumer.Column column, int modelIndex) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel$MyTableColumn", "<init>"));
            }
            this(this$0, null, column, modelIndex);
        }

        private MyTableColumn(TableResultPanel this$0, DataConsumer.Row row, DataConsumer.Column column, int modelIndex) {
            this.this$0 = this$0;
            super(modelIndex);
            this.myDataHolderDelegate = new UserDataHolderBase();
            this.myRow = row;
            this.myColumn = column;
        }

        public Icon getIcon() {
            DasColumn databaseColumn = DataGridUtil.getDatabaseColumn(this.this$0, this.myColumn);
            return databaseColumn != null ? DbPresentation.getIcon((DasObject)databaseColumn) : null;
        }

        @NotNull
        public String getHeaderTitle() {
            String string = this.myColumn == null ? String.valueOf(this.myRow.rowNum) : this.this$0.myColumnAttributes.getName(this.myColumn) + this.this$0.getDateFormatSuffix(this.myColumn);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyTableColumn", "getHeaderTitle"));
            }
            return string;
        }

        @Override
        public int getPreferredHeaderWidth() {
            TableCellRenderer renderer = this.this$0.myTable.getTableHeader().getDefaultRenderer();
            assert (renderer instanceof MyCellRenderer);
            Component headerComponent = ((MyCellRenderer)renderer).getHeaderCellRendererComponent(this.getModelIndex());
            return headerComponent.getPreferredSize().width;
        }

        @Nullable
        public String getTooltipText() {
            return this.myColumn != null ? this.this$0.getColumnTooltipHtml(this.myColumn) : null;
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/TableResultPanel$MyTableColumn", "getUserData"));
            }
            return (T)this.myDataHolderDelegate.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/TableResultPanel$MyTableColumn", "putUserData"));
            }
            this.myDataHolderDelegate.putUserData(key, value);
        }

        @Override
        public int getColumnWidth() {
            return this.getPreferredWidth();
        }

        @Override
        public void setColumnWidth(int width) {
            this.myWidthFromLayout = width;
            this.setPreferredWidth(width);
        }

        public boolean isWidthSetByLayout() {
            return this.myWidthFromLayout == this.getPreferredWidth();
        }
    }

    protected class MyTableHeaderCellComponent
    extends EditorHeaderComponent {
        private final JLabel myNameLabel = new MyJBLabel();
        private final JLabel mySortLabel = new MyJBLabel();
        private MyTableColumn myCurrentColumn;

        public MyTableHeaderCellComponent() {
            this.myNameLabel.setHorizontalAlignment(2);
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)3, (int)2, (int)0));
            this.mySortLabel.setVerticalAlignment(0);
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)3));
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
            this.setBorder((Border)new CustomLineBorder(0, 0, 1, 1){

                protected Color getColor() {
                    Color gridColor = TableResultPanel.this.myTable.getGridColor();
                    return gridColor != null ? gridColor : super.getColor();
                }
            });
        }

        protected Rectangle getNameRect() {
            return TableResultPanel.getLabelTextRect(this.myNameLabel);
        }

        protected int getModelIdx() {
            return this.myCurrentColumn.getModelIndex();
        }

        public MyTableHeaderCellComponent prepare(int columnDataIdx) {
            DataConsumer.Column column;
            this.myCurrentColumn = TableResultPanel.this.myColumnCache.getOrCreateColumn(columnDataIdx);
            this.myNameLabel.setIcon(this.myCurrentColumn.getIcon());
            this.myNameLabel.setText(this.myCurrentColumn.getHeaderTitle());
            Icon sortLabelIcon = null;
            String sortLabelText = "";
            if (!TableResultPanel.this.isTransposed() && (column = TableResultPanel.this.getColumn(columnDataIdx)) != null && TableResultPanel.this.myColumnAttributes.getComparator(column) != null) {
                int sortOrder = TableResultPanel.this.getSortOrder(column);
                sortLabelIcon = TableResultPanel.getSortOrderIcon(sortOrder);
                sortLabelText = TableResultPanel.getSortOrderText(sortOrder);
            }
            this.mySortLabel.setIcon(sortLabelIcon);
            this.mySortLabel.setText(sortLabelText);
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            return this.myCurrentColumn != null ? this.myCurrentColumn.getTooltipText() : super.getToolTipText(event);
        }

        public Color getBackground() {
            boolean inserted;
            if (this.myCurrentColumn == null) {
                return super.getBackground();
            }
            int columnDataIdx = this.myCurrentColumn.getModelIndex();
            boolean transposed = TableResultPanel.this.isTransposed();
            boolean selected = TableResultPanel.this.myTable.isColumnSelected(columnDataIdx);
            boolean bl = inserted = transposed && TableResultPanel.this.isInsertedRow(ModelIndex.forRow(TableResultPanel.this, columnDataIdx));
            if (!inserted) {
                CellAttributes attributes;
                if (transposed) {
                    ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(TableResultPanel.this, columnDataIdx);
                    attributes = TableResultPanel.this.myMarkupModel.getRowHeaderAttributes(rowIdx, TableResultPanel.this.getColorsScheme());
                } else {
                    ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(TableResultPanel.this, columnDataIdx);
                    attributes = TableResultPanel.this.myMarkupModel.getColumnHeaderAttributes(columnIdx, TableResultPanel.this.getColorsScheme());
                }
                if (attributes != null && attributes.getBackgroundColor() != null) {
                    Color bg = attributes.getBackgroundColor();
                    return selected ? bg : DbUIUtil.softHighlightOf((Color)bg);
                }
            }
            return TableResultPanel.this.getHeaderCellBackground(selected, inserted, TableResultPanel.this.myTable.getBackground());
        }

        private class MyJBLabel
        extends JBLabel {
            private MyJBLabel() {
            }

            public Color getBackground() {
                return TableResultPanel.this.myTable.getBackground();
            }

            public Color getForeground() {
                return TableResultPanel.this.myTable.getForeground();
            }

            public Font getFont() {
                return TableResultPanel.this.myTable.getTableHeader().getFont();
            }
        }
    }

    protected class MyCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myOriginalRenderer;
        protected final MyTableHeaderCellComponent myHeaderCellComponent;

        public MyCellRenderer() {
            this(this$0.new MyTableHeaderCellComponent());
        }

        public MyCellRenderer(MyTableHeaderCellComponent headerCellComponent) {
            this.myOriginalRenderer = TableResultPanel.this.myTable.getTableHeader().getDefaultRenderer();
            this.myHeaderCellComponent = headerCellComponent;
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/TableResultPanel$MyCellRenderer", "getTableCellRendererComponent"));
            }
            Component component = row == -1 ? this.getHeaderCellRendererComponent(TableResultPanel.this.myTable.convertColumnIndexToModel(column)) : this.myOriginalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$MyCellRenderer", "getTableCellRendererComponent"));
            }
            return component;
        }

        protected Component getHeaderCellRendererComponent(int columnDataIdx) {
            return this.myHeaderCellComponent.prepare(columnDataIdx);
        }
    }

    private static interface HeaderCellRendererConstants {
        public static final int NAME_LABEL_BORDER_LEFT = 3;
        public static final int NAME_LABEL_BORDER_RIGHT = 0;
        public static final int SORT_LABEL_BORDER_LEFT = 2;
        public static final int SORT_LABEL_BORDER_RIGHT = 3;
    }
}

