/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class DefaultGridColumnLayout
implements GridColumnLayout<DataConsumer.Row, DataConsumer.Column> {
    private static final Key<Integer> MAX_CELL_WIDTH_KEY = new Key("MaxCellWidth");
    private static final double GOLD = 0.5 * (3.0 - Math.sqrt(5.0));
    private static final int ADDITIONAL_COLUMN_WIDTH = 8;
    private static final int MIN_COLUMN_WIDTH = 40;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION = 100;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION = 10000;
    private final DataGrid myGrid;
    private boolean myTransposed;
    private boolean myInvalidateWidestCellValues;

    public DefaultGridColumnLayout(DataGrid grid) {
        this.myGrid = grid;
    }

    @Override
    public void doLayout() {
        this.doLayout((this.myTransposed ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList());
    }

    @Override
    public void newColumnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        this.updateWidestCellValueCaches(this.myGrid.getVisibleRows(), columnIndices);
    }

    @Override
    public void newRowsAdded(ModelIndexSet<DataConsumer.Row> rowIndices) {
        this.updateWidestCellValueCaches(rowIndices, this.myGrid.getVisibleColumns());
    }

    @Override
    public void columnsShown(ModelIndexSet<?> columnDataIndices) {
        this.doLayout(columnDataIndices.asList());
    }

    @Override
    public void setTransposed(boolean transposed) {
        if (transposed != this.myTransposed) {
            this.myInvalidateWidestCellValues = true;
        }
        this.myTransposed = transposed;
    }

    private void doLayout(List<? extends ModelIndex<?>> columnDataIndices) {
        class LayoutInfo {
            int min;
            int preferred;
            int full;

            LayoutInfo() {
            }
        }
        LayoutInfo layoutInfo;
        if (this.myInvalidateWidestCellValues) {
            this.updateWidestCellValueCaches(this.myGrid.getVisibleRows(), this.myGrid.getVisibleColumns());
        }
        int allColumnsPreferredWidth = 0;
        int extraWidth = 0;
        int allColumnsFullWidth = 0;
        HashMap columnWidths = ContainerUtil.newHashMap();
        HashSet columnsToResize = ContainerUtil.newHashSet(columnDataIndices);
        List visibleColumnDataIndices = (this.myTransposed ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList();
        JComponent gridPanel = this.myGrid.getComponent();
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)gridPanel, JScrollPane.class);
        int availableWidth = scrollPane != null ? scrollPane.getViewportBorderBounds().width : gridPanel.getWidth();
        for (ModelIndex columnDataIdx : visibleColumnDataIndices) {
            GridColumn column = this.myGrid.getLayoutColumn(columnDataIdx);
            if (column == null) continue;
            if (columnsToResize.contains(columnDataIdx)) {
                layoutInfo = new LayoutInfo();
                layoutInfo.min = Math.max(40, DefaultGridColumnLayout.computeHeaderWidth(column));
                layoutInfo.full = Math.max(layoutInfo.min, DefaultGridColumnLayout.computeColumnWidth(column));
                layoutInfo.preferred = Math.min(layoutInfo.full, (int)((double)availableWidth * GOLD));
                columnWidths.put(column, layoutInfo);
                allColumnsPreferredWidth += layoutInfo.preferred;
                extraWidth += layoutInfo.min == layoutInfo.full ? layoutInfo.preferred : 0;
                allColumnsFullWidth += layoutInfo.full;
                continue;
            }
            int currentWidth = column.getColumnWidth();
            allColumnsPreferredWidth += currentWidth;
            extraWidth += currentWidth;
            allColumnsFullWidth += currentWidth;
        }
        if (columnDataIndices.size() == 1 && visibleColumnDataIndices.size() > 1) {
            GridColumn insertedColumn;
            ModelIndex<?> insertedIdx = columnDataIndices.get(0);
            boolean insertedIdxIsValid = this.myTransposed && this.myGrid.isInsertedRow(DefaultGridColumnLayout.cast(insertedIdx));
            GridColumn gridColumn = insertedColumn = insertedIdxIsValid ? this.myGrid.getLayoutColumn(insertedIdx) : null;
            if (insertedColumn != null) {
                layoutInfo = (LayoutInfo)columnWidths.get(insertedColumn);
                int averageColumnWidth = (allColumnsPreferredWidth - layoutInfo.preferred) / (visibleColumnDataIndices.size() - 1);
                if (averageColumnWidth > layoutInfo.preferred) {
                    extraWidth -= layoutInfo.preferred;
                    allColumnsPreferredWidth -= layoutInfo.preferred;
                    allColumnsFullWidth -= layoutInfo.full;
                    layoutInfo.min = Math.min(averageColumnWidth, layoutInfo.min);
                    layoutInfo.preferred = averageColumnWidth;
                    layoutInfo.full = averageColumnWidth;
                    extraWidth += layoutInfo.preferred;
                    allColumnsPreferredWidth += layoutInfo.preferred;
                    allColumnsFullWidth += layoutInfo.full;
                }
            }
        }
        int requiredWidth = availableWidth >= allColumnsFullWidth ? allColumnsFullWidth : Math.max(availableWidth, allColumnsPreferredWidth);
        int requiredPlusExtra = requiredWidth + extraWidth;
        int widthToDistribute = visibleColumnDataIndices.isEmpty() || availableWidth <= requiredWidth ? 0 : (int)(((double)requiredPlusExtra < GOLD * (double)availableWidth ? GOLD * (double)availableWidth : ((double)requiredPlusExtra < (1.0 - GOLD) * (double)availableWidth ? (1.0 - GOLD) * (double)availableWidth : (double)availableWidth)) - (double)allColumnsPreferredWidth);
        for (GridColumn column : columnWidths.keySet()) {
            LayoutInfo layoutInfo2 = (LayoutInfo)columnWidths.get(column);
            int expandedWidth = layoutInfo2.preferred + (int)((double)(widthToDistribute * layoutInfo2.full) / (double)allColumnsFullWidth);
            column.setColumnWidth(Math.min(availableWidth, Math.min(expandedWidth, 2 * layoutInfo2.full)));
        }
    }

    private static int computeColumnWidth(GridColumn column) {
        return (Integer)ObjectUtils.notNull((Object)column.getUserData(MAX_CELL_WIDTH_KEY), (Object)0) + 8;
    }

    private static int computeHeaderWidth(GridColumn column) {
        return column.getPreferredHeaderWidth() + 8;
    }

    private void updateWidestCellValueCaches(ModelIndexSet<DataConsumer.Row> rowIndices, ModelIndexSet<DataConsumer.Column> columnIndices) {
        JBIterable rowDataIndices = (this.myTransposed ? columnIndices : rowIndices).asIterable();
        JBIterable columnDataIndices = (this.myTransposed ? rowIndices : columnIndices).asIterable();
        ArrayList toLayOut = ContainerUtil.newArrayList();
        for (ModelIndex columnDataIdx : columnDataIndices) {
            GridColumn layoutColumn = this.myGrid.getLayoutColumn(columnDataIdx);
            if (layoutColumn == null) continue;
            Integer cachedMaxCellWidth = this.myInvalidateWidestCellValues ? null : (Integer)layoutColumn.getUserData(MAX_CELL_WIDTH_KEY);
            int maxCellWidth = this.getMaximumPreferredWidth(rowDataIndices, columnDataIdx);
            if (!this.myInvalidateWidestCellValues && cachedMaxCellWidth == null) {
                toLayOut.add(columnDataIdx);
            }
            if (cachedMaxCellWidth != null && maxCellWidth <= cachedMaxCellWidth) continue;
            layoutColumn.putUserData(MAX_CELL_WIDTH_KEY, maxCellWidth > 0 ? Integer.valueOf(maxCellWidth) : null);
        }
        this.myInvalidateWidestCellValues = false;
        if (!toLayOut.isEmpty()) {
            this.doLayout(toLayOut);
        }
    }

    private int getMaximumPreferredWidth(JBIterable<? extends ModelIndex<?>> rowDataIndices, ModelIndex<?> columnDataIdx) {
        int widestCell = 0;
        for (ModelIndex rowDataIdx : rowDataIndices) {
            ModelIndex columnIdx;
            JComponent component;
            ModelIndex rowIdx;
            if (this.myTransposed) {
                ModelIndex columnIdx2;
                rowIdx = DefaultGridColumnLayout.cast(columnDataIdx);
                JComponent component2 = this.myGrid.getCellRendererComponent(rowIdx, columnIdx2 = DefaultGridColumnLayout.cast(rowDataIdx));
                if (component2 == null) continue;
                widestCell = Math.max(widestCell, component2.getPreferredSize().width);
                continue;
            }
            rowIdx = DefaultGridColumnLayout.cast(rowDataIdx);
            int rowIdxInt = rowIdx.asInteger();
            if (rowIdxInt > 10000 || rowIdxInt > 100 && rowIdxInt % 100 != 0 || (component = this.myGrid.getCellRendererComponent(rowIdx, columnIdx = DefaultGridColumnLayout.cast(columnDataIdx))) == null) continue;
            widestCell = Math.max(widestCell, component.getPreferredSize().width);
        }
        return widestCell;
    }

    @NotNull
    private static <T> ModelIndex<T> cast(@NotNull ModelIndex<?> idx) {
        if (idx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/database/run/ui/grid/DefaultGridColumnLayout", "cast"));
        }
        ModelIndex<?> modelIndex = idx;
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DefaultGridColumnLayout", "cast"));
        }
        return modelIndex;
    }
}

