/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class GridColorsScheme
extends DelegateColorScheme {
    public GridColorsScheme() {
        super(EditorColorsManager.getInstance().getGlobalScheme());
    }

    @NotNull
    public CellAttributes getAttributes(@NotNull CellAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/grid/GridColorsScheme", "getAttributes"));
        }
        TextAttributes attributes = this.getAttributes(key.attributes);
        Color color = attributes.getBackgroundColor();
        Color background = key.isUnderlined ? null : color;
        Color effect = key.isUnderlined ? color : null;
        CellAttributes cellAttributes = new CellAttributes(background, effect, key.isUnderlined);
        if (cellAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridColorsScheme", "getAttributes"));
        }
        return cellAttributes;
    }

    public static class ForConsole
    extends GridColorsScheme {
        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = super.getConsoleFontPreferences();
            if (fontPreferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridColorsScheme$ForConsole", "getFontPreferences"));
            }
            return fontPreferences;
        }

        public String getEditorFontName() {
            return super.getConsoleFontName();
        }

        public int getEditorFontSize() {
            return super.getConsoleFontSize();
        }

        public float getLineSpacing() {
            return super.getConsoleLineSpacing();
        }

        public Font getFont(EditorFontType key) {
            return super.getFont(key == EditorFontType.PLAIN ? EditorFontType.CONSOLE_PLAIN : (key == EditorFontType.ITALIC ? EditorFontType.CONSOLE_ITALIC : (key == EditorFontType.BOLD ? EditorFontType.CONSOLE_BOLD : (key == EditorFontType.BOLD_ITALIC ? EditorFontType.CONSOLE_BOLD_ITALIC : key))));
        }
    }
}

