/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterPanel
extends EditorHeaderComponent {
    private final Project myProject;
    private final DataGrid myGrid;
    private final List<String> myFilterHistory;
    private final MyFilterEditorTextField myFilterField;
    private final JLabel myFilterHistoryLabel;
    private JBPopup myFilterHistoryPopup;

    public GridFilterPanel(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/GridFilterPanel", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridFilterPanel", "<init>"));
        }
        this.myProject = project;
        this.myGrid = grid;
        this.myFilterHistory = ContainerUtil.newArrayList();
        GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        Document document = filteringModel != null ? filteringModel.getFilterDocument() : EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myFilterField = new MyFilterEditorTextField(document);
        if (filteringModel != null) {
            filteringModel.addListener(new GridFilteringModel.Listener(){

                @Override
                public void filterDocumentChanged(@NotNull GridFilteringModel filteringModel) {
                    if (filteringModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filteringModel", "com/intellij/database/run/ui/grid/GridFilterPanel$1", "filterDocumentChanged"));
                    }
                    GridFilterPanel.this.myFilterField.setDocument(filteringModel.getFilterDocument());
                }
            }, grid);
        }
        this.myFilterHistoryLabel = new JLabel(AllIcons.Actions.Search){

            @Override
            public Color getBackground() {
                return GridFilterPanel.this.myFilterField.getBackground();
            }
        };
        this.myFilterHistoryLabel.setOpaque(true);
        this.myFilterHistoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$3", "mousePressed"));
                }
                GridFilterPanel.this.showFilterHistoryPopup();
            }
        });
        JLabel clearFieldLabel = new JLabel(UIUtil.isUnderDarcula() ? AllIcons.Actions.Clean : AllIcons.Actions.CleanLight){

            @Override
            public Color getBackground() {
                return GridFilterPanel.this.myFilterField.getBackground();
            }
        };
        clearFieldLabel.setOpaque(true);
        clearFieldLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$5", "mouseReleased"));
                }
                if (GridFilterPanel.this.setFilterText("", -1)) {
                    GridFilterPanel.this.myGrid.toggleFiltering();
                    GridFilterPanel.this.myGrid.applyFilter();
                }
            }
        });
        JPanel filterFieldPanel = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                return GridFilterPanel.this.myFilterField.getBackground();
            }
        };
        filterFieldPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        filterFieldPanel.add((Component)clearFieldLabel, "East");
        filterFieldPanel.add((Component)this.myFilterHistoryLabel, "West");
        filterFieldPanel.add((Component)((Object)this.myFilterField), "Center");
        this.setBorder((Border)new CustomLineBorder(JBColor.border(), 1, 0, 0, 0));
        this.add(filterFieldPanel, "Center");
    }

    public boolean setFilterText(String filter, int caretPosition) {
        String newFilter;
        boolean valueChanged;
        String currentFilter = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem(this.myFilterHistory)));
        boolean bl = valueChanged = !Comparing.equal((String)currentFilter, (String)(newFilter = filter.trim())) || !Comparing.equal((String)this.myFilterField.getText(), (String)newFilter);
        if (valueChanged) {
            if (StringUtil.isNotEmpty((String)newFilter)) {
                this.myFilterHistory.remove(newFilter);
                this.myFilterHistory.add(0, newFilter);
                this.trimFilterHistory();
            }
            this.myFilterField.setText(filter);
        }
        if (caretPosition >= 0) {
            this.myFilterField.requestFocusInWindow();
            this.myFilterField.getCaretModel().moveToOffset(caretPosition);
        }
        return valueChanged;
    }

    public void currentFilterApplied() {
        this.setFilterText(this.myFilterField.getText(), -1);
    }

    public void showErrorBalloon(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/grid/GridFilterPanel", "showErrorBalloon"));
        }
        Editor editor = this.myFilterField.getEditor();
        if (editor == null) {
            return;
        }
        JComponent component = editor.getContentComponent();
        DataSourceUiUtil.showErrorBalloon(error, component, this.getFilterEditorCaretPoint(), true, false);
    }

    public ImmutableList<String> getHistory() {
        return ContainerUtil.immutableList(this.myFilterHistory);
    }

    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/database/run/ui/grid/GridFilterPanel", "setHistory"));
        }
        this.myFilterHistory.clear();
        this.myFilterHistory.addAll(history);
        this.trimFilterHistory();
    }

    public void requestFocus() {
        this.myFilterField.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.myFilterField.requestFocusInWindow();
    }

    private void trimFilterHistory() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        int historySize = Math.max(0, settings.getFiltersHistorySize());
        while (this.myFilterHistory.size() > historySize) {
            this.myFilterHistory.remove(this.myFilterHistory.size() - 1);
        }
    }

    private void showFilterHistoryPopup() {
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        JBList history = new JBList(this.myFilterHistory);
        Runnable itemChosenCallback = new Runnable((JList)history){
            final /* synthetic */ JList val$history;
            {
                this.val$history = jList;
            }

            @Override
            public void run() {
                String selectedFilter = (String)this.val$history.getSelectedValue();
                if (selectedFilter != null) {
                    GridFilterPanel.this.setFilterText(selectedFilter, -1);
                    GridFilterPanel.this.myGrid.applyFilter();
                }
            }
        };
        this.myFilterHistoryPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)history).setMovable(false).setRequestFocus(true).setItemChoosenCallback(itemChosenCallback).createPopup();
        this.myFilterHistoryPopup.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                GridFilterPanel.this.myFilterHistoryPopup = null;
            }
        });
        if (this.myGrid.getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this.myFilterHistoryLabel);
        }
    }

    @Nullable
    private Point getFilterEditorCaretPoint() {
        Editor editor = this.myFilterField.getEditor();
        if (editor == null) {
            return null;
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        Point point = editor.visualPositionToXY(caretPosition);
        point.translate(0, editor.getContentComponent().getHeight());
        return point;
    }

    private class MyFilterEditorTextField
    extends EditorTextField
    implements EditorSettingsProvider,
    Disposable {
        private EditorEx myLastEditor;

        public MyFilterEditorTextField(Document document) {
            super(document, GridFilterPanel.this.myProject, (FileType)DbSqlUtil.getSqlDialect(DataGridUtil.getDatabaseDialect(GridFilterPanel.this.myGrid)).getAssociatedFileType(), false, true);
            this.setSupplementary(true);
            this.setOneLineMode(true);
            this.setFocusable(false);
            this.setPlaceholder("<Filter criteria>");
            this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)1, (int)0));
            this.addSettingsProvider(this);
            Disposer.register((Disposable)GridFilterPanel.this.myGrid, (Disposable)this);
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField", "updateBorder"));
            }
            editor.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)7, (int)0, (int)7));
        }

        protected boolean shouldHaveBorder() {
            return false;
        }

        public Color getBackground() {
            return UIUtil.getTextFieldBackground();
        }

        public void customizeSettings(EditorEx editor) {
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(DataGridUtil.getDatabaseDialect(GridFilterPanel.this.myGrid));
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)this.getProject(), null);
            editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
            editor.setEmbeddedIntoDialogWrapper(true);
            JComponent editorComp = editor.getComponent();
            new ApplyAction().registerCustomShortcutSet(CommonShortcuts.ENTER, editorComp);
            new CancelAction().registerCustomShortcutSet(CommonShortcuts.ESCAPE, editorComp);
            new ShowHistoryAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 0)), editorComp);
            this.myLastEditor = editor;
        }

        public Object getData(String dataId) {
            Editor editor;
            if (PlatformDataKeys.FILE_EDITOR.is(dataId) && (editor = this.getEditor()) != null) {
                return TextEditorProvider.getInstance().getTextEditor(editor);
            }
            return super.getData(dataId);
        }

        public void dispose() {
            if (this.myLastEditor != null && !this.myLastEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor((Editor)this.myLastEditor);
            }
        }

        private class ShowHistoryAction
        extends FilterFieldAction {
            public ShowHistoryAction() {
                super("Show filter history");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$ShowHistoryAction", "actionPerformed"));
                }
                GridFilterPanel.this.showFilterHistoryPopup();
            }
        }

        private class CancelAction
        extends FilterFieldAction {
            public CancelAction() {
                super("Cancel");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$CancelAction", "actionPerformed"));
                }
                IdeFocusManager.findInstanceByComponent((Component)GridFilterPanel.this.myGrid.getComponent()).requestFocus((Component)GridFilterPanel.this.myGrid.getPreferredFocusedComponent(), true);
            }
        }

        private class ApplyAction
        extends FilterFieldAction {
            public ApplyAction() {
                super("Apply");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$ApplyAction", "actionPerformed"));
                }
                if (this.isValidFilterEntered()) {
                    GridFilterPanel.this.myGrid.applyFilter();
                } else {
                    this.showInvalidFilterCriteriaBalloon();
                }
            }

            private boolean isValidFilterEntered() {
                if (StringUtil.isEmptyOrSpaces((String)GridFilterPanel.this.myFilterField.getText())) {
                    return true;
                }
                PsiFile psi = PsiDocumentManager.getInstance((Project)MyFilterEditorTextField.this.getProject()).getPsiFile(GridFilterPanel.this.myFilterField.getDocument());
                return psi == null || !PsiTreeUtil.hasErrorElements((PsiElement)psi);
            }

            private void showInvalidFilterCriteriaBalloon() {
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Invalid filter criteria.", MessageType.WARNING, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
                Point point = GridFilterPanel.this.getFilterEditorCaretPoint();
                balloon.show(new RelativePoint((Component)GridFilterPanel.this.myFilterField.getComponent(), point), Balloon.Position.below);
            }
        }

        private abstract class FilterFieldAction
        extends AnAction {
            public FilterFieldAction(String text) {
                super(text);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$FilterFieldAction", "update"));
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridFilterPanel.this.myFilterField.getEditor()) == null);
            }
        }
    }
}

