/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;

public class GridRowHeader
extends JComponent {
    private final JTable myTable;
    private final CellRendererPane myRendererPane;
    protected final RowHeaderCellRenderer myCellRenderer;
    private int myPreferredWidth;

    public GridRowHeader(@NotNull JTable table, @NotNull RowHeaderCellRenderer cellRenderer) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridRowHeader", "<init>"));
        }
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/intellij/database/run/ui/grid/GridRowHeader", "<init>"));
        }
        this.myRendererPane = new CellRendererPane();
        this.myPreferredWidth = 1;
        this.myTable = table;
        this.myCellRenderer = cellRenderer;
        this.add(this.myRendererPane);
        this.setupListeners();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.myPreferredWidth, this.myTable.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        final Graphics2D g2 = (Graphics2D)g;
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paintComponent(g);
        final Rectangle clip = g.getClipBounds();
        final int rowMargin = this.myTable.getRowMargin();
        final BasicStroke gridLineStroke = new BasicStroke(rowMargin);
        CellRenderingUtils.processVisibleRows(this.myTable, g, new CellRenderingUtils.RowProcessor(){

            @Override
            public boolean process(int row, int y) {
                int rowHeight = GridRowHeader.this.myTable.getRowHeight(row);
                int cellHeight = Math.max(0, rowHeight - rowMargin);
                Component cellRenderer = GridRowHeader.this.myCellRenderer.getRendererComponent(row);
                GridRowHeader.this.myRendererPane.paintComponent(g2, cellRenderer, GridRowHeader.this, 0, y, GridRowHeader.this.getWidth(), cellHeight, true);
                int gridY = y + cellHeight + rowMargin / 2;
                Stroke backupStroke = g2.getStroke();
                Color backupColor = g2.getColor();
                g2.setStroke(gridLineStroke);
                g2.setColor(GridRowHeader.this.myTable.getGridColor());
                g2.drawLine(clip.x, gridY, clip.x + clip.width, gridY);
                g2.setStroke(backupStroke);
                g2.setColor(backupColor);
                return true;
            }
        });
    }

    private void revalidateAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    private void setupListeners() {
        this.setupComponentListener();
        this.setupSelectionListeners();
        this.setupTableModelListener();
        this.setupRowHeightChangeListener();
    }

    private void setupRowHeightChangeListener() {
        this.addPropertyChangeListener("rowHeight", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GridRowHeader.this.updatePreferredSize();
                GridRowHeader.this.revalidateAndRepaint();
            }
        });
    }

    private void setupComponentListener() {
        this.myTable.addComponentListener(new ComponentAdapter(){
            private int myPreviousTableHeight;

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.myPreviousTableHeight != GridRowHeader.this.myTable.getHeight()) {
                    GridRowHeader.this.updatePreferredSize();
                    this.myPreviousTableHeight = GridRowHeader.this.myTable.getHeight();
                }
            }
        });
    }

    private void setupSelectionListeners() {
        ListSelectionModel columnSelectionModel;
        ListSelectionModel rowSelectionModel = this.myTable.getSelectionModel();
        if (rowSelectionModel != null) {
            rowSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GridRowHeader.this.revalidateAndRepaint();
                }
            });
        }
        if ((columnSelectionModel = this.myTable.getColumnModel().getSelectionModel()) != null) {
            columnSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GridRowHeader.this.revalidateAndRepaint();
                }
            });
        }
    }

    private void setupTableModelListener() {
        TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GridRowHeader.this.updatePreferredSize();
                GridRowHeader.this.revalidateAndRepaint();
            }
        };
        this.myTable.getModel().addTableModelListener(tableModelListener);
    }

    protected void updatePreferredSize() {
        Insets insets = this.getInsets();
        this.myPreferredWidth = insets.left + insets.right + this.calcPreferredWidthWithoutInsets();
        this.revalidateAndRepaint();
    }

    protected int calcPreferredWidthWithoutInsets() {
        int maxCellRendererWidth = 0;
        for (int row = 0; row < this.myTable.getRowCount(); ++row) {
            Component renderer = this.myCellRenderer.getRendererComponent(row);
            Dimension preferredSize = renderer.getPreferredSize();
            if (preferredSize.width <= maxCellRendererWidth) continue;
            maxCellRendererWidth = preferredSize.width;
        }
        return Math.max(1, maxCellRendererWidth);
    }

    public static interface RowHeaderCellRenderer {
        public Component getRendererComponent(int var1);
    }
}

