/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.openapi.editor.impl.LeftHandScrollbarLayout;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.ViewportLayout;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class GridScrollPane
extends JBScrollPane {
    private final JTable myTable;
    private static final ViewportLayout myViewportLayout = new ViewportLayout(){

        @Override
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension vpSize = vp.getSize();
            Dimension extentSize = vp.toViewCoordinates(vpSize);
            Dimension viewSize = new Dimension(viewPrefSize);
            Point viewPosition = vp.getViewPosition();
            if (vp.getParent() == null || vp.getParent().getComponentOrientation().isLeftToRight() != vp.getParent().getLayout() instanceof LeftHandScrollbarLayout) {
                if (viewPosition.x + extentSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewSize.width - extentSize.width);
                }
            } else {
                viewPosition.x = extentSize.width > viewSize.width ? viewSize.width - extentSize.width : Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            vp.setViewPosition(viewPosition);
            vp.setViewSize(viewSize);
        }
    };

    public GridScrollPane(@NotNull JTable table, JComponent headerComponent, JComponent gutterComponent, JComponent upperLeadingCornerComponent) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridScrollPane", "<init>"));
        }
        this.myTable = table;
        this.setViewportView(table);
        this.setColumnHeaderView(headerComponent);
        this.setRowHeaderView(gutterComponent);
        this.setupColumnScroller();
        this.setCorner("UPPER_LEADING_CORNER", upperLeadingCornerComponent);
        this.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridScrollPane$1", "mousePressed"));
                }
                GridScrollPane.this.myTable.requestFocus();
            }
        });
        if (Registry.is((String)"ide.scroll.new.layout")) {
            this.getHorizontalScrollBar().setOpaque(true);
            this.getVerticalScrollBar().setOpaque(true);
        }
    }

    public void setFlipControls(boolean flip) {
        if (Registry.is((String)"ide.scroll.new.layout")) {
            this.putClientProperty(JBScrollPane.Flip.class, flip ? JBScrollPane.Flip.HORIZONTAL : null);
        } else {
            this.setLayout((LayoutManager)(flip ? new LeftHandScrollbarLayout() : new ScrollPaneLayout()));
        }
    }

    public void setComponentOrientation(ComponentOrientation co) {
        super.setComponentOrientation(co);
        this.flipCorners("UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER");
        this.flipCorners("LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER");
    }

    protected JViewport createViewport() {
        return new JBViewport(){

            protected LayoutManager createLayoutManager() {
                return Registry.is((String)"ide.scroll.new.layout") ? super.createLayoutManager() : myViewportLayout;
            }

            public Color getBackground() {
                return GridScrollPane.this.myTable != null ? GridScrollPane.this.myTable.getBackground() : super.getBackground();
            }

            public boolean isOpaque() {
                return false;
            }
        };
    }

    private void flipCorners(String corner1, String corner2) {
        Component c1 = this.getCorner(corner1);
        Component c2 = this.getCorner(corner2);
        this.setCorner(corner1, c2);
        this.setCorner(corner2, c1);
    }

    private void setupColumnScroller() {
        JBAutoscroller.installOn((JComponent)this.myTable);
        JBAutoscroller.installOn((JComponent)((JComponent)this.getRowHeader().getView()), (JBAutoscroller.ScrollDeltaProvider)new JBAutoscroller.DefaultScrollDeltaProvider(){

            public int getHorizontalScrollDelta(MouseEvent e) {
                return 0;
            }
        });
        JBAutoscroller.installOn((JComponent)this.myTable.getTableHeader(), (JBAutoscroller.ScrollDeltaProvider)new JBAutoscroller.DefaultScrollDeltaProvider(){

            public int getVerticalScrollDelta(MouseEvent e) {
                return 0;
            }

            public int getHorizontalScrollDelta(MouseEvent e) {
                JTableHeader header = GridScrollPane.this.myTable.getTableHeader();
                TableColumn draggedColumn = header.getDraggedColumn();
                if (draggedColumn != null) {
                    Rectangle visibleRect = header.getVisibleRect();
                    int leftmost = visibleRect.x;
                    int rightmost = visibleRect.x + visibleRect.width - 1;
                    Rectangle draggedRect = this.computeColumnHeaderRectangle(draggedColumn);
                    int left = draggedRect.x + header.getDraggedDistance();
                    int right = left + draggedRect.width - 1;
                    return right > rightmost ? right - rightmost : (left < leftmost ? left - leftmost : 0);
                }
                return super.getHorizontalScrollDelta(e);
            }

            private Rectangle computeColumnHeaderRectangle(TableColumn targetColumn) {
                TableColumn column;
                JTableHeader header = GridScrollPane.this.myTable.getTableHeader();
                TableColumnModel columnModel = GridScrollPane.this.myTable.getColumnModel();
                int targetColumnX = 0;
                for (int i = 0; i < GridScrollPane.this.myTable.getColumnCount() && (column = columnModel.getColumn(i)) != targetColumn; ++i) {
                    targetColumnX += column.getWidth();
                }
                return new Rectangle(targetColumnX, 0, targetColumn.getWidth(), header.getHeight());
            }
        });
    }

    public boolean isFlipped() {
        Object property = this.getClientProperty(JBScrollPane.Flip.class);
        if (property == JBScrollPane.Flip.HORIZONTAL) {
            return true;
        }
        return this.getLayout() instanceof LeftHandScrollbarLayout;
    }
}

