/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.util.ObjectUtils;
import java.text.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultNumericEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultNumericEditorFactory() {
    }

    @Override
    @NotNull
    protected Format getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
        }
        Format format = DefaultNumericEditorFactory.getFormat(grid, column);
        if (format != null) {
            Format format2 = format;
            if (format2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
            }
            return format2;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getSuitability"));
        }
        return DefaultNumericEditorFactory.getFormat(grid, column) == null ? 0 : 1;
    }

    @Nullable
    private static Format getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultNumericEditorFactory", "getFormat"));
        }
        ObjectFormatter formatter = grid.getObjectFormatter();
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        switch (ExtractorsUtil.guessJdbcType(c)) {
            case -6: 
            case 4: 
            case 5: {
                return formatter.getNumberFormat();
            }
            case -5: {
                return formatter.getBigIntFormat();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return formatter.getDecimalFormat(c);
            }
        }
        if (ObjectFormatter.isFloatingPoint(c)) {
            return formatter.getDecimalFormat(c);
        }
        return null;
    }
}

