/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.project.Project;
import java.text.Format;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        Project project = DataGridUtil.getProject(grid);
        Format format = this.getFormat(grid, row, column);
        Object value = grid.getDataModel().getValueAt(row, column);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(grid, project, format, value, nullValue, initiator);
        if (formatBasedGridCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    protected abstract Format getFormat(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull DataGrid grid, Project project, @NotNull Format format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor formatBasedGridCellEditor = new FormatBasedGridCellEditor(project, grid, format, value, nullValue, initiator);
        if (formatBasedGridCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        return formatBasedGridCellEditor;
    }
}

