/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.editors.DefaultBlobEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBooleanEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultDateEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultNumericEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.PostgresHstoreEditorFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorFactories
implements GridCellEditorFactoryProvider {
    private static final GridCellEditorFactories INSTANCE = new GridCellEditorFactories();
    private final List<? extends GridCellEditorFactory> myDefaultFactories = ContainerUtil.list((Object[])new GridCellEditorFactory[]{new DefaultNumericEditorFactory(), new DefaultDateEditorFactory(), new DefaultTimestampEditorFactory(), new DefaultTimeEditorFactory(), new DefaultTextEditorFactory(), new DefaultBlobEditorFactory(), new DefaultBooleanEditorFactory(), new PostgresHstoreEditorFactory()});

    public static GridCellEditorFactories getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories", "getEditorFactory"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories", "getEditorFactory"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories", "getEditorFactory"));
        }
        int maxSuitability = 0;
        GridCellEditorFactory bestMatchingFactory = null;
        for (GridCellEditorFactory gridCellEditorFactory : this.myDefaultFactories) {
            int suitability = gridCellEditorFactory.getSuitability(grid, row, column);
            if (suitability <= maxSuitability) continue;
            maxSuitability = suitability;
            bestMatchingFactory = gridCellEditorFactory;
        }
        return bestMatchingFactory;
    }
}

