/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.Component;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                final IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus(new FocusCommand(){

                    @NotNull
                    public ActionCallback run() {
                        ActionCallback actionCallback = grid.isEditing() ? ActionCallback.REJECTED : fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
                        if (actionCallback == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$1$1", "run"));
                        }
                        return actionCallback;
                    }
                }, true);
            }
        });
        popup.show(component, x, y);
    }
}

