/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlOperations {
    private final Map<DdlGraph.DdlOperation, DdlOperationGenerator<? extends DeObject>> myGenerators = ContainerUtil.newHashMap();

    public void add(@NotNull DdlOperationGenerator<? extends DeObject> gen) {
        if (gen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gen", "com/intellij/database/schemaEditor/generation/DdlOperations", "add"));
        }
        this.myGenerators.put(gen.getOperation(), gen);
    }

    @Nullable
    public <De extends DeObject> DdlOperationGenerator<De> get(@NotNull DdlGraph.DdlOperation op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlOperations", "get"));
        }
        return this.myGenerators.get(op);
    }

    public static class DdlOperationGenerator<T extends DeObject> {
        @NotNull
        protected final Logger myLogger;
        @NotNull
        private final DdlGraph.DdlOperation myOperation;

        public DdlOperationGenerator(@NotNull DdlGraph.DdlOperation operation) {
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "<init>"));
            }
            this.myLogger = Logger.getInstance(this.getClass());
            this.myOperation = operation;
        }

        @NotNull
        public DdlGraph.DdlOperation getOperation() {
            DdlGraph.DdlOperation ddlOperation = this.myOperation;
            if (ddlOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getOperation"));
            }
            return ddlOperation;
        }

        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull T object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getImplemented"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getImplemented"));
            }
            return jBIterable;
        }

        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addToBuilder"));
            }
            DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addToBuilder"));
            }
            return ddlGenerator;
        }

        @NotNull
        protected DdlGenerator addSelfToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addSelfToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addSelfToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addSelfToBuilder"));
            }
            DdlOperationKey op = new DdlOperationKey((DeObject)das, this.getOperation());
            builder.addOperation(op, data, (Iterable<DdlOperationKey>)this.getImplemented(das, data)).addDependencies(op, (Iterable<DdlOperationKey>)this.getDependencies(das, data)).addDependencies((Iterable<DdlOperationKey>)this.getDependants(das, data), op);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "addSelfToBuilder"));
            }
            return ddlGenerator;
        }

        @NotNull
        public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "removeFromBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "removeFromBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "removeFromBuilder"));
            }
            DdlOperationKey op = new DdlOperationKey((DeObject)das, this.getOperation());
            builder.removeOperation(op).removeDependencies(op, (Iterable<DdlOperationKey>)this.getDependencies(das, data)).removeDependencies((Iterable<DdlOperationKey>)this.getDependants(das, data), op);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "removeFromBuilder"));
            }
            return ddlGenerator;
        }

        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull T object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "generate"));
            }
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "generate"));
            }
            return ddlBuilder;
        }

        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull T object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getDependencies"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getDependencies"));
            }
            return jBIterable;
        }

        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull T object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getDependants"));
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperations$DdlOperationGenerator", "getDependants"));
            }
            return jBIterable;
        }
    }

    public static interface SchemaState {
        @NotNull
        public <De extends DeObject> De get(@NotNull De var1, boolean var2);

        public void remove(@NotNull DeObject var1);

        @NotNull
        public <De extends DeObject> De add(@NotNull De var1);

        public <De extends DeObject> void alter(@NotNull De var1, @NotNull De var2);
    }
}

