/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseStructure
extends AbstractTreeStructure {
    private final DbPsiFacade myFacade;
    private final DatabaseViewOptions myViewOptions;

    public DatabaseStructure(DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        this.myViewOptions = viewOptions;
        this.myFacade = facade;
    }

    public Object getRootElement() {
        return this.myFacade;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFacade.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getProject"));
        }
        return project;
    }

    public boolean isAlwaysLeaf(Object element) {
        return DatabaseStructure.isAlwaysLeafImpl(element);
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        return o instanceof DasTableChild || o instanceof DasRoutine || o instanceof DasObject && ((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasSynonym;
    }

    public static boolean isDatabaseObject(Object element) {
        return element instanceof DbElement || element instanceof GroupElement;
    }

    public Object[] getChildElements(Object element) {
        if (element == this.myFacade) {
            return ArrayUtil.toObjectArray((Collection)this.myFacade.getDataSources());
        }
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return ArrayUtil.toObjectArray((Collection)DatabaseStructure.getChildrenImpl(element, this.myViewOptions).toList());
    }

    public Object getParentElement(Object o) {
        if (o == this.myFacade) {
            return null;
        }
        if (o instanceof DbDataSource) {
            return this.myFacade;
        }
        return o instanceof PsiElement ? DatabaseStructure.getParentImpl((PsiElement)o, this.myViewOptions) : null;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions) {
        boolean groupOption;
        DbElement root;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        if (viewOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewOptions", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        Object object = o instanceof GroupElement ? ((GroupElement)((Object)o)).element : (o instanceof DbDataSource || o instanceof DbNamespaceImpl ? DatabaseStructure.getTopSingleRoot((DbElement)o) : (root = o instanceof DbElement ? (DbElement)o : null));
        if (root == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
            }
            return jBIterable;
        }
        ObjectKind kidKind = o instanceof GroupElement ? ((GroupElement)((Object)o)).kind : ObjectKind.NONE;
        ObjectKind rootKind = root.getKind();
        MetaModel<?> metaModel = DbImplUtil.getDatabaseDialect(root).getMetaModel();
        boolean isNamespace = metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind == ObjectKind.NONE) {
            List groups = ContainerUtil.newSmartList();
            int w = 0;
            for (Couple couple : metaModel.getKindCouples()) {
                if (couple.first != rootKind) continue;
                ++w;
                if (!viewOptions.SHOW_EMPTY_GROUPS && root.getDbChildren(DbElement.class, (ObjectKind)couple.second).isEmpty()) continue;
                groups.add(new GroupElement(root, (ObjectKind)couple.second, w, viewOptions));
            }
            if (groups.size() > 1) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
                }
                return jBIterable;
            }
        }
        JBIterable children = root.getDbChildren(DbElement.class, kidKind);
        if (!viewOptions.SHOW_TABLE_DETAILS && o instanceof DasTable) {
            children = children.filter(DasUtil.byKind((ObjectKind)ObjectKind.COLUMN));
        }
        if (root instanceof DasNamespace) {
            try {
                Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter((DatabaseSystem)root.getDataSource());
                children = children.filter(condition);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        JBIterable jBIterable = children;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getChildrenImpl"));
        }
        return jBIterable;
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        boolean groupOption;
        DbElement grandPa;
        DbElement root;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DatabaseStructure", "getParentImpl"));
        }
        if (!o.isValid()) {
            return null;
        }
        Object object = o instanceof GroupElement ? ((GroupElement)o).element : (root = o instanceof DbElement ? ((DbElement)o).getDbParent() : null);
        while (root instanceof DbNamespaceImpl && (grandPa = root.getDbParent()) != null && DatabaseStructure.getTopSingleRoot(grandPa) != grandPa) {
            root = grandPa;
        }
        if (root == null) {
            return null;
        }
        ObjectKind kidKind = o instanceof DbElement ? ((DbElement)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root.getKind();
        MetaModel<?> metaModel = DbImplUtil.getDatabaseDialect(root).getMetaModel();
        boolean isNamespace = metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind != ObjectKind.NONE) {
            GroupElement result = null;
            int w = 0;
            for (Couple couple : metaModel.getKindCouples()) {
                if (couple.first != rootKind) continue;
                ++w;
                if (couple.second != kidKind) continue;
                result = new GroupElement(root, (ObjectKind)couple.second, w, viewOptions);
            }
            if (w > 1 && result != null) {
                return result;
            }
        }
        return root;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element instanceof DbElement) {
            DbNodeDescriptor dbNodeDescriptor = new DbNodeDescriptor((DbElement)element, parentDescriptor);
            if (dbNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return dbNodeDescriptor;
        }
        if (element == this.myFacade) {
            Root root = new Root(this.myFacade);
            if (root == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return root;
        }
        if (element instanceof GroupElement) {
            GroupNode groupNode = new GroupNode((GroupElement)((Object)element), parentDescriptor);
            if (groupNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "createDescriptor"));
            }
            return groupNode;
        }
        throw new AssertionError(element);
    }

    @NotNull
    static DbElement getTopSingleRoot(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseStructure", "getTopSingleRoot"));
        }
        CommonProcessors.FindFirstAndOnlyProcessor processor = new CommonProcessors.FindFirstAndOnlyProcessor();
        DbElement e = element;
        while (true) {
            processor.reset();
            ContainerUtil.process((Iterable)e.getDbChildren(DasNamespace.class, ObjectKind.NONE), (Processor)processor);
            DasNamespace value = (DasNamespace)processor.getFoundValue();
            if (!(value instanceof DbElement)) break;
            e = (DbElement)value;
        }
        DbElement dbElement = e;
        if (dbElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "getTopSingleRoot"));
        }
        return dbElement;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return true;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.getProject()).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = DatabaseStructure.asyncCommitDocuments((Project)this.getProject());
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    private static class GroupElement
    extends FakePsiElement {
        final DbElement element;
        final ObjectKind kind;
        final String name;
        final int weight;
        final DatabaseViewOptions viewOptions;

        GroupElement(@NotNull DbElement element, @NotNull ObjectKind kind, int weight, DatabaseViewOptions viewOptions) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseStructure$GroupElement", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/DatabaseStructure$GroupElement", "<init>"));
            }
            this.kind = kind;
            this.element = element;
            this.weight = weight;
            this.viewOptions = viewOptions;
            this.name = StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)kind, (DatabaseDialect)DbImplUtil.getDatabaseDialect(element)));
        }

        @NotNull
        public Project getProject() {
            Project project = this.element.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseStructure$GroupElement", "getProject"));
            }
            return project;
        }

        public PsiFile getContainingFile() {
            return this.element.getContainingFile();
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.ObjectGroup;
        }

        public PsiElement getParent() {
            return this.element;
        }

        public boolean isValid() {
            return this.element.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            GroupElement folder = (GroupElement)((Object)o);
            if (!this.element.equals(folder.element)) {
                return false;
            }
            return this.kind.equals(folder.kind);
        }

        public int hashCode() {
            int result = this.element.hashCode();
            result = 31 * result + this.kind.hashCode();
            return result;
        }
    }

    private static class GroupNode
    extends PresentableNodeDescriptor
    implements DataProvider {
        private static final SimpleTextAttributes SMALL_GRAY = new SimpleTextAttributes(128, (Color)JBColor.GRAY);
        final GroupElement element;

        public GroupNode(GroupElement element, NodeDescriptor parentDescriptor) {
            super(parentDescriptor.getProject(), parentDescriptor);
            this.element = element;
        }

        protected void update(PresentationData presentation) {
            int size;
            presentation.setIcon(this.element.getIcon(true));
            presentation.addText(this.element.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            int n = size = this.element.isValid() ? DatabaseStructure.getChildrenImpl((Object)this.element, this.element.viewOptions).size() : 0;
            if (size > 0) {
                presentation.addText(" " + size, SMALL_GRAY);
            }
        }

        public int getWeight() {
            return this.element.weight;
        }

        public Object getElement() {
            return this.element;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return DbNodeDescriptor.getData(dataId, this.element.element);
        }
    }

    private static class Root
    extends PresentableNodeDescriptor {
        final DbPsiFacade element;

        public Root(DbPsiFacade facade) {
            super(facade.getProject(), null);
            this.element = facade;
        }

        protected void update(PresentationData presentation) {
        }

        public Object getElement() {
            return this.element;
        }
    }
}

