/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.editors.DatabaseTableForeignKeysEditor;
import com.intellij.database.view.editors.DatabaseTableIndicesEditor;
import com.intellij.database.view.editors.DatabaseTableKeysEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableEditor
extends DatabaseEditorBaseEx {
    private JTextField myTableNameField;
    private JLabel myTableNameLabel;
    private JPanel myMainPanel;
    private JComponent myTabsPanel;
    private JPanel myCommentHolder;
    private JPanel myCommentPanel;
    private JLabel myCommentLabel;
    private JBTextField myCommentField;
    private TabbedPaneWrapper myTabs;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final TableEditorModel myTableModel;
    private final DatabaseTableColumnsEditor myColumnsEditor;
    private final DatabaseTableKeysEditor myTableKeysEditor;
    private final DatabaseTableIndicesEditor myIndicesEditor;
    private final DatabaseTableForeignKeysEditor myForeignKeysEditor;
    private final List<TabProvider> myTabProviders;

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject exported) {
        if (exported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exported", "com/intellij/database/view/editors/DatabaseTableEditor", "startItemEditing"));
        }
        if (exported instanceof DeColumn) {
            this.myTabs.setSelectedComponent(this.myColumnsEditor.getComponent());
            return this.myColumnsEditor.startItemEditing((DeColumn)exported);
        }
        if (exported instanceof DeIndex) {
            this.myTabs.setSelectedComponent(this.myIndicesEditor.getComponent());
            return this.myIndicesEditor.startItemEditing((DeIndex)exported);
        }
        if (exported instanceof DeForeignKey) {
            this.myTabs.setSelectedComponent(this.myForeignKeysEditor.getComponent());
            return this.myForeignKeysEditor.startItemEditing((DeForeignKey)exported);
        }
        if (exported instanceof DeTableKey) {
            this.myTabs.setSelectedComponent(this.myTableKeysEditor.getComponent());
            return this.myTableKeysEditor.startItemEditing((DeTableKey)exported);
        }
        return null;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        JComponent tab = this.myTabs.getSelectedComponent();
        DatabaseEditorBaseEx res = null;
        if (tab == this.myColumnsEditor.getComponent()) {
            res = this.myColumnsEditor.getActiveEditor();
        } else if (tab == this.myIndicesEditor.getComponent()) {
            res = this.myIndicesEditor.getActiveEditor();
        } else if (tab == this.myForeignKeysEditor.getComponent()) {
            res = this.myForeignKeysEditor.getActiveEditor();
        } else if (tab == this.myTableKeysEditor.getComponent()) {
            res = this.myTableKeysEditor.getActiveEditor();
        }
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.chooseNotNull((Object)res, (Object)this);
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getActiveEditor"));
        }
        return databaseEditorBaseEx;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getCaps"));
        }
        return tableEditorCaps;
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        super(state);
        this.myTabProviders = ContainerUtil.newArrayList();
        this.myCaps = caps;
        this.myTableModel = tableModel;
        this.$$$setupUI$$$();
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(this.getContext(), this.myTableModel, this.myTableNameField);
        this.myCommentHolder.add((Component)commentBtn, "Center");
        this.myTableNameLabel.setLabelFor(this.myTableNameField);
        this.myColumnsEditor = new DatabaseTableColumnsEditor(this, this.myCaps);
        this.myTableKeysEditor = new DatabaseTableKeysEditor(this, this.myCaps);
        this.myIndicesEditor = new DatabaseTableIndicesEditor(this, this.myCaps);
        this.myForeignKeysEditor = new DatabaseTableForeignKeysEditor(this, this.myCaps);
        this.myTabProviders.add(this.myColumnsEditor);
        this.myTabProviders.add(this.myTableKeysEditor);
        this.myTabProviders.add(this.myIndicesEditor);
        this.myTabProviders.add(this.myForeignKeysEditor);
        this.applyCaps();
        for (JComponent c : ((JBTreeTraverser)((JBTreeTraverser)UIUtil.uiTraverser().withRoot((Object)this.myTabs.getComponent())).expandAndFilter(Conditions.not((Condition)Conditions.instanceOf(JTable.class)))).filter(JComponent.class)) {
            c.setFocusCycleRoot(false);
            c.setFocusTraversalPolicy(null);
        }
        this.initSubscriptions();
        this.updateFromModel();
    }

    protected void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myCommentPanel.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentLabel.setVisible(this.myCaps.getComment().isSupported());
        this.myTableNameField.setEnabled(this.myCaps.getRename().isAvailable());
        this.myColumnsEditor.setTabEnabled(this.myCaps.getColumns().isSupported());
        this.myIndicesEditor.setTabEnabled(this.myCaps.getIndices().isSupported());
        this.myForeignKeysEditor.setTabEnabled(this.myCaps.getForeignKeys().isSupported());
        this.refillTabs();
    }

    public void initSubscriptions() {
        this.myTableNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setName(DatabaseTableEditor.this.myTableNameField.getText());
                DatabaseTableEditor.this.myTableModel.commit();
            }
        });
        this.myCommentField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                String newVal = StringUtil.nullize((String)DatabaseTableEditor.this.myCommentField.getText());
                String oldVal = StringUtil.nullize((String)DatabaseTableEditor.this.myTableModel.getComment());
                if (Comparing.equal((String)oldVal, (String)newVal)) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setComment(newVal);
                DatabaseTableEditor.this.myTableModel.commit();
            }
        });
        this.myTableModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableEditor.this.updateUi();
            }
        }, this);
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getModel"));
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableEditor.setValue(this.myTableNameField, this.getTableModel().getName());
        DatabaseTableEditor.setValue((JTextField)this.myCommentField, StringUtil.notNullize((String)this.getTableModel().getComment()));
        this.myColumnsEditor.updateFromModel();
        this.myTableKeysEditor.updateFromModel();
        this.myIndicesEditor.updateFromModel();
        this.myForeignKeysEditor.updateFromModel();
        this.updateTabTitles();
    }

    protected void updateTabTitles() {
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            this.myTabs.setTitleAt(this.myTabs.indexOfComponent(provider.getComponent()), provider.getTabTitle());
        }
    }

    private void refillTabs() {
        JComponent prevComp = this.myTabs.getSelectedComponent();
        this.myTabs.removeAll();
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            JComponent comp = provider.getComponent();
            this.myTabs.addTab(provider.getTabTitle(), comp);
        }
        int index = this.myTabs.indexOfComponent(prevComp);
        if (index != -1) {
            this.myTabs.setSelectedIndex(index);
        }
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getPreferredFocusedComponent"));
        }
        return jTextField;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getComponent"));
        }
        return jPanel;
    }

    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.getTableModel().getName())) {
            return new ValidationInfo("'" + this.getTableModel().getName() + "' is not a valid table name", (JComponent)this.myTableNameField);
        }
        if (!this.getContext().getDialect().supportsEmptyTables() && this.getTableModel().getColumns().isEmpty()) {
            return new ValidationInfo("Empty table is not allowed", this.myColumnsEditor.getComponent());
        }
        return null;
    }

    private void createUIComponents() {
        this.myTabs = new TabbedPaneWrapper((Disposable)this);
        this.myTabsPanel = this.myTabs.getComponent();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTable"));
        }
        return deTable;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getNameEditor"));
        }
        return jTextField;
    }

    @NotNull
    public DatabaseTableColumnsEditor getColumnsEditor() {
        DatabaseTableColumnsEditor databaseTableColumnsEditor = this.myColumnsEditor;
        if (databaseTableColumnsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getColumnsEditor"));
        }
        return databaseTableColumnsEditor;
    }

    @NotNull
    public DatabaseTableIndicesEditor getIndicesEditor() {
        DatabaseTableIndicesEditor databaseTableIndicesEditor = this.myIndicesEditor;
        if (databaseTableIndicesEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getIndicesEditor"));
        }
        return databaseTableIndicesEditor;
    }

    @NotNull
    public DatabaseTableKeysEditor getKeysEditor() {
        DatabaseTableKeysEditor databaseTableKeysEditor = this.myTableKeysEditor;
        if (databaseTableKeysEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getKeysEditor"));
        }
        return databaseTableKeysEditor;
    }

    @NotNull
    public DatabaseTableForeignKeysEditor getForeignKeysEditor() {
        DatabaseTableForeignKeysEditor databaseTableForeignKeysEditor = this.myForeignKeysEditor;
        if (databaseTableForeignKeysEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getForeignKeysEditor"));
        }
        return databaseTableForeignKeysEditor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JBTextField jBTextField;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComponent jComponent = this.myTabsPanel;
        jPanel3.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTableNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Table:");
        jLabel2.setDisplayedMnemonic('B');
        jLabel2.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "East");
        this.myCommentField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, "Center");
        this.myCommentLabel = jLabel = new JLabel();
        jLabel.setText("Comment:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTableNameField = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static abstract class TabProvider {
        protected static final Border BORDER = IdeBorderFactory.createBorder((int)13);
        private boolean myTabEnabled = true;

        @NotNull
        public abstract JComponent getComponent();

        @NotNull
        public abstract String getTabTitle();

        void setTabEnabled(boolean enabled) {
            this.myTabEnabled = enabled;
        }

        boolean isTabEnabled() {
            return this.myTabEnabled;
        }
    }
}

