/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseForeignKeyEditor;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableForeignKeysEditor
extends DatabaseTableEditor.TabProvider {
    private final DatabaseEditorUtil.DbListTableWithEditor myTable;
    private ListTableModel<DatabaseForeignKeyEditor> myForeignKeysModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private JComponent myTablePanel;

    public DatabaseTableForeignKeysEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "<init>"));
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myForeignKeysModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseForeignKeyEditor>(){

            @Override
            @Nullable
            public DatabaseForeignKeyEditor createRow() {
                if (!DatabaseTableForeignKeysEditor.this.myCaps.getForeignKeys().canAdd()) {
                    return null;
                }
                DeForeignKey fk = DatabaseTableForeignKeysEditor.this.getTableModel().createForeignKey("", null, new DeForeignKey.Ref[0]);
                DatabaseTableForeignKeysEditor.this.getTableModel().addForeignKey(fk);
                return DatabaseTableForeignKeysEditor.this.createForeignKeyEditor(fk);
            }

            @Override
            public boolean removeRow(DatabaseForeignKeyEditor item, int idx) {
                if (!DatabaseTableForeignKeysEditor.this.myCaps.getForeignKeys().canRemove()) {
                    return false;
                }
                DeForeignKey fk = (DeForeignKey)((ObjectEditorModel)item.getModel()).getObject();
                DatabaseTableForeignKeysEditor.this.getTableModel().removeForeignKey(fk);
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, false);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myForeignKeysModel, this.myTableEditor, 15, JBUI.scale((int)500), null);
        this.myTable.getTable().getEmptyText().setText("No foreign keys");
        DatabaseEditorUtil.FlagUpdater foreignKeysAddable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getForeignKeys().canAdd());
        DatabaseEditorUtil.FlagUpdater foreignKeysRemovable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getForeignKeys().canRemove());
        DatabaseEditorUtil.FlagUpdater foreignKeysReorderable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getForeignKeys().canReorder());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setAddActionUpdater((AnActionButtonUpdater)foreignKeysAddable).setRemoveActionUpdater((AnActionButtonUpdater)foreignKeysRemovable).setMoveUpActionUpdater((AnActionButtonUpdater)foreignKeysReorderable).setMoveDownActionUpdater((AnActionButtonUpdater)foreignKeysReorderable);
        this.myTablePanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myTablePanel, (JTable)this.myTable.getTable());
        this.myTablePanel.setBorder(BORDER);
    }

    @Nullable
    public DatabaseForeignKeyEditor startItemEditing(@NotNull DeForeignKey fk) {
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "startItemEditing"));
        }
        return DatabaseEditorUtil.startItemEditing(fk, this.myTable, this.myForeignKeysModel);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTablePanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseForeignKeyEditor createForeignKeyEditor(@NotNull DeForeignKey fk) {
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "createForeignKeyEditor"));
        }
        DatabaseForeignKeyEditor editor = new DatabaseForeignKeyEditor(this.myTableEditor.getState(), this.getTableModel().modelsCache.get(fk, ForeignKeyEditorModel.class), this.myCaps.getForeignKeyCaps(fk.editedObject != null));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getForeignKeyModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableForeignKeysEditor.this.myTableEditor.updateUi();
            }
        }, this.myTableEditor);
        DatabaseForeignKeyEditor databaseForeignKeyEditor = editor;
        if (databaseForeignKeyEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "createForeignKeyEditor"));
        }
        return databaseForeignKeyEditor;
    }

    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myForeignKeysModel, this.getTableModel().getForeignKeys(), new Function<DeForeignKey, DatabaseForeignKeyEditor>(){

            public DatabaseForeignKeyEditor fun(DeForeignKey fk) {
                return DatabaseTableForeignKeysEditor.this.createForeignKeyEditor(fk);
            }
        });
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getTableModel().getForeignKeysCount();
        String string = "Foreign Keys" + (count == 0 ? "" : " (" + count + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getTabTitle"));
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseForeignKeyEditor> getForeignKeysListModel() {
        ListTableModel<DatabaseForeignKeyEditor> listTableModel = this.myForeignKeysModel;
        if (listTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getForeignKeysListModel"));
        }
        return listTableModel;
    }

    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myForeignKeysModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getForeignKeys();
        if (listCapability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableForeignKeysEditor", "getCaps"));
        }
        return listCapability;
    }
}

