/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedDasModel
implements DasModel {
    private final JBIterable<DasModel> myModels;
    private Function<DasObject, Iterable<? extends DasObject>> myTree;
    private static final Function<DasModel, Function<DasObject, Iterable<? extends DasObject>>> EXTRACT_TREE = new Function<DasModel, Function<DasObject, Iterable<? extends DasObject>>>(){

        public Function<DasObject, Iterable<? extends DasObject>> fun(DasModel model) {
            final Ref res = Ref.create();
            model.traverser().traverse(new TreeTraversal("extractTree"){

                @NotNull
                public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
                    if (roots == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/database/view/models/MergedDasModel$3$1", "createIterator"));
                    }
                    if (tree == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/database/view/models/MergedDasModel$3$1", "createIterator"));
                    }
                    res.set(tree);
                    TreeTraversal.It it = new TreeTraversal.It<T>(tree){

                        protected T nextImpl() {
                            return null;
                        }
                    };
                    if (it == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel$3$1", "createIterator"));
                    }
                    return it;
                }
            }).first();
            return (Function)res.get();
        }
    };
    public static final Function<DasModel, Iterable<? extends DasObject>> GET_MODEL_ROOTS = new Function<DasModel, Iterable<? extends DasObject>>(){

        public Iterable<? extends DasObject> fun(DasModel model) {
            return model.getModelRoots();
        }
    };
    public static final Function<DasModel, DasNamespace> GET_CURRENT_ROOT = new Function<DasModel, DasNamespace>(){

        public DasNamespace fun(DasModel model) {
            return model.getCurrentRoot();
        }
    };

    public MergedDasModel(@NotNull Iterable<? extends DasModel> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/MergedDasModel", "<init>"));
        }
        this.myModels = JBIterable.from((Iterable)ContainerUtil.newArrayList(models));
        this.myTree = MergedDasModel.buildTree(this.myModels);
    }

    @NotNull
    private static Function<DasObject, Iterable<? extends DasObject>> buildTree(@NotNull JBIterable<DasModel> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/MergedDasModel", "buildTree"));
        }
        final JBIterable treeFunctions = JBIterable.from((Iterable)models.transform(EXTRACT_TREE).toList());
        Function<DasObject, Iterable<? extends DasObject>> function = new Function<DasObject, Iterable<? extends DasObject>>(){

            public Iterable<? extends DasObject> fun(final DasObject object) {
                return MergedDasModel.merge(treeFunctions.transform((Function)new Function<Function<DasObject, Iterable<? extends DasObject>>, Iterable<? extends DasObject>>(){

                    public Iterable<? extends DasObject> fun(Function<DasObject, Iterable<? extends DasObject>> function) {
                        return (Iterable)function.fun((Object)object);
                    }
                }));
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "buildTree"));
        }
        return function;
    }

    @NotNull
    private static <T> Iterable<T> merge(@NotNull JBIterable<? extends Iterable<? extends T>> toMerge) {
        if (toMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMerge", "com/intellij/database/view/models/MergedDasModel", "merge"));
        }
        LinkedHashSet res = ContainerUtil.newLinkedHashSet();
        toMerge.flatten((Function)Functions.id()).addAllTo((Collection)res);
        LinkedHashSet linkedHashSet = res;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "merge"));
        }
        return linkedHashSet;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(MergedDasModel.merge(this.myModels.transform(GET_MODEL_ROOTS)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Nullable
    public DasNamespace getCurrentRoot() {
        return (DasNamespace)this.myModels.transform(GET_CURRENT_ROOT).filter(Conditions.notNull()).first();
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(this.myTree).withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(final DasTable table) {
        JBIterable jBIterable = JBIterable.from(MergedDasModel.merge(this.myModels.transform((Function)new Function<DasModel, Iterable<? extends DasConstraint>>(){

            public Iterable<? extends DasConstraint> fun(DasModel model) {
                return model.getExportedKeys(table);
            }
        })));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "getExportedKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/models/MergedDasModel", "getCasing"));
        }
        Casing casing = ((DasModel)ObjectUtils.assertNotNull((Object)this.myModels.first())).getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/MergedDasModel", "getCasing"));
        }
        return casing;
    }
}

