/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models.builder;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.build.DeBuilderBase;
import com.intellij.database.schemaEditor.model.build.DeForeignKeyBuilder;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForeignKeyModelBuilder<Self extends ForeignKeyModelBuilder<?>>
extends DeBuilderBase<Self>
implements DeForeignKeyBuilder<Self> {
    protected final ForeignKeyEditorModel myForeignKeyModel;

    protected ForeignKeyModelBuilder(@NotNull ForeignKeyEditorModel foreignKeyModel) {
        if (foreignKeyModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeyModel", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "<init>"));
        }
        this.myForeignKeyModel = foreignKeyModel;
    }

    @Override
    public Self setTarget(@Nullable DeTable target) {
        this.myForeignKeyModel.setTargetTable(target);
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    @Override
    public Self addRef(@Nullable DeColumn from, @Nullable DeColumn to) {
        DeTable table = this.myForeignKeyModel.getTable();
        this.myForeignKeyModel.setRefs(ContainerUtil.append(this.myForeignKeyModel.getRefs(), (Object[])new DeForeignKey.Ref[]{new DeForeignKey.Ref(EditorModelUtil.stubbize(from, table, table.model), EditorModelUtil.stubbize(to, table, table.model))}));
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    public Self addRefRefs(@NotNull Iterable<DeColumn> froms) {
        if (froms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "froms", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "addRefRefs"));
        }
        final DeTable table = this.myForeignKeyModel.getTable();
        this.myForeignKeyModel.setRefs(ContainerUtil.concat(this.myForeignKeyModel.getRefs(), (List)JBIterable.from(froms).transform((Function)new Function<DeColumn, DeForeignKey.Ref>(){

            public DeForeignKey.Ref fun(DeColumn column) {
                return new DeForeignKey.Ref(EditorModelUtil.stubbize(column, table, table.model), EditorModelUtil.stubbize((DeColumn)null, table, table.model));
            }
        }).toList()));
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    public Self addRefTargets(@NotNull Iterable<DeColumn> tos) {
        if (tos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tos", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "addRefTargets"));
        }
        final DeTable table = this.myForeignKeyModel.getTable();
        this.myForeignKeyModel.setRefs(ContainerUtil.concat(this.myForeignKeyModel.getRefs(), (List)JBIterable.from(tos).transform((Function)new Function<DeColumn, DeForeignKey.Ref>(){

            public DeForeignKey.Ref fun(DeColumn column) {
                return new DeForeignKey.Ref(EditorModelUtil.stubbize((DeColumn)null, table, table.model), EditorModelUtil.stubbize(column, table, table.model));
            }
        }).toList()));
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    @Override
    public Self setUpdateRule(@NotNull DasForeignKey.RuleAction rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "setUpdateRule"));
        }
        this.myForeignKeyModel.setUpdateRule(rule);
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    @Override
    public Self setDeleteRule(@NotNull DasForeignKey.RuleAction rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "setDeleteRule"));
        }
        this.myForeignKeyModel.setDeleteRule(rule);
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    @Override
    public Self setDeferrability(@NotNull DasForeignKey.Deferrability deferrability) {
        if (deferrability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deferrability", "com/intellij/database/view/models/builder/ForeignKeyModelBuilder", "setDeferrability"));
        }
        this.myForeignKeyModel.setDeferrability(deferrability);
        return (Self)((ForeignKeyModelBuilder)this.self());
    }

    public Self commit() {
        this.myForeignKeyModel.commit();
        return (Self)((ForeignKeyModelBuilder)this.self());
    }
}

