/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.util.Case;
import com.intellij.dbm.common.DBIntrospector;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionMode;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.CommonPreprocessor;
import com.intellij.sql.Evaluator;
import gnu.trove.TIntHashSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Version;

public abstract class BaseIntrospector<S extends DbmSchema, M extends DbmModel<?>>
implements DBIntrospector {
    protected static final Timestamp EPOCH = new Timestamp(0L);
    @NotNull
    protected final DBFacade myFacade;
    protected final boolean myConsiderSystemSchemasReinstrospection;
    protected M myModel;
    @NotNull
    protected IntrospectionOptions myOptions;
    @NotNull
    protected ProgressIndicator myProgressIndicator;
    @NotNull
    protected Version myServerVersion;
    protected boolean myInitialized;
    protected boolean myFull;
    protected boolean myFragmental;
    protected boolean myUseAccessibleNamespacesFromModel;

    protected BaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/BaseIntrospector", "<init>"));
        }
        this.myProgressIndicator = DumbProgressIndicator.INSTANCE;
        this.myServerVersion = Version.ZERO;
        this.myInitialized = false;
        this.myFull = false;
        this.myFragmental = false;
        this.myUseAccessibleNamespacesFromModel = false;
        this.myFacade = facade;
        this.myOptions = IntrospectionOptions.CURRENT_INC_OPTIONS;
        this.myConsiderSystemSchemasReinstrospection = BaseIntrospector.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    @Override
    public void init(@Nullable DbmModel model) {
        this.checkNotInitialized();
        if (model != null) {
            this.myModel = model;
            this.myOptions = this.prepareDefaultOptions(this.myModel);
            this.myFull = !this.myOptions.incremental && !this.myFragmental;
            this.myUseAccessibleNamespacesFromModel = this.myFragmental;
        } else {
            this.myModel = this.createNewModel();
            this.myOptions = IntrospectionOptions.CURRENT_FULL_OPTIONS;
            this.myFull = true;
            this.myUseAccessibleNamespacesFromModel = false;
        }
        this.myInitialized = true;
    }

    protected void checkNotInitialized() {
        if (this.myInitialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
    }

    @NotNull
    protected abstract M createNewModel();

    @NotNull
    public M getModel() {
        M m = this.myModel;
        assert (m != null) : "The introspector is not initialized yet: model is not created";
        M m2 = m;
        if (m2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseIntrospector", "getModel"));
        }
        return m2;
    }

    @NotNull
    protected IntrospectionOptions prepareDefaultOptions(@NotNull M model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/BaseIntrospector", "prepareDefaultOptions"));
        }
        boolean reasonableIncremental = false;
        for (DbmSchema schema : ((DbmModel)model).getAllSchemas()) {
            DbmSchema s = schema;
            if (!this.isPossibleToIntrospectSchemaIncrementally(s)) continue;
            reasonableIncremental = true;
        }
        IntrospectionOptions introspectionOptions = reasonableIncremental ? IntrospectionOptions.CURRENT_INC_OPTIONS : IntrospectionOptions.CURRENT_FULL_OPTIONS;
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseIntrospector", "prepareDefaultOptions"));
        }
        return introspectionOptions;
    }

    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull S schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector", "isPossibleToIntrospectSchemaIncrementally"));
        }
        return ((DbmSchema)schema).getIntrospectionTimestamp() != null;
    }

    @Override
    public void setOptions(@NotNull IntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/dbm/common/BaseIntrospector", "setOptions"));
        }
        assert (this.myInitialized) : "DBIntrospector is not initialized yet";
        this.myOptions = options;
        this.myServerVersion = this.myFacade.getConnectionInfo().serverVersion;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator != null ? progressIndicator : DumbProgressIndicator.INSTANCE;
    }

    protected void workWithModel(final @NotNull ModelWorker<M> worker) {
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/dbm/common/BaseIntrospector", "workWithModel"));
        }
        this.myProgressIndicator.checkCanceled();
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$1", "run"));
                }
                Object model = BaseIntrospector.this.getModel();
                ((DbmModel)model).startModifications();
                try {
                    worker.working(tran, model);
                }
                finally {
                    ((DbmModel)model).finishModifications();
                }
            }
        });
        this.myProgressIndicator.checkCanceled();
    }

    protected void postIntrospectionProcess() {
        this.workWithModel(new ModelWorker<M>(){

            @Override
            public void working(DBTransaction tran, M model) {
                BaseIntrospector.this.postIntrospectionProcess(model);
                for (DbmSchema schema : ((DbmModel)model).getAllSchemas()) {
                    schema.derefAll();
                }
            }
        });
    }

    protected void postIntrospectionProcess(M model) {
    }

    protected void updateStatus(@NotNull String status, @NotNull String details) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/dbm/common/BaseIntrospector", "updateStatus"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/dbm/common/BaseIntrospector", "updateStatus"));
        }
        this.myProgressIndicator.checkCanceled();
        this.myProgressIndicator.setText(status);
        this.myProgressIndicator.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
    }

    @Contract(value="null->false", pure=true)
    private static boolean stringToBoolean(@Nullable String str) {
        if (str == null) {
            return false;
        }
        String s = str.toLowerCase(Locale.ROOT);
        return s.equals("true") || s.equals("yes") || s.equals("1") || s.equals("+");
    }

    protected static void dropUnexistentObjects(Family<? extends DbmObject> family, TIntHashSet existentObjectIds) {
        if (family.isEmpty()) {
            return;
        }
        ImmutableList<? extends DbmObject> objects = family.asList();
        for (int i = objects.size() - 1; i >= 0; --i) {
            DbmObject object = (DbmObject)objects.get(i);
            int id = (int)object.getObjectId();
            if (existentObjectIds.contains(id)) continue;
            object.drop();
        }
    }

    protected static abstract class SchemaRetriever
    implements Evaluator {
        protected final S schema;
        protected final IntrospectionMode mode;
        @Deprecated
        protected final boolean incremental;
        @NotNull
        protected final Timestamp fromTimestamp;
        protected Timestamp introspectionBeginTimestamp;
        protected final Map<String, Object> myQueryParameters;
        protected final CommonPreprocessor myPreprocessor;
        final /* synthetic */ BaseIntrospector this$0;

        public SchemaRetriever(S schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "<init>"));
            }
            this.this$0 = this$0;
            this.myQueryParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.myPreprocessor = new CommonPreprocessor(true, this);
            this.schema = schema;
            switch (this$0.myOptions.mode) {
                case INCREMENT: {
                    this.mode = this$0.isPossibleToIntrospectSchemaIncrementally(schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
                    break;
                }
                case FRAGMENT: {
                    this.mode = IntrospectionMode.FRAGMENT;
                    break;
                }
                default: {
                    this.mode = IntrospectionMode.FULL;
                }
            }
            this.incremental = this.mode.increment;
            Date lastIntrospectionTimestamp = ((DbmSchema)schema).getIntrospectionTimestamp();
            this.fromTimestamp = this.mode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : EPOCH;
            this.setQueryParameter("SCHEMA_NAME", ((DbmObject)schema).getNameOrNull());
            this.setQueryParameter("SCHEMA_ID", ((DbmObject)schema).getObjectId() != 0L ? Long.valueOf(((DbmObject)schema).getObjectId()) : null);
            this.setQueryParameter(this$0.myOptions.mode.code, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        private void setQueryParameter(String name, Object value) {
            if (value != null) {
                this.myQueryParameters.put(name, value);
            } else {
                this.myQueryParameters.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "evaluate"));
            }
            return this.myQueryParameters.get(expression);
        }

        protected <R> R performQuery(@NotNull DBTransaction tran, @NotNull SqlQuery<R> query) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "performQuery"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "performQuery"));
            }
            SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.myPreprocessor);
            return (R)tran.query(preprocessedQuery).withParams(this.myPreprocessor.getBindableParameters()).run();
        }

        public void processPreliminaryPhase() {
            if (((DbmObject)this.schema).isDropped() || this.mode.fragment) {
                return;
            }
            this.work(new InTransactionNoResult(){

                public void run(@NotNull DBTransaction tran) {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$1", "run"));
                    }
                    SchemaRetriever.this.analyzeBriefInfo(tran);
                }
            });
            if (this.mode.increment) {
                this.work(new InTransactionNoResult(){

                    public void run(@NotNull DBTransaction tran) {
                        if (tran == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$2", "run"));
                        }
                        SchemaRetriever.this.analyzeCurrentContent(tran);
                    }
                });
            } else {
                this.work(new Runnable(){

                    @Override
                    public void run() {
                        SchemaRetriever.this.clearSchema();
                    }
                });
                this.work(new InTransactionNoResult(){

                    public void run(@NotNull DBTransaction tran) {
                        if (tran == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$4", "run"));
                        }
                        SchemaRetriever.this.retrieveMajorNames(tran);
                    }
                });
            }
        }

        public void processMainPhase() {
            if (((DbmObject)this.schema).isDropped()) {
                return;
            }
            this.this$0.myFacade.inTransaction(new InTransactionNoResult(){

                public void run(@NotNull DBTransaction tran) {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$5", "run"));
                    }
                    SchemaRetriever.this.retrieveMainContent(tran);
                }
            });
        }

        protected void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "work"));
            }
            ((DbmSchema)this.schema).model.startModifications();
            try {
                runnable.run();
            }
            finally {
                ((DbmSchema)this.schema).model.finishModifications();
            }
        }

        protected void work(@NotNull InTransactionNoResult block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "work"));
            }
            ((DbmSchema)this.schema).model.startModifications();
            try {
                this.this$0.myFacade.inTransaction(block);
            }
            finally {
                ((DbmSchema)this.schema).model.finishModifications();
            }
        }

        protected abstract void analyzeBriefInfo(@NotNull DBTransaction var1);

        protected abstract void analyzeCurrentContent(@NotNull DBTransaction var1);

        protected abstract void retrieveMajorNames(@NotNull DBTransaction var1);

        protected abstract void retrieveMainContent(@NotNull DBTransaction var1);

        protected void clearSchema() {
            for (Family family : ((DbmObject)this.schema).families()) {
                family.clear();
            }
        }
    }

    protected static interface ModelWorker<M extends DbmModel> {
        public void working(DBTransaction var1, M var2);
    }
}

