/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmDatabase
extends DbmNamespace
implements DasNamespace {
    protected final Family<? extends DbmSchema> mySchemas;
    @Nullable
    private DbmSchema myCurrentSchema;
    public static final Casing EXACT_CASING = Casing.create((Case)Case.EXACT, (Case)Case.EXACT);
    public static final Casing DEFAULT_CASING = Casing.create((Case)Case.MIXED, (Case)Case.EXACT);
    public static final Casing UNKNOWN_CASING = Casing.create((Case)Case.MIXED, (Case)Case.EXACT);

    protected DbmDatabase(@NotNull DbmModel model, @Nullable String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmDatabase", "<init>"));
        }
        super(model, name);
        this.mySchemas = Family.of(this, ObjectKind.SCHEMA);
        this.assignFamilies(this.mySchemas);
    }

    @NotNull
    public Family<? extends DbmSchema> schemas() {
        Family<? extends DbmSchema> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "schemas"));
        }
        return family;
    }

    @Override
    @Nullable
    public final DbmNamespace parent() {
        return null;
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.DATABASE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "kind"));
        }
        return objectKind;
    }

    @Override
    public boolean isCurrent() {
        return this.model.getCurrentRoot() == this;
    }

    @Override
    public void setObjectId(long newObjectId) {
        if (this.myObjectId == newObjectId) {
            return;
        }
        this.modifying();
        this.myObjectId = newObjectId;
    }

    @Override
    @NotNull
    public DbmSchema schema() {
        throw new IllegalStateException("A database cannot have a parent schema");
    }

    public boolean catalogNamesAreEqual(@NotNull String nameA, @NotNull String nameB) {
        if (nameA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameA", "com/intellij/dbm/common/DbmDatabase", "catalogNamesAreEqual"));
        }
        if (nameB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameB", "com/intellij/dbm/common/DbmDatabase", "catalogNamesAreEqual"));
        }
        return StringUtil.equals((CharSequence)nameA, (CharSequence)nameB);
    }

    @Nullable
    public DbmSchema getCurrentSchema() {
        return this.myCurrentSchema;
    }

    public void setCurrentSchema(@Nullable DbmSchema currentSchema) {
        if (currentSchema != null) {
            assert (currentSchema.database == this);
            assert (this.mySchemas.contains(currentSchema));
        }
        this.myCurrentSchema = currentSchema;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmDatabase", "getCasing"));
        }
        Casing casing = DEFAULT_CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getCasing"));
        }
        return casing;
    }
}

