/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmMultiDatabaseModel<DB extends DbmDatabase, S extends DbmSchema>
extends DbmModel<DB> {
    @Nullable
    private DB myCurrentDatabase;

    public DbmMultiDatabaseModel(@NotNull MetaModel<DbmObject> meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/common/DbmMultiDatabaseModel", "<init>"));
        }
        super(meta);
    }

    @NotNull
    public Family<DB> databases() {
        Family family = this.roots();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMultiDatabaseModel", "databases"));
        }
        return family;
    }

    @Override
    @Nullable
    public DB getCurrentRoot() {
        return this.myCurrentDatabase;
    }

    @Override
    public void setCurrentRoot(@Nullable DbmNamespace namespace) {
        if (namespace != null) {
            if (namespace.model != this) {
                throw new IllegalStateException("Attempt to set current schema from an alien model");
            }
            if (!(namespace instanceof DbmDatabase)) {
                throw new IllegalStateException("Attempt to set a wrong class object as a current schema");
            }
            this.myCurrentDatabase = (DbmDatabase)namespace;
        } else {
            this.myCurrentDatabase = null;
        }
    }

    @Nullable
    public DB getCurrentDatabase() {
        return this.myCurrentDatabase;
    }

    public void setCurrentDatabase(@Nullable DbmDatabase database) {
        if (database != null) {
            assert (database.model == this);
            assert (this.databases().contains(database));
        }
        this.myCurrentDatabase = database;
    }

    @Nullable
    public S getCurrentSchema() {
        DB db = this.getCurrentDatabase();
        if (db == null) {
            return null;
        }
        DbmSchema schema = ((DbmDatabase)db).getCurrentSchema();
        if (schema == null) {
            return null;
        }
        return (S)schema;
    }

    @Override
    @NotNull
    public final Iterable<S> getAllSchemas() {
        JBIterable jBIterable = DasUtil.getSchemas((DasModel)this);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMultiDatabaseModel", "getAllSchemas"));
        }
        return jBIterable;
    }
}

