/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DomOrderedObjectsRef<T extends DbmNamedObject>
extends DomObjectsRef<T> {
    public DomOrderedObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomOrderedObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomOrderedObjectsRef", "<init>"));
        }
        super(owner, resolver);
    }

    @Override
    public List<String> names() {
        return this.namesOrdered();
    }

    @Override
    public List<String> namesOrdered() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.size());
        this.retrieveNamesAsIs(names);
        return names;
    }

    @Override
    public List<T> resolveObjects() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList objects = new ArrayList(this.size());
        this.retrieveResolvedObjectsAsIs(objects);
        return objects;
    }
}

