/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.IntrospectionMode;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntrospectionOptions {
    @NotNull
    public final IntrospectionMode mode;
    @NotNull
    public final IntrospectionScope scope;
    @Nullable
    public final ObjectKind fragmentKind;
    @Nullable
    public final Set<String> fragmentNames;
    public final boolean incremental;
    public final boolean withSources;
    public final boolean withDependencies;
    public static final IntrospectionOptions CURRENT_INC_OPTIONS = new IntrospectionOptions(IntrospectionMode.INCREMENT, IntrospectionScopes.scopeOfCurrent(), false, false);
    public static final IntrospectionOptions CURRENT_FULL_OPTIONS = new IntrospectionOptions(IntrospectionMode.FULL, IntrospectionScopes.scopeOfCurrent(), false, false);

    @NotNull
    public static IntrospectionOptions of(@NotNull IntrospectionMode mode, @NotNull IntrospectionScope scope) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        IntrospectionOptions introspectionOptions = IntrospectionOptions.of(mode, scope, false, false);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions of(@NotNull IntrospectionMode mode, @NotNull IntrospectionScope scope, boolean withSources, boolean withDependencies) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(mode, scope, withSources, withDependencies);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions full(@NotNull IntrospectionScope configScope) {
        if (configScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configScope", "com/intellij/dbm/common/IntrospectionOptions", "full"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(IntrospectionMode.FULL, configScope, false, false);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "full"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions increment(@NotNull IntrospectionScope configScope) {
        if (configScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configScope", "com/intellij/dbm/common/IntrospectionOptions", "increment"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(IntrospectionMode.INCREMENT, configScope, false, false);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "increment"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions fragment(@NotNull String databaseName, @NotNull String schemaName, boolean withSources, @NotNull ObjectKind objectKind, @NotNull String objectName) {
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (schemaName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaName", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (objectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectName", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        IntrospectionScope scope = IntrospectionScopes.scopeOf(databaseName, schemaName);
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(scope, objectKind, (Set<String>)ImmutableSet.of((Object)objectName), withSources);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions fragment(@NotNull String databaseName, @NotNull String schemaName, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (schemaName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaName", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        if (objectNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectNames", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        IntrospectionScope scope = IntrospectionScopes.scopeOf(databaseName, schemaName);
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(scope, objectKind, (Set<String>)ImmutableSet.copyOf((Object[])objectNames), withSources);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "fragment"));
        }
        return introspectionOptions;
    }

    private IntrospectionOptions(@NotNull IntrospectionMode mode, @NotNull IntrospectionScope scope, boolean withSources, boolean withDependencies) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        assert (mode == IntrospectionMode.FULL || mode == IntrospectionMode.INCREMENT);
        this.mode = mode;
        this.scope = scope;
        this.fragmentKind = null;
        this.fragmentNames = null;
        this.incremental = mode == IntrospectionMode.INCREMENT;
        this.withSources = withSources;
        this.withDependencies = withDependencies;
    }

    public IntrospectionOptions(@NotNull IntrospectionScope scope, @NotNull ObjectKind fragmentKind, @NotNull Set<String> fragmentNames, boolean withSources) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        if (fragmentKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentKind", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        if (fragmentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentNames", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        this.mode = IntrospectionMode.FRAGMENT;
        this.scope = scope;
        this.fragmentKind = fragmentKind;
        this.fragmentNames = ImmutableSet.copyOf(fragmentNames);
        this.withSources = withSources;
        this.withDependencies = false;
        this.incremental = false;
    }

    public String toString() {
        return this.mode.name() + '|' + this.scope.toString();
    }
}

