/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;

public abstract class MultiDatabaseIntrospector<DB extends DbmDatabase, S extends DbmSchema, M extends DbmMultiDatabaseModel<DB, S>>
extends BaseIntrospector<S, M> {
    private static final Logger LOG = Logger.getInstance(MultiDatabaseIntrospector.class);
    @Nullable
    private Collection<String> myAccessibleDatabases;
    @NotNull
    private IntrospectionScope myConfigurationScope;
    @NotNull
    private IntrospectionScope mySeanceScope;
    @NotNull
    protected IntrospectionScope myWorkScope;
    @NotNull
    protected final List<BaseIntrospector.SchemaRetriever> myRetrievers;

    public MultiDatabaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/MultiDatabaseIntrospector", "<init>"));
        }
        super(facade);
        this.myConfigurationScope = IntrospectionScopes.scopeOfNothing();
        this.myWorkScope = IntrospectionScopes.scopeOfNothing();
        this.myRetrievers = new ArrayList<BaseIntrospector.SchemaRetriever>();
    }

    @Override
    public void setOptions(@NotNull IntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/dbm/common/MultiDatabaseIntrospector", "setOptions"));
        }
        super.setOptions(options);
        this.myConfigurationScope = options.scope;
        this.mySeanceScope = IntrospectionScopes.scopeOfAll();
    }

    @Override
    public void introspect() {
        this.processBriefPhase();
        this.produceRetrievers();
        this.processPreliminaryPhase();
        this.processMainPhase();
    }

    public void processBriefPhase() {
        this.retrieveSessionBriefInfo();
        this.matchScope();
        if (!this.myFragmental) {
            for (String databaseName : this.myWorkScope.databases()) {
                try {
                    this.introspectDatabaseBrief(databaseName);
                }
                catch (Exception e) {
                    LOG.warn(String.format("Failed to get brief info of the database %s: exception %s with message: %s", databaseName, e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }
        this.dropUnselectedNamespaces();
    }

    private void matchScope() {
        this.myConfigurationScope = this.expandScopeWithAccessibleDatabases(this.myConfigurationScope);
        DbmObject currentDatabase = this.myModel != null ? (DbmObject)((DbmMultiDatabaseModel)this.myModel).getCurrentDatabase() : null;
        String currentName = currentDatabase != null ? currentDatabase.getNameOrNull() : null;
        IntrospectionScope confScope = MultiDatabaseIntrospector.resolveCurrentDatabase(this.myConfigurationScope, currentName);
        IntrospectionScope seanceScope = MultiDatabaseIntrospector.resolveCurrentDatabase(this.mySeanceScope, currentName);
        this.myWorkScope = confScope.intersect(seanceScope);
    }

    @NotNull
    private static IntrospectionScope resolveCurrentDatabase(@NotNull IntrospectionScope scope, @Nullable String currentDatabaseName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/MultiDatabaseIntrospector", "resolveCurrentDatabase"));
        }
        IntrospectionScope introspectionScope = currentDatabaseName != null ? scope.resolveCurrentDatabase(currentDatabaseName) : scope.removeCurrentDatabase();
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/MultiDatabaseIntrospector", "resolveCurrentDatabase"));
        }
        return introspectionScope;
    }

    private IntrospectionScope expandScopeWithAccessibleDatabases(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/MultiDatabaseIntrospector", "expandScopeWithAccessibleDatabases"));
        }
        if (scope.containsDatabase("*")) {
            Set<String> schemasForEveryDB = scope.schemas("*");
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (String database : scope.databases()) {
                if (database.equals("*")) continue;
                TreeSet<String> schemas = new TreeSet<String>(scope.schemas(database));
                schemas.addAll(schemasForEveryDB);
                b.put((Object)database, (Object)ImmutableSet.copyOf(schemas));
            }
            return IntrospectionScopes.scopeOf((ImmutableMap<String, ImmutableSet<String>>)b.build());
        }
        return scope;
    }

    protected void produceRetrievers() {
        this.myRetrievers.clear();
        for (DbmDatabase database : ((DbmMultiDatabaseModel)this.myModel).databases()) {
            if (!MultiDatabaseIntrospector.inScope(database, this.myWorkScope)) continue;
            for (DbmSchema dbmSchema : database.schemas()) {
                if (!MultiDatabaseIntrospector.inScope(dbmSchema, this.myWorkScope)) continue;
                BaseIntrospector.SchemaRetriever retriever = this.createRetriever(dbmSchema);
                this.myRetrievers.add(retriever);
            }
        }
    }

    private static boolean inScope(DbmDatabase database, IntrospectionScope scope) {
        return scope.containsDatabase("*") || scope.containsDatabase("@") && database.isCurrent() || scope.containsDatabase(database.getName());
    }

    private static boolean inScope(DbmSchema schema, IntrospectionScope scope) {
        Set<String> schemaNames;
        String databaseName = schema.database.getName();
        String schemaName = schema.getName();
        if (scope.containsDatabase("*") && ((schemaNames = scope.schemas("*")).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName))) {
            return true;
        }
        if (scope.containsDatabase("@") && schema.database.isCurrent() && ((schemaNames = scope.schemas("@")).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName))) {
            return true;
        }
        return scope.containsDatabase(databaseName) && ((schemaNames = scope.schemas(databaseName)).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName));
    }

    @NotNull
    protected abstract BaseIntrospector.SchemaRetriever createRetriever(S var1);

    private void processPreliminaryPhase() {
        for (BaseIntrospector.SchemaRetriever retriever : this.myRetrievers) {
            retriever.processPreliminaryPhase();
        }
    }

    private void processMainPhase() {
        for (BaseIntrospector.SchemaRetriever retriever : this.myRetrievers) {
            retriever.processMainPhase();
        }
    }

    protected void introspectDatabaseBrief(final @NotNull String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        this.workWithModel(new BaseIntrospector.ModelWorker<M>(){

            @Override
            public void working(DBTransaction tran, M model) {
                MultiDatabaseIntrospector.this.introspectDatabaseBrief(tran, model, databaseName);
            }
        });
    }

    protected void introspectDatabaseBrief(@NotNull DBTransaction tran, @NotNull M model, @NotNull String databaseName) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (this.myUseAccessibleNamespacesFromModel) {
            return;
        }
        Set<String> schemaNames = this.myWorkScope.schemas(databaseName);
        if (schemaNames.isEmpty()) {
            LOG.debug(String.format("Looks like an introspection internal error: database %s has no configured schemas to introspect, or the introspector is not properly initialized", databaseName));
            return;
        }
        DbmDatabase database = (DbmDatabase)((DbmMultiDatabaseModel)model).databases().getOrCreate(databaseName);
        DbmSchema currentSchema = database.getCurrentSchema();
        String currentSchemaName = currentSchema != null ? currentSchema.getNameOrNull() : null;
        database.schemas().markChildrenAsSyncPending();
        Map<Integer, String> ss = this.listAccessibleSchemasOfDatabase(tran, database);
        boolean withCurrent = schemaNames.contains("@");
        boolean withAll = schemaNames.contains("*");
        for (Map.Entry<Integer, String> entry : ss.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int id = entry.getKey();
            String name = entry.getValue();
            if (!schemaNames.contains(name) && (!name.equals(currentSchemaName) || !withCurrent) && !withAll) continue;
            database.schemas().renew(id, name);
        }
    }

    protected abstract Collection<String> listAccessibleDatabases(@NotNull DBTransaction var1);

    protected abstract Map<Integer, String> listAccessibleSchemasOfDatabase(@NotNull DBTransaction var1, DbmDatabase var2);

    private void retrieveSessionBriefInfo() {
        this.updateStatus("Obtaining current info", "");
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector$2", "run"));
                }
                MultiDatabaseIntrospector.this.retrieveSessionBriefInfo(tran);
            }
        });
    }

    protected void retrieveSessionBriefInfo(DBTransaction tran) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropUnselectedNamespaces() {
        IntrospectionScope configurationScope = this.myConfigurationScope;
        LinkedList<DbmNamespace> namespacesToDrop = new LinkedList<DbmNamespace>();
        for (DbmDatabase db : ((DbmMultiDatabaseModel)this.myModel).databases()) {
            if (!MultiDatabaseIntrospector.inScope(db, configurationScope)) {
                namespacesToDrop.add(db);
                continue;
            }
            for (DbmSchema dbmSchema : db.schemas()) {
                if (MultiDatabaseIntrospector.inScope(dbmSchema, configurationScope)) continue;
                namespacesToDrop.add(dbmSchema);
            }
        }
        if (!namespacesToDrop.isEmpty()) {
            ((DbmMultiDatabaseModel)this.myModel).startModifications();
            try {
                Iterator iterator = namespacesToDrop.descendingIterator();
                while (iterator.hasNext()) {
                    DbmNamespace namespace = (DbmNamespace)iterator.next();
                    namespace.drop();
                }
            }
            finally {
                ((DbmMultiDatabaseModel)this.myModel).finishModifications();
            }
        }
    }
}

