/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.Family;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public abstract class RoutineUtil {
    public static String[] makeSpecItemsByInArguments(@NotNull Family<DbmArgument> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/dbm/common/RoutineUtil", "makeSpecItemsByInArguments"));
        }
        int n = arguments.size();
        int m = 0;
        String[] specItems = new String[n];
        for (int i = 0; i < n; ++i) {
            DbmArgument argument = arguments.get(i);
            DasArgument.Direction dir = argument.getDirection();
            if (!dir.isIn()) continue;
            DataType dataType = argument.getDataType();
            String specItem = dataType.custom && dataType.schemaName != null ? dataType.schemaName + '.' + dataType.typeName : dataType.typeName;
            specItems[m++] = specItem;
        }
        if (m == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (specItems.length == m) {
            return specItems;
        }
        String[] result = new String[m];
        System.arraycopy(specItems, 0, result, 0, m);
        return result;
    }

    public static void assignSpecItems(@NotNull Family<DbmArgument> arguments, String[] specItems) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/dbm/common/RoutineUtil", "assignSpecItems"));
        }
        if (arguments.isEmpty()) {
            int n = specItems.length;
            for (int i = 0; i < n; ++i) {
                String specItem = specItems[i];
                DbmArgument argument = arguments.create("$" + (i + 1));
                argument.setDataType(DataTypeFactory.of(specItem));
            }
        } else if (!RoutineUtil.checkSpecItemsAreEqual(arguments, specItems)) {
            throw new IllegalStateException("Specification items are already set and they differ with the given ones.");
        }
    }

    public static boolean checkSpecItemsAreEqual(@NotNull Family<DbmArgument> arguments, String[] specItems) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/dbm/common/RoutineUtil", "checkSpecItemsAreEqual"));
        }
        String[] theSpecItems = RoutineUtil.makeSpecItemsByInArguments(arguments);
        int n = theSpecItems.length;
        if (n != specItems.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (theSpecItems[i].equals(specItems[i])) continue;
            return false;
        }
        return true;
    }
}

