/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SequenceIdentity
implements Cloneable,
Serializable {
    @NotNull
    public final BigInteger min;
    @Nullable
    public final BigInteger next;
    @NotNull
    public final BigInteger increment;
    @Nullable
    public final BigInteger max;
    private static final Pattern SPECIFICATION_PATTERN = Pattern.compile("^\\s*([-+]?\\d+)\\s*(\\(\\s*([-+]?\\d+)\\s*\\)\\s*)?(([-+]\\d+)\\s*)?(\\.\\.([-+]?\\d+)\\s*)?$");

    @NotNull
    public static SequenceIdentity of(@NotNull String specification) {
        if (specification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/dbm/common/SequenceIdentity", "of"));
        }
        Matcher m = SPECIFICATION_PATTERN.matcher(specification);
        if (m.matches()) {
            SequenceIdentity sequenceIdentity = SequenceIdentity.of(SequenceIdentity.grp(m, 1), SequenceIdentity.grp(m, 3), SequenceIdentity.grp(m, 5), SequenceIdentity.grp(m, 7));
            if (sequenceIdentity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/SequenceIdentity", "of"));
            }
            return sequenceIdentity;
        }
        throw new IllegalArgumentException("The string '" + specification + "' is not a valid sequence specification");
    }

    private static BigInteger grp(Matcher matcher, int groupNr) {
        String groupString = matcher.group(groupNr);
        return groupString != null ? new BigInteger(groupString) : null;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable Long min, @Nullable Long next, @Nullable Long increment, @Nullable Long max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min == null ? null : BigInteger.valueOf(min), next == null ? null : BigInteger.valueOf(next), increment == null ? null : BigInteger.valueOf(increment), max == null ? null : BigInteger.valueOf(max));
        if (sequenceIdentity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/SequenceIdentity", "of"));
        }
        return sequenceIdentity;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min, next, increment, max);
        if (sequenceIdentity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/SequenceIdentity", "of"));
        }
        return sequenceIdentity;
    }

    private SequenceIdentity(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        this.min = min == null ? BigInteger.ONE : min;
        this.next = next;
        this.increment = increment == null ? BigInteger.ONE : increment;
        this.max = max;
    }

    public final String getSpecification() {
        StringBuilder b = new StringBuilder(16);
        b.append(this.min);
        if (this.next != null) {
            b.append('(').append(this.next).append(')');
        }
        if (!this.increment.equals(BigInteger.ONE)) {
            b.append(this.increment.signum() >= 0 ? "+" : "").append(this.increment);
        }
        if (this.max != null) {
            b.append('.').append('.').append(this.max);
        }
        return b.toString();
    }

    public String toString() {
        return this.getSpecification();
    }

    protected Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceIdentity state = (SequenceIdentity)o;
        if (!this.min.equals(state.min)) {
            return false;
        }
        if (this.next != null ? !this.next.equals(state.next) : state.next != null) {
            return false;
        }
        if (!this.increment.equals(state.increment)) {
            return false;
        }
        return !(this.max != null ? !this.max.equals(state.max) : state.max != null);
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.min.hashCode() + (this.next != null ? this.next.hashCode() : 0)) + this.increment.hashCode()) + (this.max != null ? this.max.hashCode() : 0);
    }
}

