/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.mssql.MsSchema;
import com.intellij.dbm.mssql.MsType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDatabase
extends DbmDatabase {
    private final ConcurrentMap<Long, DbmObject> myObjectsById;
    private final ConcurrentMap<Integer, MsType> myTypesById;
    @StateProperty
    @Nullable
    public String myCollation;
    private transient boolean myNamingCaseSensitive;
    private static final Pattern CASE_SENSITIVE_COLLATION_PATTERN = Pattern.compile("^.*\\w+_(CS(_[_\\w]+)?|BIN\\d?)$", 2);

    public MsDatabase(@NotNull DbmModel model, @Nullable String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/mssql/MsDatabase", "<init>"));
        }
        super(model, name);
        this.myObjectsById = new ConcurrentHashMap<Long, DbmObject>();
        this.myTypesById = new ConcurrentHashMap<Integer, MsType>();
    }

    @NotNull
    public Family<MsSchema> schemas() {
        Family family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsDatabase", "schemas"));
        }
        return family;
    }

    void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        if (oldId != 0L) {
            this.myObjectsById.remove(oldId, object);
        }
        if (newId != 0L) {
            this.myObjectsById.put(newId, object);
        }
    }

    void justTypeIdChanged(MsType object, int oldId, int newId) {
        if (oldId != 0) {
            this.myTypesById.remove(oldId, object);
        }
        if (newId != 0) {
            this.myTypesById.put(newId, object);
        }
    }

    @Nullable
    public DbmObject getObjectById(int id) {
        Long theId = id;
        return (DbmObject)this.myObjectsById.get(theId);
    }

    @Nullable
    public DbmObject getObjectById(long id) {
        return (DbmObject)this.myObjectsById.get(id);
    }

    @Nullable
    public <T> T getObjectById(@NotNull Class<T> objectClass, long id) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/mssql/MsDatabase", "getObjectById"));
        }
        DbmObject object = this.getObjectById(id);
        if (object == null) {
            return null;
        }
        return (T)(objectClass.isAssignableFrom(object.getClass()) ? object : null);
    }

    @Nullable
    public MsType getTypeById(int typeId) {
        return (MsType)this.myTypesById.get(typeId);
    }

    @NotNull
    Set<Long> allObjectIds() {
        Set<Long> set = this.myObjectsById.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsDatabase", "allObjectIds"));
        }
        return set;
    }

    public boolean isNamingCaseSensitive() {
        return this.myNamingCaseSensitive;
    }

    @Nullable
    public String getCollation() {
        return this.myCollation;
    }

    public void setCollation(@Nullable String collation) {
        if (StringUtil.equalsIgnoreCase((CharSequence)this.myCollation, (CharSequence)collation)) {
            return;
        }
        this.modifying();
        this.myCollation = collation;
        this.myNamingCaseSensitive = MsDatabase.isCollationCaseSensitive(collation);
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/mssql/MsDatabase", "getCasing"));
        }
        Casing casing = this.isNamingCaseSensitive() ? EXACT_CASING : DEFAULT_CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsDatabase", "getCasing"));
        }
        return casing;
    }

    static boolean isCollationCaseSensitive(@Nullable String collation) {
        return collation != null && CASE_SENSITIVE_COLLATION_PATTERN.matcher(collation).matches();
    }
}

