/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

final class MsIntroQueries {
    static final MsIntroQueries QUERIES = new MsIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(MsIntroQueries.class);
    final SqlQuery<CurrentSessionInfo> queryCurrentSessionInfo = this.myScriptum.query("QueryCurrentSessionInfo", Layouts.rowOf((RowLayout)Layouts.structOf(CurrentSessionInfo.class)));
    final SqlQuery<List<String>> listDatabaseNames = this.myScriptum.query("ListDatabaseNames", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<String>> listSchemaNames = this.myScriptum.query("ListSchemaNames", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<SortedMap<Integer, String>> retrieveSchemas = this.myScriptum.query("RetrieveSchemas", Layouts.sortedMapOf(Integer.class, String.class));
    final SqlQuery<int[]> listExistentObjects = this.myScriptum.query("ListExistentObjects", Layouts.columnOfInts((int)4096));
    final SqlQuery<SortedMap<Byte, Long>> calculateCustomTypesCheckSums = this.myScriptum.query("CalculateCustomTypesCheckSums", Layouts.sortedMapOf(Byte.class, Long.class));
    final SqlQuery<List<OneAliasType>> retrieveAliasTypes = this.myScriptum.query("RetrieveAliasTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneAliasType.class)));
    final SqlQuery<List<OneTableType>> retrieveTableTypes = this.myScriptum.query("RetrieveTableTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneTableType.class)));
    final SqlQuery<List<OneObject>> retrieveObjects = this.myScriptum.query("RetrieveObjects", Layouts.listOf((RowLayout)Layouts.structOf(OneObject.class)));
    final SqlQuery<List<OneColumn>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneColumn>> retrieveTypeColumns = this.myScriptum.query("RetrieveTypeColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneIndex>> retrieveTypeIndices = this.myScriptum.query("RetrieveTypeIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneIndexColumn>> retrieveIndexColumns = this.myScriptum.query("RetrieveIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexColumn.class)));
    final SqlQuery<List<OneIndexColumn>> retrieveTypeIndexColumns = this.myScriptum.query("RetrieveTypeIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexColumn.class)));
    final SqlQuery<List<OneKey>> retrieveKeys = this.myScriptum.query("RetrieveKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneKey>> retrieveTypeKeys = this.myScriptum.query("RetrieveTypeKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneCheckConstraints>> retrieveCheckConstraints = this.myScriptum.query("RetrieveCheckConstraints", Layouts.listOf((RowLayout)Layouts.structOf(OneCheckConstraints.class)));
    final SqlQuery<List<OneCheckConstraints>> retrieveTypeCheckConstraints = this.myScriptum.query("RetrieveTypeCheckConstraints", Layouts.listOf((RowLayout)Layouts.structOf(OneCheckConstraints.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeys = this.myScriptum.query("RetrieveForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneForeignKeyColumn>> retrieveForeignKeyColumns = this.myScriptum.query("RetrieveForeignKeyColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKeyColumn.class)));
    final SqlQuery<List<OneArguments>> retrieveArguments = this.myScriptum.query("RetrieveArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneArguments.class)));
    final SqlQuery<List<OneSynonym>> retrieveSynonyms = this.myScriptum.query("RetrieveSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<OneDescription>> retrieveDescriptions = this.myScriptum.query("RetrieveDescriptions", Layouts.listOf((RowLayout)Layouts.structOf(OneDescription.class)));
    final SqlQuery<Map<Integer, String>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.hashMapOf(Integer.class, String.class));

    MsIntroQueries() {
    }

    static final class OneDescription {
        int object_id;
        short item_position;
        String description;

        OneDescription() {
        }
    }

    static final class OneSynonym {
        long object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;
        String origin_db_name;
        String origin_schema_name;
        String origin_object_name;
        long origin_id;
        String base_object_name;

        OneSynonym() {
        }
    }

    static final class OneArguments {
        int object_id;
        String name;
        String type_name;
        int max_length;
        int precision;
        byte scale;
        boolean is_output;
        boolean is_cursor_ref;
        boolean has_default_value;

        OneArguments() {
        }
    }

    static final class OneForeignKeyColumn {
        int constraint_id;
        String domestic_column_name;
        String reference_column_name;

        OneForeignKeyColumn() {
        }
    }

    static final class OneForeignKey {
        int table_id;
        int constraint_id;
        String name;
        boolean is_system_named;
        boolean is_disabled;
        int referenced_object_id;
        int key_index_id;
        byte update_referential_action;
        byte delete_referential_action;
        Timestamp create_date;
        Timestamp modify_date;

        OneForeignKey() {
        }
    }

    static final class OneCheckConstraints {
        int table_id;
        int constraint_id;
        String name;
        boolean is_system_named;
        String column_name;
        String definition;
        Timestamp create_date;
        Timestamp modify_date;

        OneCheckConstraints() {
        }
    }

    static final class OneKey {
        int table_id;
        int key_id;
        short index_position;
        String name;
        boolean is_primary;
        boolean is_system_named;
        Timestamp create_date;
        Timestamp modify_date;

        OneKey() {
        }
    }

    static final class OneIndexColumn {
        int object_id;
        short index_position;
        String name;
        boolean is_desc;

        OneIndexColumn() {
        }
    }

    static final class OneIndex {
        int object_id;
        short position;
        String name;
        byte type;
        boolean is_unique;
        boolean is_disabled;

        OneIndex() {
        }
    }

    static final class OneColumn {
        int object_id;
        short column_position;
        String name;
        String type_name;
        int max_length;
        int precision;
        byte scale;
        String collation_name;
        boolean is_nullable;
        boolean is_computed;
        Long identity_seed_value;
        Long identity_increment_value;
        Long identity_last_value;
        String default_expression;

        OneColumn() {
        }
    }

    static final class OneObject {
        int object_id;
        String name;
        String type;
        Timestamp create_date;
        Timestamp modify_date;
        boolean is_ms_shipped;

        OneObject() {
        }
    }

    static final class OneTableType {
        int type_id;
        int object_id;
        String name;
        Timestamp create_date;
        Timestamp modify_date;

        OneTableType() {
        }
    }

    static final class OneAliasType {
        int type_id;
        String name;
        String base_name;
        int max_length;
        int precision;
        byte scale;
        boolean is_nullable;

        OneAliasType() {
        }
    }

    static final class CurrentSessionInfo {
        int db_id;
        String db_name;
        int schema_id;
        String schema_name;
        String collation_name;

        CurrentSessionInfo() {
        }
    }
}

