/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.LengthUnit;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmError;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmInnerRoutine;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.dbm.common.TableOrganization;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraCollectionType;
import com.intellij.dbm.oracle.OraIntroQueries;
import com.intellij.dbm.oracle.OraModel;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraModuleAttribute;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.dbm.oracle.OraRevEngUtils;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.dbm.oracle.OraTable;
import com.intellij.dbm.oracle.OraView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.Version;

public class OraIntrospector
extends BaseIntrospector<OraSchema, OraModel> {
    private static final Set<String> SYSTEM_SCHEMAS = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object)"SYS").add((Object)"SYSTEM").add((Object)"CTXSYS").build();
    @NotNull
    private final OraIntroQueries myQueries;
    @NotNull
    private static final Logger LOG = Logger.getInstance(OraIntrospector.class);
    private boolean myUseFastWay;
    @NotNull
    private Version myOracleVersion;
    private final LinkedHashSet<String> myIntrospectingSchemaNames;
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");

    public OraIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/oracle/OraIntrospector", "<init>"));
        }
        super(facade);
        this.myUseFastWay = false;
        this.myOracleVersion = Version.of((int[])new int[]{0});
        this.myIntrospectingSchemaNames = new LinkedHashSet();
        this.myQueries = OraIntroQueries.QUERIES;
    }

    @Override
    @NotNull
    protected IntrospectionOptions prepareDefaultOptions(@NotNull OraModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/oracle/OraIntrospector", "prepareDefaultOptions"));
        }
        if (model.schemas().isNotEmpty()) {
            ArrayList<String> schemaNames = new ArrayList<String>();
            schemaNames.add("@");
            schemaNames.addAll(model.schemas().getNames());
            IntrospectionOptions introspectionOptions = IntrospectionOptions.increment(IntrospectionScopes.scopeOf("@", schemaNames));
            if (introspectionOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "prepareDefaultOptions"));
            }
            return introspectionOptions;
        }
        IntrospectionOptions introspectionOptions = IntrospectionOptions.full(IntrospectionScopes.scopeOfCurrent());
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "prepareDefaultOptions"));
        }
        return introspectionOptions;
    }

    @Override
    @NotNull
    protected OraModel createNewModel() {
        OraModel oraModel = new OraModel();
        if (oraModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "createNewModel"));
        }
        return oraModel;
    }

    @Override
    public void introspect() {
        if (!this.myInitialized) {
            throw new IllegalStateException("OraIntrospector is not initialized yet.");
        }
        this.introspectDatabaseAndSchemas();
        this.introspectAllSchemasObjects();
        this.postIntrospectionProcess();
    }

    private void introspectDatabaseAndSchemas() {
        this.workWithModel(new BaseIntrospector.ModelWorker<OraModel>(){

            @Override
            public void working(DBTransaction tran, OraModel model) {
                OraIntrospector.this.checkFastWayPossibility(tran);
                OraIntrospector.this.introspectDatabaseAndSchemas(tran, model);
            }
        });
    }

    /*
     * Loose catch block
     */
    private void checkFastWayPossibility(DBTransaction tran) {
        try {
            this.myUseFastWay = (Boolean)tran.query(this.myQueries.checkBaseDictionariesAccess).run();
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
        }
        catch (NoTableOrViewException ntv) {
            this.myUseFastWay = false;
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
        }
        catch (Exception e) {
            LOG.warn("An unexpected exception when checking access to the base dictionary: " + e.getMessage(), (Throwable)e);
            this.myUseFastWay = false;
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
            {
                catch (Throwable throwable) {
                    LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
                    throw throwable;
                }
            }
        }
    }

    private void introspectDatabaseAndSchemas(DBTransaction tran, OraModel model) {
        OraIntroQueries.OneSessionInfo si = (OraIntroQueries.OneSessionInfo)tran.query(this.myQueries.retrieveSessionInfo).run();
        Family schemas = model.schemas();
        schemas.markChildrenAsSyncPending();
        if (si.current_schema != null) {
            OraSchema currentSchema = (OraSchema)schemas.getOrCreate(si.current_schema);
            model.setCurrentSchema(currentSchema);
        }
        if (si.oracle_version != null) {
            try {
                this.myOracleVersion = Version.of((String)si.oracle_version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myIntrospectingSchemaNames.clear();
        for (String s : this.myOptions.scope.allSchemas()) {
            if (s.equals("@")) {
                if (si.current_schema != null) {
                    this.myIntrospectingSchemaNames.add(si.current_schema);
                }
                if (si.current_user == null) continue;
                this.myIntrospectingSchemaNames.add(si.current_user);
                continue;
            }
            if (s.equals("*")) {
                Collection schemaNames = (Collection)tran.query(this.myQueries.retrieveAccessibleSchemas).run();
                this.myIntrospectingSchemaNames.addAll(schemaNames);
                continue;
            }
            this.myIntrospectingSchemaNames.add(s);
        }
        for (String schemaName : this.myIntrospectingSchemaNames) {
            schemas.getOrCreate(schemaName);
        }
        schemas.removeSyncPendingChildren();
        schemas.reorder();
    }

    private void introspectAllSchemasObjects() {
        for (String schemaName : this.myIntrospectingSchemaNames) {
            this.introspectOneSchemaObjects(schemaName);
        }
    }

    private void introspectOneSchemaObjects(String schemaName) {
        final OraSchema schema = (OraSchema)((OraModel)this.myModel).schemas().getOrCreate(schemaName);
        final OraSchemaRetriever retriever = new OraSchemaRetriever(schema);
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$2", "run"));
                }
                if (!schema.isPublic()) {
                    retriever.retrieveMain(tran);
                } else {
                    retriever.retrievePublic(tran);
                }
            }
        });
    }

    @Override
    protected void postIntrospectionProcess(OraModel model) {
        for (DbmSchema schema : model.schemas()) {
            schema.derefAll();
        }
    }

    @NotNull
    @Contract(pure=true)
    static String unquoteNameIfPossible(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        return string;
    }

    private static DataType makeDataType(@Nullable String schemaName, @Nullable String typeName, int precision, int scale, @Nullable String units) {
        DataType type;
        if (typeName == null) {
            type = DataType.UNKNOWN;
        } else if (typeName.contains("(")) {
            type = DataTypeFactory.of(typeName);
        } else {
            boolean explicitUnits = (typeName.equalsIgnoreCase("varchar") || typeName.equalsIgnoreCase("char")) && units != null && units.equalsIgnoreCase("C");
            type = schemaName == null ? DataTypeFactory.of(null, typeName, precision, scale, LengthUnit.of((String)units), null, explicitUnits, false) : DataTypeFactory.of(schemaName, typeName, -1, 0, null, null, false, true);
        }
        return type;
    }

    private static void makeArgument(@NotNull DbmRoutine routine, String argName, char argDirection, String dataTypeSchemaName, String dataTypeSpec) {
        DbmArgument argument;
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/oracle/OraIntrospector", "makeArgument"));
        }
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == DasArgument.Direction.RETURN) {
            argument = routine.getOrCreateReturnArgument();
            argument.setName(argName);
        } else if (argName != null) {
            argument = routine.arguments().getOrCreate(argName);
            argument.setDirection(dir);
        } else {
            return;
        }
        DataType type = DataTypeFactory.of(dataTypeSchemaName, dataTypeSpec, -1, 0, null, null, false, dataTypeSchemaName != null);
        argument.setDataType(type);
    }

    private static void applySources(@NotNull OraSchema schema, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
        DbmSourceAware sa;
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceText", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText.length() == 0) {
            return;
        }
        DbmSourceAware dbmSourceAware = type.equals("TYPE") ? (DbmSourceAware)schema.objectTypes().getOrCreate(name) : (type.equals("TYPE BODY") ? schema.objectTypes().getOrCreate(name).getOrCreateBody() : (type.equals("PACKAGE") ? (DbmSourceAware)schema.packages().getOrCreate(name) : (type.equals("PACKAGE BODY") ? schema.packages().getOrCreate(name).getOrCreateBody() : (sa = type.equals("FUNCTION") || type.equals("PROCEDURE") ? (DbmSourceAware)schema.routines().getOrCreate(name) : null))));
        if (sa == null) {
            return;
        }
        sa.setSourceText(sourceText);
    }

    private final class OraSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        @NotNull
        private final Timestamp fromTimestamp;
        private Timestamp myBeginTimestamp;
        boolean affectsTables;
        boolean affectsViews;
        boolean affectsTriggers;
        boolean affectsSingleRoutines;
        boolean affectsModulesOrBodies;
        boolean toStop;
        private final Set<DbmLikeTable> myTablesToReorderDetails;
        private final Set<OraModule> myAffectedModules;
        private final Set<DbmObject> myAffectedDepObjects;

        OraSchemaRetriever(OraSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "<init>"));
            }
            super((BaseIntrospector)OraIntrospector.this, (DbmSchema)schema);
            this.toStop = false;
            this.myTablesToReorderDetails = new HashSet<DbmLikeTable>();
            this.myAffectedModules = new HashSet<OraModule>();
            this.myAffectedDepObjects = new HashSet<DbmObject>();
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : EPOCH;
        }

        @Override
        protected void analyzeBriefInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "analyzeBriefInfo"));
            }
        }

        @Override
        protected void analyzeCurrentContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "analyzeCurrentContent"));
            }
        }

        @Override
        protected void retrieveMajorNames(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMajorNames"));
            }
        }

        @Override
        protected void retrieveMainContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMainContent"));
            }
            this.retrieveMain(tran);
        }

        void retrieveMain(final @NotNull DBTransaction tran) {
            boolean skipSystemSchema;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMain"));
            }
            boolean bl = skipSystemSchema = this.mode.increment && SYSTEM_SCHEMAS.contains(((OraSchema)this.schema).getName()) && !OraIntrospector.this.myConsiderSystemSchemasReinstrospection && !((OraSchema)this.schema).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            this.myBeginTimestamp = (Timestamp)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.askForTimeNow).run();
            assert (this.myBeginTimestamp != null) : "Failed to obtain the current timestamp from the database";
            this.reportRetrieving("schema information");
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveSchemaInfo(tran);
                }
            });
            if (this.toStop) {
                return;
            }
            if (this.mode.increment) {
                this.reportRetrieving("detect dropped objects");
                this.detectAndRemoveDroppedObjects(tran);
            } else {
                this.clearSchema();
            }
            Date modifiedTimestamp = ((OraSchema)this.schema).getModifiedTimestamp();
            boolean bl2 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.fromTimestamp);
            if (this.toStop) {
                return;
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveSequences(tran);
                    OraSchemaRetriever.this.retrieveObjectTypes(tran);
                    OraSchemaRetriever.this.retrieveCollectionTypes(tran);
                    OraSchemaRetriever.this.retrieveObjectTypeAttributes(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveTables(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveViews(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveColumns(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveColumnDefaults(tran);
                    OraSchemaRetriever.this.retrieveColumnComments(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveIndices(tran);
                    OraSchemaRetriever.this.retrieveIndicesColumns(tran);
                    OraSchemaRetriever.this.retrieveKeys(tran);
                    OraSchemaRetriever.this.retrieveForeignKeys(tran);
                    OraSchemaRetriever.this.retrieveChecks(tran);
                    OraSchemaRetriever.this.retrieveConstraintColumns(tran);
                    OraSchemaRetriever.this.reorderTableDetails();
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveTriggers(tran);
                    OraSchemaRetriever.this.retrievePackages(tran);
                    OraSchemaRetriever.this.retrieveInnerRoutines(tran);
                    OraSchemaRetriever.this.retrieveInnerRoutinesArguments(tran);
                    OraSchemaRetriever.this.retrieveSingleRoutines(tran);
                    OraSchemaRetriever.this.retrieveSingleRoutinesArguments(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveSynonyms(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveDependencies(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveViewSources(tran);
                    OraSchemaRetriever.this.retrieveSources(tran);
                    OraSchemaRetriever.this.retrieveErrors(tran);
                }
            });
            this.reportRetrieving("finishing the schema...");
            long stateNumber = 0L;
            ((OraSchema)this.schema).setIntrospectionActualPoint(stateNumber, this.myBeginTimestamp);
        }

        void retrievePublic(final @NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrievePublic"));
            }
            this.myBeginTimestamp = (Timestamp)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.askForTimeNow).run();
            assert (this.myBeginTimestamp != null) : "Failed to obtain the current timestamp from the database";
            this.reportRetrieving("schema information");
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveSchemaInfo(tran);
                }
            });
            if (this.toStop) {
                return;
            }
            if (this.mode.increment) {
                this.reportRetrieving("detect dropped objects");
                this.detectAndRemoveDroppedObjects(tran);
            } else {
                this.clearSchema();
            }
            Date modifiedTimestamp = ((OraSchema)this.schema).getModifiedTimestamp();
            boolean bl = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.fromTimestamp);
            if (this.toStop) {
                return;
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    OraSchemaRetriever.this.retrieveSynonyms(tran);
                }
            });
            this.reportRetrieving("finishing the schema...");
            long stateNumber = 0L;
            ((OraSchema)this.schema).setIntrospectionActualPoint(stateNumber, this.myBeginTimestamp);
        }

        @Override
        protected void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "work"));
            }
            OraIntrospector.this.myProgressIndicator.checkCanceled();
            super.work(runnable);
        }

        private void detectAndRemoveDroppedObjects(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "detectAndRemoveDroppedObjects"));
            }
            long schemaId = ((OraSchema)this.schema).getObjectId();
            boolean schemaIdKnown = schemaId > 0L || schemaId == 0L && ((OraSchema)this.schema).isName("SYS");
            long[] identifierArray = null;
            if (OraIntrospector.this.myUseFastWay && schemaIdKnown) {
                try {
                    identifierArray = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectIdentifiersFast);
                }
                catch (NoTableOrViewException nte) {
                    OraIntrospector.this.myUseFastWay = false;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception when trying fast object listing: " + e.getMessage() + "\nSwitching to the SLOW Database Catalog accessing");
                    OraIntrospector.this.myUseFastWay = false;
                }
            }
            if (identifierArray == null) {
                identifierArray = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectIdentifiersSlow);
            }
            final TLongHashSet identifiers = new TLongHashSet(identifierArray);
            ((OraSchema)this.schema).traversBreadthFirst(DbmObject.class, new Processor<DbmObject>(){

                public boolean process(DbmObject object) {
                    long id = object.getObjectId();
                    if (id == 0L || identifiers.contains(id) || object instanceof DbmNamespace) {
                        return true;
                    }
                    object.drop();
                    return false;
                }
            });
        }

        @Override
        protected void clearSchema() {
            final ArrayList children = new ArrayList();
            ((OraSchema)this.schema).traverseChildren(DbmObject.class, new Consumer<DbmObject>(){

                public void consume(DbmObject object) {
                    children.add(object);
                }
            });
            for (int i = children.size() - 1; i >= 0; --i) {
                ((DbmObject)children.get(i)).drop();
            }
            ((OraSchema)this.schema).setCreatedAndModifiedTimestamps(null, null);
            ((OraSchema)this.schema).setIntrospectionActualPoint(0L, null);
        }

        @Nullable
        private DbmLikeTable getTableOrViewById(long id) {
            DbmLikeTable table = ((OraSchema)this.schema).tables().getByObjectId(id);
            if (table == null) {
                table = ((OraSchema)this.schema).views().getByObjectId(id);
            }
            if (table == null) {
                table = ((OraSchema)this.schema).matViews().getByObjectId(id);
            }
            return table;
        }

        private void retrieveSchemaInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSchemaInfo"));
            }
            OraIntroQueries.OneSchemaInfo info = this.performQuery(tran, ((OraSchema)this.schema).isPublic() ? ((OraIntrospector)OraIntrospector.this).myQueries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSchemaInfo);
            ((OraSchema)this.schema).setObjectId(info.user_id);
            ((OraSchema)this.schema).setCreatedAndModifiedTimestamps(info.created_timestamp, info.modified_timestamp);
            this.myQueryParameters.put("SCHEMA_ID", info.user_id);
        }

        private void retrieveSequences(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSequences"));
            }
            this.reportRetrieving("Sequences");
            List<OraIntroQueries.OneSequence> seqs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSequences);
            if (seqs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSequence seq : seqs) {
                OraSequence sequence = ((OraSchema)this.schema).sequences().getOrCreate(seq.sequence_name);
                sequence.setMinValue(this.adjustBigIntegerForSequence(seq.min_value));
                sequence.setMaxValue(this.adjustBigIntegerForSequence(seq.max_value));
                sequence.setIncrementBy(seq.increment_by);
                sequence.setOrdered(seq.order_flag);
                sequence.setCycled(seq.cycle_flag);
                sequence.setCacheSize(seq.cache_size);
                sequence.setNextValue(this.adjustBigIntegerForSequence(seq.last_number));
                sequence.setObjectId(seq.object_id);
                sequence.setCreatedAndModifiedTimestamps(seq.created_timestamp, seq.modified_timestamp);
            }
            ((OraSchema)this.schema).sequences().reorder();
        }

        @Nullable
        private BigInteger adjustBigIntegerForSequence(@Nullable BigDecimal bigDecimalValue) {
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            return bi.toString().equals("9999999999999999999999999999") ? null : bi;
        }

        private void retrieveObjectTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveObjectTypes"));
            }
            this.reportRetrieving("Object Types");
            List<OraIntroQueries.OneObjectType> ots = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypes);
            if (ots.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneObjectType ot : ots) {
                OraObjectType superObjectType = null;
                if (ot.supertype_schema_name != null && ot.supertype_name != null) {
                    OraSchema superSchema = (OraSchema)((OraModel)OraIntrospector.this.myModel).schemas().getOrCreate(ot.supertype_schema_name);
                    superObjectType = superSchema.myObjectTypes.getOrCreate(ot.supertype_name);
                }
                OraObjectType oType = ((OraSchema)this.schema).myObjectTypes.renew(ot.object_id, ot.type_name);
                oType.superObject.setObject(superObjectType);
                oType.setCreatedAndModifiedTimestamps(ot.created_timestamp, ot.modified_timestamp);
                this.myAffectedDepObjects.add(oType);
                this.myAffectedModules.add(oType);
            }
            ((OraSchema)this.schema).myObjectTypes.reorder();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveCollectionTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveCollectionTypes"));
            }
            if (!OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11})) {
                return;
            }
            this.reportRetrieving("Collection Types");
            List<OraIntroQueries.OneCollectionType> cts = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveCollectionTypes);
            if (cts.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneCollectionType ct : cts) {
                OraCollectionType cType = ((OraSchema)this.schema).myCollectionTypes.getOrCreate(ct.type_name);
                cType.setArray(ct.collection_kind == 'A');
                cType.setUpperBound(ct.upper_bound);
                DataType type = OraIntrospector.makeDataType(ct.data_type_schema_name, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                cType.setElementType(type);
                cType.setCreatedAndModifiedTimestamps(ct.created_timestamp, ct.modified_timestamp);
            }
            ((OraSchema)this.schema).myCollectionTypes.reorder();
        }

        private void retrieveObjectTypeAttributes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveObjectTypeAttributes"));
            }
            this.reportRetrieving("Object Type Attributes");
            List<OraIntroQueries.OneObjectTypeAttribute> attrs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypeAttributes);
            for (OraIntroQueries.OneObjectTypeAttribute ota : attrs) {
                OraObjectType ot = ((OraSchema)this.schema).myObjectTypes.getOrCreate(ota.type_name);
                OraModuleAttribute attr = ot.attributes().getOrCreate(ota.attr_name);
                DataType type = OraIntrospector.makeDataType(ota.data_type_schema, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                attr.setType(type);
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveTables"));
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{10}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTables10 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTables09;
            List<OraIntroQueries.OneTable> tabs = this.performQuery(tran, query);
            if (tabs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneTable tab : tabs) {
                OraTable table = ((OraSchema)this.schema).tables().renew(tab.object_id, tab.table_name);
                table.setComment(tab.comments);
                table.setOrganization(TableOrganization.byCode(tab.organization_kind));
                table.setCreatedAndModifiedTimestamps(tab.created_timestamp, tab.modified_timestamp);
                if (tab.row_type_name != null) {
                    table.setRowObjectType(tab.row_type_schema_name, tab.row_type_name);
                } else if (this.mode.increment) {
                    table.setRowObjectType(null);
                }
                table.checks().clear();
                table.foreignKeys().clear();
                table.keys().clear();
                this.myAffectedDepObjects.add(table);
            }
            ((OraSchema)this.schema).tables().reorder();
            this.affectsTables = true;
        }

        private void retrieveViews(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveViews"));
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViews11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViews10;
            List<OraIntroQueries.OneView> vs = this.performQuery(tran, query);
            if (vs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneView v : vs) {
                OraView view = ((OraSchema)this.schema).views().getOrCreate(v.view_name);
                view.setComment(v.comments);
                view.setModifiable(v.modifiable);
                view.setObjectId(v.object_id);
                view.setInvalid(v.is_invalid);
                view.setCreatedAndModifiedTimestamps(v.created_timestamp, v.modified_timestamp);
                view.checks().clear();
                view.foreignKeys().clear();
                view.keys().clear();
                this.myAffectedDepObjects.add(view);
            }
            this.affectsViews = true;
        }

        private void retrieveColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumns"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(((OraSchema)this.schema).tables().size() + ((OraSchema)this.schema).views().size());
            DbmLikeTable table = null;
            long table_id = Long.MIN_VALUE;
            int columnIndex = 0;
            List<OraIntroQueries.OneColumn> cols = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumns);
            for (OraIntroQueries.OneColumn col : cols) {
                if (col.table_id != table_id) {
                    table = this.getTableOrViewById(col.table_id);
                    if (table == null) continue;
                    table_id = col.table_id;
                    columnIndex = 0;
                    table.columns().markChildrenAsSyncPending();
                    affectedTables.add(table);
                }
                assert (table != null);
                Family<? extends DbmColumn> tableColumns = table.columns();
                DbmColumn column = tableColumns.getOrCreate(col.column_name);
                column.resetSyncPending();
                tableColumns.move(column, columnIndex);
                columnIndex = (short)(columnIndex + 1);
                DataType type = OraIntrospector.makeDataType(col.data_type_schema_name, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                column.setDataType(type);
                column.setMandatory(col.mandatory);
                if (col.default_expression != null) {
                    col.default_expression = col.default_expression.trim();
                    if (col.default_expression.isEmpty()) {
                        col.default_expression = null;
                    }
                }
                column.setDefaultExpression(col.default_expression);
            }
            if (((OraIntrospector)OraIntrospector.this).myOptions.incremental) {
                for (DbmLikeTable affectedTable : affectedTables) {
                    ImmutableList<? extends DbmColumn> columns = affectedTable.columns().asList();
                    for (int i = columns.size() - 1; i >= 0; --i) {
                        DbmColumn column = (DbmColumn)columns.get(i);
                        if (!column.isSyncPending()) continue;
                        column.drop();
                    }
                }
            }
            this.myTablesToReorderDetails.addAll(affectedTables);
        }

        private void retrieveColumnDefaults(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumnDefaults"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            List<OraIntroQueries.OneColumnDefault> rows = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnDefaults);
            for (OraIntroQueries.OneColumnDefault col : rows) {
                DbmColumn column;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(col.table_name);
                if (table == null || (column = table.columns().get(col.column_name)) == null) continue;
                column.setDefaultExpression(col.default_expression);
            }
        }

        private void retrieveColumnComments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumnComments"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Column Comments");
            List<OraIntroQueries.OneColumnComment> rows = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnComments);
            for (OraIntroQueries.OneColumnComment col : rows) {
                DbmColumn column;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(col.table_name);
                if (table == null || (column = table.columns().get(col.column_name)) == null) continue;
                column.setComment(col.comments);
            }
        }

        private void retrieveIndices(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveIndices"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Indices");
            List<OraIntroQueries.OneIndex> indices = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndices);
            if (indices.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneIndex ind : indices) {
                OraTable table = ((OraSchema)this.schema).tables().getOrCreate(ind.table_name);
                DbmIndex index = table.indices().getOrCreate(ind.index_name);
                index.setNameSurrogate(OraRevEngUtils.matches(ind.index_name, OraRevEngUtils.surrogateNamePattern));
                index.setUnique(ind.uniqueness);
                index.setClustering(ind.clustering);
                index.setTablespaceName(ind.tablespace_name);
                index.setObjectId(ind.object_id);
                index.setCreatedAndModifiedTimestamps(ind.created_timestamp, ind.modified_timestamp);
                if (this.mode.fragment) {
                    index.myColumns.clearState();
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveIndicesColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveIndicesColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List<OraIntroQueries.OneIndexColumn> ics = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndicesColumns);
            for (OraIntroQueries.OneIndexColumn ic : ics) {
                String columnName;
                OraTable table = ((OraSchema)this.schema).tables().getOrCreate(ic.table_name);
                DbmIndex index = table.indices().getOrCreate(ic.index_name);
                if (ic.column_position == 1) {
                    index.clearColumnsList();
                }
                String string = columnName = ic.column_expression == null ? ic.column_name : OraIntrospector.unquoteNameIfPossible(ic.column_expression);
                if (ic.column_name != null) {
                    DasIndex.Sorting sorting = ic.descendant ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.ASCENDING;
                    index.addColumn(columnName, sorting);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Keys");
            List<OraIntroQueries.OneKey> keys = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveKeys);
            for (OraIntroQueries.OneKey k : keys) {
                if (k.table_name == null || k.constraint_name == null) continue;
                OraTable table = ((OraSchema)this.schema).tables().getOrCreate(k.table_name);
                DbmKey key = table.keys().getOrCreate(k.constraint_name);
                key.myColumns.clearState();
                key.setNameSurrogate(k.is_surrogate_name);
                key.setPrimary(k.is_pk);
                key.setDeferrable(k.is_deferrable);
                key.setInitiallyDeferred(k.is_initially_deferred);
                key.setModifiedTimestamp(k.modified_timestamp);
                DbmIndex index = k.index_name != null ? table.indices().getOrCreate(k.index_name) : null;
                key.setUnderlyingIndex(index);
            }
        }

        private void retrieveForeignKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveForeignKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            List<OraIntroQueries.OneForeignKey> fks = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveForeignKeys);
            for (OraIntroQueries.OneForeignKey fk : fks) {
                OraTable table = ((OraSchema)this.schema).tables().getOrCreate(fk.table_name);
                DbmForeignKey fkey = table.foreignKeys().getOrCreate(fk.constraint_name);
                fkey.myColumns.clearState();
                fkey.refKey.set(fk.ref_schema_name, fk.ref_key_name);
                fkey.setNameSurrogate(fk.is_surrogate_name);
                fkey.setDeferrable(fk.is_deferrable);
                fkey.setInitiallyDeferred(fk.is_initially_deferred);
                fkey.setCascadeDeleteRule(fk.cascade_delete ? CascadeRule.delete : CascadeRule.restrict);
                fkey.setModifiedTimestamp(fk.modified_timestamp);
            }
        }

        private void retrieveChecks(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveChecks"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            List<OraIntroQueries.OneCheck> cks = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveChecks);
            for (OraIntroQueries.OneCheck ck : cks) {
                if (ck.predicate == null || ck.is_surrogate_name && AUTO_NOT_NULL_CHECK_PATTERN.matcher(ck.predicate).matches()) continue;
                OraTable table = ((OraSchema)this.schema).tables().getOrCreate(ck.table_name);
                DbmCheck check = table.checks().getOrCreate(ck.constraint_name);
                check.myColumns.clearState();
                check.setNameSurrogate(ck.is_surrogate_name);
                check.setPredicate(ck.predicate);
                check.setModifiedTimestamp(ck.modified_timestamp);
                this.myAffectedDepObjects.add((DbmObject)check.getTable());
            }
        }

        private void retrieveConstraintColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveConstraintColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List<OraIntroQueries.OneConstraintColumn> ccs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveConstraintColumns);
            if (ccs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                DbmConstraint constraint;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(cc.table_name);
                if (table == null || (constraint = table.getConstraint(cc.constraint_name)) == null) continue;
                if (cc.column_name != null) {
                    constraint.myColumns.add(cc.column_name);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void reorderTableDetails() {
            for (DbmLikeTable table : this.myTablesToReorderDetails) {
                table.indices().reorder();
                table.keys().reorder();
                table.foreignKeys().reorder();
                table.checks().reorder();
            }
        }

        private void retrieveTriggers(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveTriggers"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Triggers");
            List<OraIntroQueries.OneTrigger> trigs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggers);
            if (trigs.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> tables = new HashSet<DbmLikeTable>(trigs.size());
            boolean also_retrieve_update_columns = false;
            for (OraIntroQueries.OneTrigger oneTrigger : trigs) {
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(oneTrigger.table_name);
                if (table == null) continue;
                DbmTrigger trigger = table.triggers().getOrCreate(oneTrigger.trigger_name);
                trigger.trigColumns.clearState();
                trigger.trigEvents.set(oneTrigger.events);
                trigger.setTrigTurn(this.trigTurnOf(oneTrigger.turn));
                also_retrieve_update_columns |= oneTrigger.has_on_update_columns;
                trigger.setCreatedAndModifiedTimestamps(oneTrigger.created_timestamp, oneTrigger.modified_timestamp);
                tables.add(table);
            }
            if (also_retrieve_update_columns) {
                List<String[]> cols = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggerUpdateColumns);
                for (String[] col : cols) {
                    DbmTrigger trigger;
                    DbmLikeTable table;
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null || (table = ((OraSchema)this.schema).getTableOrView(tableName)) == null || (trigger = table.triggers().get(triggerName)) == null) continue;
                    trigger.trigColumns.add(columnName);
                }
            }
            for (DbmLikeTable dbmLikeTable : tables) {
                dbmLikeTable.triggers().reorder();
            }
            this.myAffectedDepObjects.addAll(tables);
            this.affectsTriggers = true;
        }

        @Nullable
        private TrigTurn trigTurnOf(short turn) {
            switch (turn) {
                case -2: {
                    return TrigTurn.BEFORE_STMT;
                }
                case -1: {
                    return TrigTurn.BEFORE_ROW;
                }
                case 1: {
                    return TrigTurn.AFTER_ROW;
                }
                case 2: {
                    return TrigTurn.AFTER_STMT;
                }
                case 0: {
                    return TrigTurn.INSTEAD_OF;
                }
            }
            return null;
        }

        private void retrievePackages(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrievePackages"));
            }
            this.reportRetrieving("Packages");
            List<OraIntroQueries.OnePackage> packs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrievePackages);
            if (packs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OnePackage p : packs) {
                OraBody body;
                if (!p.is_body) {
                    OraPackage pack = ((OraSchema)this.schema).packages().renew(p.object_id, p.package_name);
                    pack.setObjectId(p.object_id);
                    pack.setInvalid(p.is_invalid);
                    pack.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                    this.myAffectedModules.add(pack);
                    this.myAffectedDepObjects.add(pack);
                    continue;
                }
                DbmObject objectWithThisId = ((OraModel)OraIntrospector.this.myModel).getObjectById(p.object_id);
                if (objectWithThisId != null && objectWithThisId instanceof OraBody) {
                    body = (OraBody)objectWithThisId;
                    body.setName(p.package_name);
                } else {
                    OraPackage pack = ((OraSchema)this.schema).packages().getOrCreate(p.package_name);
                    body = pack.getOrCreateBody();
                    body.setObjectId(p.object_id);
                    body.setName(p.package_name);
                }
                body.setInvalid(p.is_invalid);
                body.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                this.myAffectedDepObjects.add(body);
            }
            ((OraSchema)this.schema).packages().reorder();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveInnerRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveInnerRoutines"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            for (OraModule module : this.myAffectedModules) {
                module.routines().markChildrenAsSyncPending();
            }
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutines11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutines10;
            List<OraIntroQueries.OneInnerRoutine> routines = this.performQuery(tran, query);
            for (OraIntroQueries.OneInnerRoutine r : routines) {
                OraModule module = null;
                if (r.module_kind == 'T' || r.module_kind == 'Z') {
                    module = ((OraSchema)this.schema).objectTypes().get(r.module_name);
                }
                if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                    module = ((OraSchema)this.schema).packages().get(r.module_name);
                }
                if (module == null) continue;
                DbmInnerRoutine routine = module.routines().getOrCreate(r.routine_name);
                if (routine.getRoutineKind() == DasRoutine.Kind.NONE) {
                    routine.setRoutineKind(DasRoutine.Kind.PROCEDURE);
                }
                routine.setDeterministic(r.is_deterministic);
            }
            for (OraModule module : this.myAffectedModules) {
                module.routines().removeSyncPendingChildren();
            }
        }

        private void retrieveInnerRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveInnerRoutinesArguments"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> arguments11 = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutineArguments11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutineArguments10;
            List<OraIntroQueries.OneInnerRoutineArgument> args = this.performQuery(tran, arguments11);
            for (OraIntroQueries.OneInnerRoutineArgument a : args) {
                DbmInnerRoutine routine;
                OraModule m;
                if (a.package_name == null || a.routine_name == null || (m = ((OraSchema)this.schema).getModule(a.package_name)) == null || (routine = m.routines().get(a.routine_name)) == null) continue;
                OraIntrospector.makeArgument(routine, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveSingleRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSingleRoutines"));
            }
            this.reportRetrieving("Procedures and functions");
            List<OraIntroQueries.OneSingleRoutine> routines = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutines);
            if (routines.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSingleRoutine r : routines) {
                DbmSingleRoutine routine = ((OraSchema)this.schema).routines().getOrCreate(r.name);
                routine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                routine.setObjectId(r.object_id);
                routine.setInvalid(r.is_invalid);
                routine.setDeterministic(r.is_deterministic);
                routine.setCreatedAndModifiedTimestamps(r.created_timestamp, r.modified_timestamp);
                this.myAffectedDepObjects.add(routine);
            }
            ((OraSchema)this.schema).routines().reorder();
            this.affectsSingleRoutines = true;
        }

        private void retrieveSingleRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSingleRoutinesArguments"));
            }
            if (!this.affectsSingleRoutines) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutineArguments11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutineArguments10;
            List<OraIntroQueries.OneSingleRoutineArgument> args = this.performQuery(tran, query);
            for (OraIntroQueries.OneSingleRoutineArgument a : args) {
                DbmSingleRoutine routine;
                if (a.routine_name == null || (routine = ((OraSchema)this.schema).routines().get(a.routine_name)) == null) continue;
                OraIntrospector.makeArgument(routine, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveSynonyms(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSynonyms"));
            }
            this.reportRetrieving("Synonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSynonyms);
            for (OraIntroQueries.OneSynonym s : ss) {
                DbmSynonym synonym = ((OraSchema)this.schema).synonyms().getOrCreate(s.synonym_name);
                synonym.setObjectId(s.object_id);
                synonym.setCreatedAndModifiedTimestamps(s.created_timestamp, s.modified_timestamp);
                String[] originPath = s.origin_db_link != null ? new String[]{s.origin_db_link, s.origin_schema_name, s.origin_object_name} : (s.origin_schema_name != null && !s.origin_schema_name.equals(((OraSchema)this.schema).getName()) ? new String[]{s.origin_schema_name, s.origin_object_name} : new String[]{s.origin_object_name});
                synonym.origin.set(originPath);
            }
        }

        private void retrieveDependencies(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveDependencies"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withDependencies) {
                return;
            }
            if (this.myAffectedDepObjects.isEmpty()) {
                return;
            }
            this.reportRetrieving("Dependencies");
            long[][] ds = this.performQuery(tran, OraIntrospector.this.myUseFastWay ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveDependenciesFast : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveDependenciesSlow);
            if (ds.length == 0) {
                return;
            }
            HashSet<DbmRef<DbmObject>> myNewRefs = new HashSet<DbmRef<DbmObject>>(ds.length);
            for (long[] d : ds) {
                assert (d.length == 2);
                long sourceId = d[0];
                long targetId = d[1];
                DbmObject sourceObject = ((OraModel)OraIntrospector.this.myModel).getObjectById(sourceId);
                DbmObject targetObject = ((OraModel)OraIntrospector.this.myModel).getObjectById(targetId);
                if (sourceObject == null || targetObject == null) continue;
                DbmRef<DbmObject> ref = sourceObject.internalDependencies().add(targetObject);
                if (!this.mode.increment) continue;
                myNewRefs.add(ref);
            }
            if (this.mode.increment) {
                Object object = this.myAffectedDepObjects.iterator();
                while (object.hasNext()) {
                    DbmObject object2 = (DbmObject)object.next();
                    for (DbmRef<DbmObject> ref : object2.internalDependencies().getAllRefs()) {
                        if (myNewRefs.contains(ref)) continue;
                        ref.drop();
                    }
                }
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveViewSources"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withSources) {
                return;
            }
            if (!this.affectsViews) {
                return;
            }
            this.reportRetrieving("View Sources");
            List<OraIntroQueries.OneViewSource> views = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViewSources);
            for (OraIntroQueries.OneViewSource v : views) {
                DbmView view = ((OraSchema)this.schema).views().getOrCreate(v.view_name);
                view.setSourceText(v.text);
            }
        }

        private void retrieveSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSources"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withSources) {
                return;
            }
            if (!(this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers)) {
                return;
            }
            this.reportRetrieving("Procedures and Functions Sources");
            List<OraIntroQueries.OneSrcLine> lines = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSources);
            String theType = "";
            String theName = "";
            StringBuilder buf = new StringBuilder();
            for (OraIntroQueries.OneSrcLine line : lines) {
                boolean theSame;
                boolean bl = theSame = theType.equals(line.type) && theName.equals(line.name);
                if (!theSame) {
                    OraIntrospector.applySources((OraSchema)this.schema, theType, theName, buf.toString());
                    theType = line.type;
                    theName = line.name;
                    buf.delete(0, buf.length());
                }
                buf.append(line.text);
            }
            OraIntrospector.applySources((OraSchema)this.schema, theType, theName, buf.toString());
        }

        private void retrieveErrors(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveErrors"));
            }
            if (!(this.affectsViews || this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers)) {
                return;
            }
            this.reportRetrieving("Statuses and Errors");
            List<OraIntroQueries.OneError> errs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveErrors);
            if (errs.isEmpty()) {
                return;
            }
            MultiMap map = new MultiMap();
            for (OraIntroQueries.OneError err : errs) {
                DbmSourceAware src = null;
                switch (err.type_code) {
                    case 'R': {
                        src = ((OraSchema)this.schema).routines().get(err.name);
                        break;
                    }
                    case 'V': {
                        src = ((OraSchema)this.schema).views().get(err.name);
                        break;
                    }
                    case 'T': {
                        OraModule m = ((OraSchema)this.schema).objectTypes().get(err.name);
                        if (m == null) break;
                        src = err.is_body ? (DbmSourceAware)m.bodies().firstIfExists() : m;
                        break;
                    }
                    case 'P': {
                        OraModule p = ((OraSchema)this.schema).packages().get(err.name);
                        if (p == null) break;
                        DbmSourceAware dbmSourceAware = src = err.is_body ? (DbmSourceAware)p.bodies().firstIfExists() : p;
                    }
                }
                if (src == null) continue;
                DbmError error = DbmError.of(err.line, err.position, err.message);
                map.putValue((Object)src, (Object)error);
            }
            for (Map.Entry entry : map.entrySet()) {
                ((DbmSourceAware)entry.getKey()).setErrors((List<DbmError>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            }
        }

        private void reportRetrieving(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "reportRetrieving"));
            }
            String modeStr = this.mode.increment ? "incrementally" : "completely";
            OraIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", ((OraSchema)this.schema).getName(), modeStr), what);
        }
    }
}

