/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmError;
import com.intellij.dbm.common.DbmInnerRoutine;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraModuleAttribute;
import com.intellij.dbm.oracle.OraSchema;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OraModule
extends DbmComplex
implements DbmSourceAware {
    final Family<OraBody> myBodies;
    final Family<OraModuleAttribute> myAttribute;
    final Family<DbmInnerRoutine> myRoutines;
    @Nullable
    private String mySourceText;
    @StateProperty
    public boolean myInvalid;
    @NotNull
    private List<DbmError> myErrors;

    @NotNull
    public Family<OraBody> bodies() {
        Family<OraBody> family = this.myBodies;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModule", "bodies"));
        }
        return family;
    }

    @NotNull
    public Family<OraModuleAttribute> attributes() {
        Family<OraModuleAttribute> family = this.myAttribute;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModule", "attributes"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmInnerRoutine> routines() {
        Family<DbmInnerRoutine> family = this.myRoutines;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModule", "routines"));
        }
        return family;
    }

    protected OraModule(@NotNull OraSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraModule", "<init>"));
        }
        super(schema, name);
        this.myBodies = Family.of(this, ObjectKind.BODY);
        this.myAttribute = Family.of(this, ObjectKind.OBJECT_ATTRIBUTE);
        this.myRoutines = Family.of(this, ObjectKind.ROUTINE);
        this.myErrors = NO_ERRORS;
        this.assignFamilies(this.myBodies, this.myAttribute, this.myRoutines);
    }

    @Nullable
    public OraBody getBody() {
        return this.myBodies.isNotEmpty() ? this.myBodies.first() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public OraBody getOrCreateBody() {
        if (this.myBodies.isEmpty()) {
            this.modifying();
            Family<OraBody> family = this.myBodies;
            synchronized (family) {
                if (this.myBodies.isEmpty()) {
                    this.myBodies.create(this.getName());
                }
            }
        }
        assert (this.myBodies.isNotEmpty());
        OraBody oraBody = this.myBodies.first();
        if (oraBody == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModule", "getOrCreateBody"));
        }
        return oraBody;
    }

    @Override
    protected void nameIsChanged(@Nullable String oldName, @Nullable String newName) {
        super.nameIsChanged(oldName, newName);
        OraBody body = this.getBody();
        if (body != null) {
            body.setName(newName);
        }
    }

    @Override
    @Nullable
    public String getSourceText() {
        return this.mySourceText;
    }

    @Override
    public void setSourceText(@Nullable String sourceText) {
        this.mySourceText = sourceText;
    }

    @Override
    public boolean isInvalid() {
        return this.myInvalid;
    }

    @Override
    public void setInvalid(boolean invalid) {
        this.myInvalid = invalid;
    }

    @Override
    @NotNull
    public List<DbmError> getErrors() {
        List<DbmError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraModule", "getErrors"));
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<DbmError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/dbm/oracle/OraModule", "setErrors"));
        }
        boolean bad = !errors.isEmpty();
        this.myErrors = bad ? ImmutableList.copyOf(errors) : NO_ERRORS;
    }
}

