/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.RoutineUtil;
import com.intellij.dbm.common.StateProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresRoutine
extends DbmSingleRoutine
implements DbmOverloadable {
    @StateProperty
    public boolean myReturnsSet;

    public PostgresRoutine(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/postgres/PostgresRoutine", "<init>"));
        }
        super(schema, name);
    }

    @Override
    @NotNull
    public String[] getSpecItems() {
        String[] stringArray = RoutineUtil.makeSpecItemsByInArguments(this.arguments());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRoutine", "getSpecItems"));
        }
        return stringArray;
    }

    @Override
    public void setSpecItems(String[] specItems) {
        RoutineUtil.assignSpecItems(this.arguments(), specItems);
    }

    @Override
    public boolean isApplicableTo(String[] specItems) {
        return RoutineUtil.checkSpecItemsAreEqual(this.arguments(), specItems);
    }

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        String[] specItems = this.getSpecItems();
        int n = specItems.length;
        StringBuilder b = new StringBuilder(16 * (n + 1));
        String name = this.getNaturalNameOrNull();
        if (name != null) {
            b.append(name);
        } else {
            b.append('\uf001');
        }
        for (int j = 0; j < n; ++j) {
            b.append(specItems[j]);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRoutine", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public DbmArgument getOrCreateReturnArgument() {
        DbmArgument r = this.getReturnArgument();
        if (r == null) {
            r = this.arguments().create(null);
            r.setDirection(DasArgument.Direction.RETURN);
            this.setRoutineKind(DasRoutine.Kind.FUNCTION);
        }
        DbmArgument dbmArgument = r;
        if (dbmArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresRoutine", "getOrCreateReturnArgument"));
        }
        return dbmArgument;
    }

    public boolean isReturnsSet() {
        return this.myReturnsSet;
    }

    public void setReturnsSet(boolean returnsSet) {
        this.myReturnsSet = returnsSet;
    }
}

