/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.dbm.serialization.TimestampParsingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DbmSerializationUtil {
    static final String DATABASE_MODEL_ROOT_NODE_NAME = "database-model";
    private static final SimpleDateFormat FORMAL_TIMESTAMP_FORMAT_19 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
    private static final SimpleDateFormat FORMAL_TIMESTAMP_FORMAT_23 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss.SSS");

    DbmSerializationUtil() {
    }

    @Contract(value="null -> null")
    static String normalize(String string) {
        if (string == null) {
            return null;
        }
        String str = DbmSerializationUtil.safeRTrim(string);
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    @Contract(value="null -> null; !null -> !null")
    static String safeRTrim(String string) {
        int n;
        char c;
        int p;
        if (string == null) {
            return null;
        }
        for (p = n = string.length(); p > 0 && Character.isWhitespace(c = string.charAt(p - 1)) && c != '\n'; --p) {
        }
        return p == n ? string : string.substring(0, p);
    }

    @Contract(value="!null->!null;null->null")
    static String formatTimestamp(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        long t = timestamp.getTime();
        boolean withMillis = t / 1000L * 1000L != t;
        String result = withMillis ? DbmSerializationUtil.formatTimestampWithMilliSeconds(timestamp) : DbmSerializationUtil.formatTimestampWithSeconds(timestamp);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static String formatTimestampWithSeconds(Date timestamp) {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_19;
        // MONITORENTER : simpleDateFormat
        String string = FORMAL_TIMESTAMP_FORMAT_19.format(timestamp);
        // MONITOREXIT : simpleDateFormat
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmSerializationUtil", "formatTimestampWithSeconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static String formatTimestampWithMilliSeconds(Date timestamp) {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_23;
        // MONITORENTER : simpleDateFormat
        String string = FORMAL_TIMESTAMP_FORMAT_23.format(timestamp);
        // MONITOREXIT : simpleDateFormat
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmSerializationUtil", "formatTimestampWithMilliSeconds"));
    }

    @Nullable
    static Date parseTimestamp(String string) throws TimestampParsingException {
        if (string == null) {
            return null;
        }
        String str = string.trim();
        int n = str.length();
        try {
            switch (n) {
                case 19: {
                    return DbmSerializationUtil.parseTimestampWithSeconds(string);
                }
                case 23: {
                    return DbmSerializationUtil.parseTimestampWithMilliSeconds(string);
                }
                case 0: {
                    return null;
                }
            }
            throw new TimestampParsingException("The string '" + str + "' is not a valid date or timestamp: the string length is incorrect");
        }
        catch (ParseException pe) {
            throw new TimestampParsingException("The string '" + str + "' is not a valid date or timestamp: " + pe.getMessage(), pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseTimestampWithSeconds(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_19;
        synchronized (simpleDateFormat) {
            return FORMAL_TIMESTAMP_FORMAT_19.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseTimestampWithMilliSeconds(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_23;
        synchronized (simpleDateFormat) {
            return FORMAL_TIMESTAMP_FORMAT_23.parse(string);
        }
    }
}

