/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.Evaluator;
import com.intellij.sql.Preprocessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonPreprocessor
implements Preprocessor {
    private static final Pattern SCAN_PATTERN = Pattern.compile("#([A-Z][A-Z0-9_]+)(>>?\\s*)?|#\\[(\\w+)\\](>>?\\s*)?|:(\\w+)|:\\[\\s*(.+?)\\s*\\]|\\?|[\"'\\[]|/\\*.*?\\*/|--.*?(\\n|$)", 32);
    private static final Pattern COMPLEX_PARAMETER_PATTERN = Pattern.compile("(\\*{0,2})\\s*(\\w+)");
    @NotNull
    private final Evaluator myEvaluator;
    @NotNull
    private List<?> myFreeParameters;
    private boolean myAllowShortForm;
    private final ArrayList<Object> myBindableParameters;
    private static final char N_A = '\u0000';
    private static final List<?> EMPTY_FREE_PARAMETERS = Collections.emptyList();

    public CommonPreprocessor(@NotNull Evaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/sql/CommonPreprocessor", "<init>"));
        }
        this(false, evaluator);
    }

    public CommonPreprocessor(boolean allowShortForm, @NotNull Evaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/sql/CommonPreprocessor", "<init>"));
        }
        this.myFreeParameters = EMPTY_FREE_PARAMETERS;
        this.myAllowShortForm = false;
        this.myBindableParameters = new ArrayList();
        this.myEvaluator = evaluator;
        this.myAllowShortForm = allowShortForm;
    }

    public void setFreeParameters(@NotNull List<?> freeParameters) {
        if (freeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freeParameters", "com/intellij/sql/CommonPreprocessor", "setFreeParameters"));
        }
        this.myFreeParameters = freeParameters;
    }

    @Override
    @NotNull
    public String apply(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/CommonPreprocessor", "apply"));
        }
        this.myBindableParameters.clear();
        String string = this.process(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/CommonPreprocessor", "apply"));
        }
        return string;
    }

    @NotNull
    String process(@NotNull String originalText) {
        if (originalText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalText", "com/intellij/sql/CommonPreprocessor", "process"));
        }
        StringBuilder buf = new StringBuilder(originalText);
        boolean changed = false;
        int freeParametersCount = 0;
        Matcher m = SCAN_PATTERN.matcher(buf);
        boolean found = m.find();
        while (found) {
            int begin = m.start();
            int end = m.end();
            int[] next = new int[]{end};
            String something = m.group();
            assert (something != null && something.length() > 0);
            char c1 = something.charAt(0);
            char c_prior = begin > 0 ? buf.charAt(begin - 1) : (char)'\u0000';
            switch (c1) {
                case '#': {
                    boolean shortForm;
                    boolean bl = shortForm = m.group(1) != null;
                    if (c_prior == '#' || !this.myAllowShortForm && shortForm) break;
                    String macroName = CommonPreprocessor.coalesce(m.group(1), m.group(3));
                    String macroMarkerStr = CommonPreprocessor.coalesce(m.group(2), m.group(4), "").trim();
                    int macroMarker = macroMarkerStr.length();
                    switch (macroMarker) {
                        case 0: {
                            this.processMacroSubstitution(buf, macroName, begin, end, next);
                            break;
                        }
                        case 1: {
                            this.processMacroCondition(buf, macroName, true, begin, end, next);
                            break;
                        }
                        case 2: {
                            this.processMacroCondition(buf, macroName, false, begin, end, next);
                        }
                    }
                    changed = true;
                    break;
                }
                case ':': {
                    String complexDefinition;
                    if (c_prior == ':') break;
                    String simpleName = m.group(5);
                    if (simpleName != null && !simpleName.isEmpty()) {
                        this.processSimpleParameter(buf, simpleName, begin, end, next);
                        changed = true;
                    }
                    if ((complexDefinition = m.group(6)) == null || complexDefinition.isEmpty()) break;
                    this.processComplexParameter(buf, complexDefinition, begin, end, next);
                    changed = true;
                    break;
                }
                case '?': {
                    Object freeParameterValue = this.myFreeParameters.get(freeParametersCount++);
                    this.addParameterValue(freeParameterValue);
                    break;
                }
                case '\"': 
                case '\'': 
                case '[': {
                    CommonPreprocessor.skipQuotation(buf, c1, begin, next);
                    break;
                }
            }
            m = SCAN_PATTERN.matcher(buf);
            found = m.find(next[0]);
        }
        String string = changed ? buf.toString() : originalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/CommonPreprocessor", "process"));
        }
        return string;
    }

    private void processMacroSubstitution(StringBuilder buf, String name, int begin, int end, int[] next) {
        Object result = this.myEvaluator.evaluate(name);
        String subst = result != null ? result.toString() : "null";
        buf.replace(begin, end, subst);
        next[0] = begin;
    }

    private void processMacroCondition(StringBuilder buf, String name, boolean block, int macroBegin, int innerBegin, int[] next) {
        Object result = this.myEvaluator.evaluate(name);
        boolean presents = result != null;
        CommonPreprocessor.processMacroConditionInner(buf, presents, block, macroBegin, innerBegin, next);
    }

    private static void processMacroConditionInner(StringBuilder buf, boolean presents, boolean block, int macroBegin, int macroEnd, int[] next) {
        if (block) {
            int endMarkerPos = buf.indexOf("#.");
            if (endMarkerPos < 0) {
                buf.append("\n-- The macro-conditional block ").append(buf.substring(macroBegin, macroEnd)).append(" is not closed!\n");
                next[0] = buf.length();
                return;
            }
            if (presents) {
                buf.delete(endMarkerPos, endMarkerPos + 2);
                buf.delete(macroBegin, macroEnd);
                next[0] = macroBegin;
            } else {
                buf.replace(endMarkerPos, endMarkerPos + 2, "*/");
                buf.replace(macroBegin, macroEnd, "/* ");
                next[0] = endMarkerPos + 3 - (macroEnd - macroBegin);
            }
        } else if (presents) {
            buf.delete(macroBegin, macroEnd);
            next[0] = macroBegin;
        } else {
            buf.replace(macroBegin, macroEnd, "--  ");
            int lineEnd = buf.indexOf("\n", macroBegin + 4);
            if (lineEnd < 0) {
                lineEnd = buf.length();
            }
            next[0] = lineEnd;
        }
    }

    private void processSimpleParameter(StringBuilder buf, String name, int begin, int end, int[] next) {
        Object value = this.myEvaluator.evaluate(name);
        if (value != null) {
            buf.setCharAt(begin, '?');
            buf.delete(begin + 1, end);
            this.addParameterValue(value);
            next[0] = begin + 1;
        } else {
            buf.replace(begin, end, "null");
            next[0] = begin + 4;
        }
    }

    private void processComplexParameter(StringBuilder buf, String definition, int begin, int end, int[] next) {
        Matcher m = COMPLEX_PARAMETER_PATTERN.matcher(definition);
        boolean ok = m.matches();
        if (!ok) {
            buf.append("\n-- the complex parameter definition is invalid: ").append(definition);
            return;
        }
        String name = m.group(2);
        int arity = m.end(1) - m.start(1);
        switch (arity) {
            case 0: {
                this.processSimpleParameter(buf, name, begin, end, next);
                break;
            }
            case 1: {
                this.processParameterList(buf, name, begin, end, next);
                break;
            }
            case 2: {
                this.processParameterMatrix(buf, name, begin, end, next);
            }
        }
    }

    private void processParameterList(StringBuilder buf, String name, int begin, int end, int[] next) {
        Object value = this.myEvaluator.evaluate(name);
        if (!(value instanceof Iterable)) {
            buf.append("\n-- the complex parameter ").append(name).append(" is expected to be an Iterable.");
            return;
        }
        Iterable sequence = (Iterable)value;
        int n = 0;
        for (Object v : sequence) {
            this.addParameterValue(v);
            ++n;
        }
        String subst = n > 0 ? '?' + StringUtil.repeat((String)",?", (int)(n - 1)) : "null";
        buf.replace(begin, end, subst);
        next[0] = begin + subst.length();
    }

    private void processParameterMatrix(StringBuilder buf, String name, int begin, int end, int[] next) {
        throw new RuntimeException("Method CommonMacroProcessor.processParameterMatrix() is not implemented yet.");
    }

    private static void skipQuotation(StringBuilder buf, char beginQuote, int begin, int[] next) {
        String endQuote = beginQuote == '[' ? "]" : Character.toString(beginQuote);
        int lastPosition = buf.indexOf(endQuote, begin);
        next[0] = lastPosition >= begin ? lastPosition + 1 : buf.length();
    }

    private void addParameterValue(Object value) {
        this.myBindableParameters.add(value);
    }

    @Override
    @NotNull
    public Object[] getBindableParameters() {
        Object[] objectArray = this.myBindableParameters.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/CommonPreprocessor", "getBindableParameters"));
        }
        return objectArray;
    }

    @Contract(value="!null,_->!null; _,!null->!null; null,null->null", pure=true)
    private static String coalesce(@Nullable String str1, @Nullable String str2) {
        return str1 != null ? str1 : str2;
    }

    @Contract(value="_,!null,_->!null; _,_,!null->!null; null,null,null->null", pure=true)
    private static String coalesce(@Nullable String str1, @Nullable String str2, @Nullable String str3) {
        return str1 != null ? str1 : (str2 != null ? str2 : str3);
    }
}

