/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SqlFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlFindUsagesHandlerFactory", "canFindUsages"));
        }
        return element instanceof SqlDefinition;
    }

    public FindUsagesHandler createFindUsagesHandler(final @NotNull PsiElement psiElement, boolean forHighlightUsages) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/sql/SqlFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (psiElement instanceof SqlDefinition) {
            return new FindUsagesHandler(psiElement){

                @NotNull
                public PsiElement[] getSecondaryElements() {
                    SqlDefinition definition = (SqlDefinition)psiElement;
                    Collection<PsiElement> referencedElements = SqlImplUtil.getReferencedElements(definition);
                    referencedElements.remove(psiElement);
                    PsiElement[] psiElementArray = referencedElements.isEmpty() ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(referencedElements);
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFindUsagesHandlerFactory$1", "getSecondaryElements"));
                    }
                    return psiElementArray;
                }
            };
        }
        return null;
    }
}

